/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.util.InputUtils;
import org.richfaces.component.UIEditor;
import org.richfaces.renderkit.InputRendererBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorRendererBase
extends InputRendererBase {
    private static final String SPECIFIC_SCRIPT_RESOURCE_NAME = "org/richfaces/renderkit/html/1$1.js";
    private static final String SPECIFIC_XCSS_RESOURCE_NAME = "org/richfaces/renderkit/html/1$1.xcss";
    private static final String TINY_MCE_DISABLED_MODE = "source";

    protected Class<? extends UIComponent> getComponentClass() {
        return UIEditor.class;
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return InputUtils.getConvertedValue((FacesContext)context, (UIComponent)component, (Object)submittedValue);
    }

    protected String getConvertedStringValue(FacesContext context, UIEditor component, Object value) {
        return InputUtils.getConvertedStringValue((FacesContext)context, (UIComponent)component, (Object)value);
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context) + "TextArea";
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestParameterMap.get(clientId);
        if (null != newValue) {
            UIInput input = (UIInput)component;
            input.setSubmittedValue((Object)newValue);
        }
    }

    protected String getFormattedComponentStringValue(FacesContext context, UIEditor component) {
        String fieldValue = (String)component.getSubmittedValue();
        if (fieldValue == null) {
            fieldValue = this.getConvertedStringValue(context, component, component.getValue());
        }
        return fieldValue;
    }

    protected String getSriptMappingSuffix(FacesContext context) {
        return this.getResourceSuffix(context, SPECIFIC_SCRIPT_RESOURCE_NAME);
    }

    protected String getCssMappingSuffix(FacesContext context) {
        return this.getResourceSuffix(context, SPECIFIC_XCSS_RESOURCE_NAME);
    }

    private String getResourceSuffix(FacesContext context, String resourceName) {
        InternetResource resource = this.getResource(resourceName);
        String resourceUri = resource.getUri(context, null);
        String suffix = resourceUri.substring(resourceUri.indexOf(resourceName) + resourceName.length());
        if (suffix == null) {
            suffix = "";
        }
        return suffix;
    }

    public void writeEditorConfigurationParameters(FacesContext context, UIEditor component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.writeText((Object)"var tinyMceParams = ", null);
        String configName = component.getConfiguration();
        if (configName != null && configName.length() > 0) {
            Properties parameters = new Properties();
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                InputStream is = loader.getResourceAsStream(configName + ".properties");
                if (is == null) {
                    throw new FacesException("Editor configuration properties file with name '" + configName + "' was not found in class path");
                }
                parameters.load(is);
                writer.writeText((Object)this.convertProperties(parameters), null);
                writer.writeText((Object)";\n", null);
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        } else {
            writer.writeText((Object)"{};\n", null);
        }
    }

    public void writeEditorCustomPluginsParameters(FacesContext context, UIEditor component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String configName = component.getCustomPlugins();
        if (configName != null && configName.length() > 0) {
            Properties parameters = new Properties();
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                InputStream is = loader.getResourceAsStream(configName + ".properties");
                if (is == null) {
                    throw new FacesException("Editor configuration properties file with name '" + configName + "' was not found in class path");
                }
                parameters.load(is);
                writer.writeText((Object)"\n", null);
                writer.writeText((Object)this.getCustomPluginsCode(context, parameters), null);
                writer.writeText((Object)"\n", null);
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        }
    }

    private String convertProperties(Map map) {
        StringBuilder ret = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry entry : map.entrySet()) {
            if (!first) {
                ret.append(",\n");
            }
            ret.append(entry.getKey());
            ret.append(":");
            ret.append(entry.getValue());
            first = false;
        }
        return ret.append("} ").toString();
    }

    private String getCustomPluginsCode(FacesContext context, Map map) {
        StringBuilder ret = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            ret.append("tinymce.PluginManager.load('");
            ret.append(entry.getKey());
            ret.append("','");
            ret.append(context.getExternalContext().getRequestContextPath() + entry.getValue());
            ret.append("',null,{richfaces:true});");
        }
        return ret.toString();
    }

    public void writeEditorConfigurationAttributes(FacesContext context, UIEditor component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (component.getTheme() != null && component.getTheme().length() > 0) {
            writer.writeText((Object)("tinyMceParams.theme = " + ScriptUtils.toScript((Object)component.getTheme()) + ";\n"), null);
        }
        if (component.getLanguage() != null && component.getLanguage().length() > 0) {
            writer.writeText((Object)("tinyMceParams.language = " + ScriptUtils.toScript((Object)component.getLanguage()) + ";\n"), null);
        }
        writer.writeText((Object)("tinyMceParams.auto_resize = " + ScriptUtils.toScript((Object)component.isAutoResize()) + ";\n"), null);
        writer.writeText((Object)("tinyMceParams.readonly = " + ScriptUtils.toScript((Object)component.isReadonly()) + ";\n"), null);
        if (component.getPlugins() != null && component.getPlugins().length() > 0) {
            writer.writeText((Object)("tinyMceParams.plugins = " + ScriptUtils.toScript((Object)component.getPlugins()) + ";\n"), null);
        }
        if (component.getWidth() != null) {
            writer.writeText((Object)("tinyMceParams.width = " + ScriptUtils.toScript((Object)component.getWidth()) + ";\n"), null);
        }
        if (component.getHeight() != null) {
            writer.writeText((Object)("tinyMceParams.height = " + ScriptUtils.toScript((Object)component.getHeight()) + ";\n"), null);
        }
        if (component.getOninit() != null && component.getOninit().length() > 0) {
            writer.writeText((Object)("tinyMceParams.oninit = function (event) {\n" + component.getOninit() + "\n" + "};\n"), null);
        }
        if (component.getOnsave() != null && component.getOnsave().length() > 0) {
            writer.writeText((Object)("tinyMceParams.save_callback = function (event, element_id, html, body) {\n\t\treturn " + component.getOnsave() + "\n" + "};\n"), null);
        }
        if (component.getOnchange() != null && component.getOnchange().length() > 0) {
            writer.writeText((Object)("tinyMceParams.onchange_callback = function (event, inst) {\n" + component.getOnchange() + "\n" + "};\n"), null);
        }
        if (component.getOnsetup() != null && component.getOnsetup().length() > 0) {
            writer.writeText((Object)("tinyMceParams.setup = function (event, ed) {\n" + component.getOnsetup() + "\n" + "};\n"), null);
        }
        if (component.getDialogType() != null && component.getDialogType().length() > 0) {
            writer.writeText((Object)("tinyMceParams.dialog_type = " + ScriptUtils.toScript((Object)component.getDialogType()) + ";\n"), null);
        }
        if (component.getSkin() != null && component.getSkin().length() > 0) {
            writer.writeText((Object)("tinyMceParams.skin = " + ScriptUtils.toScript((Object)component.getSkin()) + ";\n"), null);
        } else {
            writer.writeText((Object)"if(!tinyMceParams.skin){\n", null);
            writer.writeText((Object)"\ttinyMceParams.skin = 'richfaces';\n", null);
            writer.writeText((Object)"}\n", null);
        }
        writer.writeText((Object)"if(tinyMceParams.strict_loading_mode == null){\n", null);
        writer.writeText((Object)"\ttinyMceParams.strict_loading_mode = true;\n", null);
        writer.writeText((Object)"}\n", null);
    }

    public void writeEditorParameters(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List children = component.getChildren();
        for (UIComponent child : children) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)child;
            StringBuilder b = new StringBuilder();
            b.append("tinyMceParams.");
            ScriptUtils.addEncoded((StringBuilder)b, (Object)parameter.getName());
            b.append(" = ");
            if (parameter.getValue() != null && (parameter.getValue().equals("true") || parameter.getValue().equals("false"))) {
                ScriptUtils.addEncoded((StringBuilder)b, (Object)parameter.getValue());
            } else {
                b.append(ScriptUtils.toScript((Object)parameter.getValue()));
            }
            b.append(";\n");
            writer.writeText((Object)b.toString(), null);
        }
    }

    public boolean shouldRenderTinyMCE(UIEditor component) {
        return component.getViewMode() == null || !component.getViewMode().equalsIgnoreCase(TINY_MCE_DISABLED_MODE);
    }

    public String getTextAreaStyle(UIEditor component) {
        StringBuilder b = new StringBuilder();
        if (component.getWidth() != null) {
            b.append("width: " + component.getWidth() + "px;");
        }
        if (component.getHeight() != null) {
            b.append("height: " + component.getHeight() + "px;");
        }
        return b.toString();
    }
}

