/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.taglib;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.MetaRule;
import com.sun.facelets.tag.MetaRuleset;
import com.sun.facelets.tag.MetaTagHandler;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.MetadataTarget;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.jsf.ComponentConfig;
import com.sun.facelets.tag.jsf.ComponentHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.richfaces.el.ELBuilder;
import org.richfaces.iterator.ForEachIterator;
import org.richfaces.iterator.SimpleForEachIterator;
import org.richfaces.taglib.ColumnTagHandler;
import org.richfaces.taglib.IndexedValueExpression;
import org.richfaces.taglib.IteratedExpression;
import org.richfaces.taglib.IteratedIndexExpression;
import org.richfaces.taglib.IteratedValueExpression;

public class ColumnsHandler
extends MetaTagHandler {
    ComponentHandler handler;
    public static final List<String> filterAttributes = new ArrayList<String>();
    public static final List<String> sortAttributes = new ArrayList<String>();
    private TagAttribute value;
    private TagAttribute columns;
    private TagAttribute begin;
    private TagAttribute var;
    private TagAttribute index;
    private TagAttribute end;
    private boolean rendered = true;
    ThreadLocal<IterationContext> iterationContextLocal = new ThreadLocal();

    public IterationContext getIterationContext() {
        return this.iterationContextLocal.get();
    }

    public ColumnsHandler(ComponentConfig config) {
        super((TagConfig)config);
        this.handler = new ColumnTagHandler(config){

            protected MetaRuleset createMetaRuleset(Class type) {
                MetaRuleset ruleset = super.createMetaRuleset(type);
                ruleset.addRule(new MetaRule(){

                    public Metadata applyRule(final String name, final TagAttribute attribute, MetadataTarget meta) {
                        if (filterAttributes.indexOf(name) != -1) {
                            return new Metadata(){

                                public void applyMetadata(FaceletContext ctx, Object instance) {
                                    if (!attribute.isLiteral()) {
                                        String expr = attribute.getValue();
                                        IterationContext itContext = ColumnsHandler.this.iterationContextLocal.get();
                                        ValueExpression ve = ELBuilder.createValueExpression(expr, Object.class, ctx.getExpressionFactory(), ctx.getFacesContext().getELContext(), itContext._itemId, itContext._indexId, itContext.getVarReplacement(), itContext.getIndexReplacement());
                                        ((UIComponent)instance).setValueExpression(name, ve);
                                    } else {
                                        ((UIComponent)instance).getAttributes().put(name, attribute.getValue());
                                    }
                                }
                            };
                        }
                        return null;
                    }
                });
                return ruleset;
            }
        };
    }

    private void initVariables(FaceletContext ctx) {
        this.initColumnsCount(ctx);
        this.initIndex(ctx);
        this.initVar(ctx);
        this.initBegin(ctx);
        this.initEnd(ctx);
    }

    private void prepare(FaceletContext ctx) {
        this.initVariables(ctx);
        IterationContext itContext = this.getIterationContext();
        try {
            this.value = this.getAttribute("value");
            itContext.valueExpr = ELBuilder.getVarReplacement(this.value.getValue());
            if (this.value != null) {
                itContext.rawItems = this.value.getObject(ctx);
                itContext.items = SimpleForEachIterator.supportedTypeForEachIterator(itContext.rawItems);
            } else {
                itContext.items = SimpleForEachIterator.beginEndForEachIterator(itContext._columns - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.correctFirst(ctx);
    }

    private void correctFirst(FaceletContext ctx) {
        IterationContext itContext = this.getIterationContext();
        if (itContext.items != null && itContext._begin > 0 && itContext._index < itContext._begin) {
            while (itContext._index < itContext._begin && this.hasNext()) {
                this.next(ctx);
            }
            if (!this.hasNext()) {
                itContext._index = 0;
            }
        }
    }

    private boolean hasNext() {
        IterationContext itContext = this.getIterationContext();
        try {
            if (itContext._end != 0) {
                return itContext._index < itContext._end ? itContext.items.hasNext() : false;
            }
            return itContext.items.hasNext();
        }
        catch (Exception e) {
            return false;
        }
    }

    private Object next(FaceletContext ctx) {
        IterationContext itContext = this.getIterationContext();
        try {
            Object o = itContext.items.next();
            IterationContext iterationContext = itContext;
            Integer n = iterationContext._index;
            Integer n2 = iterationContext._index = Integer.valueOf(iterationContext._index + 1);
            return o;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void initColumnsCount(FaceletContext ctx) {
        IterationContext itContext = this.getIterationContext();
        this.columns = this.getAttribute("columns");
        if (this.columns != null) {
            try {
                itContext._columns = Integer.parseInt((String)this.columns.getObject(ctx));
                if (itContext._columns < 0) {
                    itContext._columns = 0;
                }
            }
            catch (Exception e) {
                itContext._columns = 0;
            }
        } else {
            itContext._columns = 0;
        }
    }

    private void initBegin(FaceletContext ctx) {
        IterationContext itContext = this.getIterationContext();
        this.begin = this.getAttribute("begin");
        if (this.begin != null) {
            try {
                Object o = this.begin.getObject(ctx);
                if (o instanceof Number) {
                    itContext._begin = ((Number)o).intValue();
                } else if (o instanceof String) {
                    itContext._begin = Integer.parseInt((String)o);
                }
                IterationContext iterationContext = itContext;
                Integer n = iterationContext._begin;
                Integer n2 = iterationContext._begin = Integer.valueOf(iterationContext._begin - 1);
                if (itContext._begin < 0) {
                    itContext._begin = 0;
                }
            }
            catch (Exception e) {
                itContext._begin = 0;
            }
        } else {
            itContext._begin = 0;
        }
    }

    private void initEnd(FaceletContext ctx) {
        IterationContext itContext = this.getIterationContext();
        this.end = this.getAttribute("end");
        if (this.end != null) {
            try {
                Object o = this.end.getObject(ctx);
                if (o instanceof Number) {
                    itContext._end = ((Number)o).intValue();
                } else if (o instanceof String) {
                    itContext._end = Integer.parseInt((String)o);
                }
                if (itContext._end < 0) {
                    itContext._end = 0;
                }
            }
            catch (Exception e) {
                itContext._end = 0;
            }
        } else {
            itContext._end = 0;
        }
    }

    private void initVar(FaceletContext ctx) {
        IterationContext itContext = this.getIterationContext();
        this.var = this.getAttribute("var");
        if (this.var != null) {
            try {
                itContext._itemId = (String)this.var.getObject(ctx);
            }
            catch (ClassCastException e) {
                itContext._itemId = null;
            }
        }
    }

    private void initIndex(FaceletContext ctx) {
        IterationContext itContext = this.getIterationContext();
        this.index = this.getAttribute("index");
        if (this.index != null) {
            try {
                itContext._indexId = (String)this.index.getObject(ctx);
            }
            catch (ClassCastException e) {
                itContext._indexId = null;
            }
        }
    }

    private void initRendered(FaceletContext ctx) {
        TagAttribute renderedAttribute = this.getAttribute("rendered");
        if (renderedAttribute != null) {
            try {
                this.rendered = (Boolean)renderedAttribute.getObject(ctx);
            }
            catch (ClassCastException e) {
                this.rendered = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        this.initRendered(ctx);
        if (!this.rendered) {
            return;
        }
        IterationContext iterationContext = new IterationContext();
        this.iterationContextLocal.set(iterationContext);
        this.prepare(ctx);
        try {
            while (this.hasNext()) {
                this.exposeVariables(ctx);
                this.handler.apply(ctx, parent);
                this.next(ctx);
            }
        }
        catch (Exception e) {
        }
        finally {
            this.release();
            this.unExposeVariables(ctx);
        }
    }

    protected void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
    }

    private void onComponentCreated(UIComponent c) {
    }

    private void exposeVariables(FaceletContext ctx) {
        IterationContext itContext = this.getIterationContext();
        VariableMapper vm = ctx.getVariableMapper();
        int k = itContext._index;
        if (itContext._itemId != null && vm != null && this.value != null) {
            ValueExpression srcVE = this.value.getValueExpression(ctx, Object.class);
            ValueExpression ve = this.getVarExpression(ctx, srcVE);
            vm.setVariable(itContext._itemId, ve);
        }
        if (itContext._indexId != null && vm != null) {
            IteratedIndexExpression ve = new IteratedIndexExpression(k);
            vm.setVariable(itContext._indexId, (ValueExpression)ve);
        }
    }

    private void unExposeVariables(FaceletContext ctx) {
        IterationContext itContext = this.getIterationContext();
        VariableMapper vm = ctx.getVariableMapper();
        if (itContext._itemId != null && vm != null) {
            vm.setVariable(itContext._itemId, null);
        }
        if (itContext._indexId != null && vm != null) {
            vm.setVariable(itContext._indexId, null);
        }
    }

    private ValueExpression getVarExpression(FaceletContext ctx, ValueExpression expr) {
        IterationContext itContext = this.getIterationContext();
        Object o = expr.getValue(ctx.getFacesContext().getELContext());
        int k = itContext._index;
        if (o.getClass().isArray() || o instanceof List) {
            return new IndexedValueExpression(expr, k);
        }
        if (o instanceof Collection || o instanceof Iterator || o instanceof Enumeration || o instanceof Map || o instanceof String) {
            if (itContext.iteratedExpression == null) {
                itContext.iteratedExpression = new IteratedExpression(expr, ",");
            }
            return new IteratedValueExpression(itContext.iteratedExpression, k);
        }
        throw new ELException("FOREACH_BAD_ITEMS");
    }

    private void release() {
        IterationContext itContext = this.getIterationContext();
        itContext.items = null;
        itContext._index = 0;
    }

    static {
        filterAttributes.add("filterBy");
        filterAttributes.add("filterExpression");
        filterAttributes.add("filterValue");
        filterAttributes.add("filterEvent");
        sortAttributes.add("sortExpression");
    }

    class IterationContext {
        public ForEachIterator items;
        public Object rawItems;
        public String _indexId;
        public Integer _begin;
        public Integer _end;
        public Integer _columns;
        public String _itemId = null;
        public Integer _index = 0;
        public IteratedExpression iteratedExpression;
        public String valueExpr;

        IterationContext() {
        }

        public String getVarReplacement() {
            if (this.valueExpr == null) {
                return String.valueOf(ColumnsHandler.this.index);
            }
            if (this.items.getVarReplacement() != null) {
                return this.items.getVarReplacement();
            }
            return this.valueExpr + "[" + this._index + "]";
        }

        public String getIndexReplacement() {
            return String.valueOf(this._index);
        }
    }
}

