/**
 * License Agreement.
 *
 * Rich Faces - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.component;

import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;

public abstract class UIPickList extends UISelectMany{
	private String listClass;
	private String controlClass;
	private String moveControlsVerticalAlign;
	
	public abstract String getMoveControlsVerticalAlign();
	public abstract void setMoveControlsVerticalAlign(String moveControlsVerticalAlign);
	
	public abstract int getSize();
	public abstract void setSize(int size);
	
	public abstract boolean isDisabled();
	public abstract void setDisabled(boolean disabled);
	
	/**
	 * Get base clietntId of this component ( withowt iteration part )
	 * 
	 * @param faces
	 * @return
	 */
	public String getBaseClientId(FacesContext faces) {
		// Return any previously cached client identifier
		if (_baseClientId == null) {

			// Search for an ancestor that is a naming container
			UIComponent ancestorContainer = this;
			StringBuffer parentIds = new StringBuffer();
			while (null != (ancestorContainer = ancestorContainer.getParent())) {
				if (ancestorContainer instanceof NamingContainer) {
					parentIds.append(ancestorContainer.getClientId(faces))
							.append(NamingContainer.SEPARATOR_CHAR);
					break;
				}
			}
			String id = getId();
			if (null != id) {
				_baseClientId = parentIds.append(id).toString();
			} else {
				_baseClientId = parentIds.append(
						faces.getViewRoot().createUniqueId()).toString();
			}
		}
		return (_baseClientId);

	}
	private String _baseClientId = null;
	
	public abstract String getControlClass();
	public abstract void setControlClass(String controlClass);
	
	public abstract String getListClass();
	public abstract void setListClass(String listClass);
	
}
