package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.LayoutPosition;
import org.richfaces.component.UILayoutPanel;

public class HtmlLayoutPanel extends UILayoutPanel{

public final static  String COMPONENT_FAMILY = "org.richfaces.LayoutPanel";

public final static  String COMPONENT_TYPE = "org.richfaces.LayoutPanel";

/*
* 
*/
private  LayoutPosition _position = null;


public HtmlLayoutPanel(){
setRendererType("org.richfaces.LayoutPanelRenderer");
}

public LayoutPosition getPosition(){
	if (this._position != null) {
		return this._position;
	}
	ValueExpression ve = getValueExpression("position");
	if (ve != null) {
	    LayoutPosition value = null;
	    
	    try {
			value = (LayoutPosition) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setPosition(LayoutPosition _position){
this._position = _position;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[2];
state[0] = super.saveState(context);
state[1] = saveAttachedState(context, _position);
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_position = (LayoutPosition)restoreAttachedState(context, states[1]);
	
}

}
