/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResource;
//
//
//


import org.richfaces.renderkit.ColorPickerRendererBase;



/**
 * Renderer for component class org.richfaces.renderkit.html.ColorPickerRenderer
 */
public class ColorPickerRenderer extends ColorPickerRendererBase {

	public ColorPickerRenderer () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] scripts = {
						getResource("/org/richfaces/renderkit/html/scripts/jquery/jquery.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/pngFix.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/ui.core.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/ui.colorpicker.js")
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	private final InternetResource[] styles = {
						getResource("/org/richfaces/renderkit/html/css/colorPicker.xcss")
	};

private InternetResource[] stylesAll = null;

protected InternetResource[] getStyles() {
	synchronized (this) {
		if (stylesAll == null) {
			InternetResource[] rsrcs = super.getStyles();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = styles == null || styles.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					stylesAll = new InternetResource[0];	
				} else {
					stylesAll = styles;
				}
			} else {
				if (ignoreThis) {
					stylesAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < styles.length; i++ ) {
						rsrcsSet.add(styles[i]);
					}

					stylesAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return stylesAll;
}
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	private boolean isEmpty(Object o) {
		if (null == o) {
			return true;
		}
		if (o instanceof String ) {
			return (0 == ((String)o).length());
		}
		if (o instanceof Collection) {
			return (0 == ((Collection)o).size());
		}
		if (o instanceof Map) {
			return (0 == ((Map)o).size());
		}
		if (o.getClass().isArray()) {
			return (0 == ((Object [])o).length);
		}
		return false;
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIColorPicker.class;
	}


	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIColorPicker component, ComponentVariables variables) throws IOException {
	  java.lang.String clientId = component.getClientId(context);
variables.setVariable("arrow", getResource( "/org/richfaces/renderkit/html/images/arrow.gif" ).getUri(context, component) );

variables.setVariable("rainbow", getResource( "/org/richfaces/renderkit/html/images/rainbow.png" ).getUri(context, component) );

java.lang.String showEvent  = "" ;
java.lang.String clientIdJquery  = "" ;
java.lang.String colorMode  = "" ;
java.lang.String value  = "" ;
addPopupToAjaxRendered(context, component);

writer.startElement("span", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-span" );
						getUtils().writeAttribute(writer, "id", clientId );
			//
// pass thru attributes
//
getUtils().encodeAttributesFromArray(context,component,new String[] {
    "dir" ,
	    "lang" ,
	    "onclick" ,
	    "ondblclick" ,
	    "onkeydown" ,
	    "onkeypress" ,
	    "onkeyup" ,
	    "onmousedown" ,
	    "onmousemove" ,
	    "onmouseout" ,
	    "onmouseover" ,
	    "onmouseup" ,
	    "title" ,
	    "xml:lang" });
//
//
//

writer.startElement("input", component);
			getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "readonly", "readonly" );
						getUtils().writeAttribute(writer, "type", "text" );
						getUtils().writeAttribute(writer, "value", getInputValue(context,component) );
			
writer.endElement("input");

			if(component.getFacet("icon")!=null && component.getFacet("icon").isRendered()) {
		
UIComponent indexChildren_1 = component.getFacet("icon");
if (null != indexChildren_1 && indexChildren_1 .isRendered()) {
	renderChild(context, indexChildren_1);
}


			
			}else{
			
		
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-icon " + convertToString(component.getAttributes().get("iconClass")) );
						getUtils().writeAttribute(writer, "src", variables.getVariable("arrow") );
						getUtils().writeAttribute(writer, "style", component.getAttributes().get("iconStyle") );
						getUtils().writeAttribute(writer, "vertical-align", "middle" );
			
writer.endElement("img");

			
			}
			
		
writer.endElement("span");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-wrapper" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "-colorPicker-popup" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-ext" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-color" );
			
writer.startElement("div", component);

writer.startElement("div", component);

writer.endElement("div");
writer.endElement("div");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-rainbow" );
			
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "alt", "rainbow" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("rainbow") );
			
writer.endElement("img");

			if(component.getFacet("arrows")!=null && component.getFacet("arrows").isRendered()) {
		
UIComponent indexChildren_2 = component.getFacet("arrows");
if (null != indexChildren_2 && indexChildren_2 .isRendered()) {
	renderChild(context, indexChildren_2);
}


			
			}else{
			
		
writer.startElement("div", component);

writer.endElement("div");

			
			}
			
		
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-new-color" );
			
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-current-color" );
			
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-hex-wrapper" );
			
writer.startElement("label", component);
			getUtils().writeAttribute(writer, "for", "rich-colorPicker-hex-wrapper" );
						getUtils().writeAttribute(writer, "title", "hex" );
			
writer.writeText(convertToString("#:"),null);

writer.endElement("label");
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-colors-input" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "-colorPicker-hex" );
						getUtils().writeAttribute(writer, "maxlength", "6" );
						getUtils().writeAttribute(writer, "size", "6" );
						getUtils().writeAttribute(writer, "type", "text" );
			
writer.endElement("input");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-rgb-wrapper rich-colorPicker-rgb-r" );
			
writer.startElement("label", component);
			getUtils().writeAttribute(writer, "for", "rgb" );
			
writer.writeText(convertToString("R:"),null);

writer.endElement("label");
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-colors-input" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "-colorPicker-rgb-r" );
						getUtils().writeAttribute(writer, "maxlength", "3" );
						getUtils().writeAttribute(writer, "size", "2" );
						getUtils().writeAttribute(writer, "type", "text" );
			
writer.endElement("input");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-rgb-wrapper rich-colorPicker-rgb-g" );
			
writer.startElement("label", component);
			getUtils().writeAttribute(writer, "for", "rgb-g" );
			
writer.writeText(convertToString("G:"),null);

writer.endElement("label");
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-colors-input" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "-colorPicker-rgb-g" );
						getUtils().writeAttribute(writer, "maxlength", "3" );
						getUtils().writeAttribute(writer, "size", "2" );
						getUtils().writeAttribute(writer, "type", "text" );
			
writer.endElement("input");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-rgb-wrapper rich-colorPicker-rgb-b" );
			
writer.startElement("label", component);
			getUtils().writeAttribute(writer, "for", "rgb-b" );
			
writer.writeText(convertToString("B:"),null);

writer.endElement("label");
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-colors-input" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "-colorPicker-rgb-b" );
						getUtils().writeAttribute(writer, "maxlength", "3" );
						getUtils().writeAttribute(writer, "size", "2" );
						getUtils().writeAttribute(writer, "type", "text" );
			
writer.endElement("input");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-hsb-h rich-colorPicker-hsb-wrapper" );
			
writer.startElement("label", component);
			getUtils().writeAttribute(writer, "for", "hsb-h" );
			
writer.writeText(convertToString("H:"),null);

writer.endElement("label");
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-colors-input" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "-colorPicker-hsb-h" );
						getUtils().writeAttribute(writer, "maxlength", "3" );
						getUtils().writeAttribute(writer, "size", "2" );
						getUtils().writeAttribute(writer, "type", "text" );
			
writer.endElement("input");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-hsb-s rich-colorPicker-hsb-wrapper" );
			
writer.startElement("label", component);
			getUtils().writeAttribute(writer, "for", "hsb-s" );
			
writer.writeText(convertToString("S:"),null);

writer.endElement("label");
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-colors-input" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "-colorPicker-hsb-s" );
						getUtils().writeAttribute(writer, "maxlength", "3" );
						getUtils().writeAttribute(writer, "size", "2" );
						getUtils().writeAttribute(writer, "type", "text" );
			
writer.endElement("input");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-hsb-b rich-colorPicker-hsb-wrapper" );
			
writer.startElement("label", component);
			getUtils().writeAttribute(writer, "for", "hsb-b" );
			
writer.writeText(convertToString("B:"),null);

writer.endElement("label");
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-colors-input" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "-colorPicker-hsb-b" );
						getUtils().writeAttribute(writer, "maxlength", "3" );
						getUtils().writeAttribute(writer, "size", "2" );
						getUtils().writeAttribute(writer, "type", "text" );
			
writer.endElement("input");
writer.endElement("div");
writer.startElement("button", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-submit" );
						getUtils().writeAttribute(writer, "name", "submit" );
						getUtils().writeAttribute(writer, "type", "button" );
			
writer.writeText(convertToString("Apply"),null);

writer.endElement("button");
writer.startElement("button", component);
			getUtils().writeAttribute(writer, "class", "rich-colorPicker-cancel" );
						getUtils().writeAttribute(writer, "name", "cancel" );
						getUtils().writeAttribute(writer, "type", "button" );
			
writer.writeText(convertToString("Cancel"),null);

writer.endElement("button");
writer.endElement("div");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "-colorPicker-script" );
						getUtils().writeAttribute(writer, "style", "display: none;" );
			
writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString("if(navigator.appName == \"Microsoft Internet Explorer\" && parseInt(navigator.appVersion) == 4 && navigator.appVersion.indexOf(\"MSIE 7.0\") == -1){\n				jQuery('div.rich-colorPicker-color').pngFix();\n			}"),null);


		Boolean flat = (Boolean) component.getAttributes().get("flat");
		colorMode = (String) component.getAttributes().get("colorMode");
		showEvent = (String) component.getAttributes().get("showEvent");
		value = (String) component.getAttributes().get("value");
		
		if (value == null || value == ""){
			value = "#ffffff";
		}
		
		if(showEvent.startsWith("on")){
			showEvent = showEvent.substring(2);	
		}
		clientIdJquery = convertToString(clientId);
		clientIdJquery = clientIdJquery.replace(":", "\\\\:");

		colorMode = colorMode.toLowerCase();
		java.util.regex.Pattern pattern = java.util.regex.Pattern.compile("\\s+");
		colorMode = pattern.matcher(colorMode).replaceAll("");

		boolean disabled = getUtils().isBooleanAttribute(component, "disabled");
		variables.setVariable("disabled",new Boolean(disabled));
	
writer.writeText(convertToString("jQuery('#" + convertToString(clientIdJquery) + "').colorPicker({ \n				flat: " + convertToString(component.getAttributes().get("flat")) + ",\n				color: \"" + convertToString(value) + "\",\n				showEvent: \"" + convertToString(showEvent) + "\",\n				clientId: '#" + convertToString(clientIdJquery) + "',\n				submit: function(e, ui) { \n					switch(\"" + convertToString(colorMode) + "\"){\n						case \"hex\":\n					        jQuery('#" + convertToString(clientIdJquery) + " input').val(ui.hex);\n							break;    \n						case \"rgb\":\n							jQuery('#" + convertToString(clientIdJquery) + " input').val(ui.rgb);\n							break;\n						default:\n							jQuery('#" + convertToString(clientIdJquery) + " input').val(ui.hex);\n					}\n		    	} \n			});"),null);

writer.endElement("script");
writer.endElement("div");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIColorPicker)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
