/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
//
//
//


import org.richfaces.renderkit.NodeRendererBase;



/**
 * Renderer for component class org.richfaces.renderkit.html.TreeNodeRenderer
 */
public class TreeNodeRenderer extends NodeRendererBase {

	public TreeNodeRenderer () {
		super();
	}

	// 
	// Declarations
	//
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	private boolean isEmpty(Object o) {
		if (null == o) {
			return true;
		}
		if (o instanceof String ) {
			return (0 == ((String)o).length());
		}
		if (o instanceof Collection) {
			return (0 == ((Collection)o).size());
		}
		if (o instanceof Map) {
			return (0 == ((Map)o).size());
		}
		if (o.getClass().isArray()) {
			return (0 == ((Object [])o).length);
		}
		return false;
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UITreeNode.class;
	}

	
	public void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component ) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeBegin(writer, context, (org.richfaces.component.UITreeNode)component, variables );
	}		

	public void doEncodeBegin(ResponseWriter writer, FacesContext context, org.richfaces.component.UITreeNode component, ComponentVariables variables ) throws IOException {
	    java.lang.String clientId = component.getClientId(context);
variables.setVariable("spacer", getResource( "images/spacer.gif" ).getUri(context, component) );

variables.setVariable("collapsed", getResource( "org.richfaces.renderkit.html.images.TreePlusImage" ).getUri(context, component) );

variables.setVariable("expanded", getResource( "org.richfaces.renderkit.html.images.TreeMinusImage" ).getUri(context, component) );

variables.setVariable("folderIcon", getResource( "images/iconFolder.gif" ).getUri(context, component) );

variables.setVariable("leafIcon", getResource( "images/iconLeaf.gif" ).getUri(context, component) );

initializeLines(context, component);

initializeResources(context, component);

boolean leaf  = component.getUITree().isLeaf() ;
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "dr-tree-full-width rich-tree-node" );
						getUtils().writeAttribute(writer, "id", clientId );
			
writer.startElement("tbody", component);

writer.startElement("tr", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":mainRow" );
						getUtils().writeAttribute(writer, "onclick", convertToString(component.getAttributes().get("onclick")) + " " + convertToString( (  ( ! leaf )  ? getToggleScript(context,component,"mainRow") : "" ) ) );
			//
// pass thru attributes
//
getUtils().encodeAttributesFromArray(context,component,new String[] {
    "align" ,
	    "bgcolor" ,
	    "char" ,
	    "charoff" ,
	    "dir" ,
	    "lang" ,
	    "ondblclick" ,
	    "onkeydown" ,
	    "onkeypress" ,
	    "onkeyup" ,
	    "onmousedown" ,
	    "onmousemove" ,
	    "onmouseout" ,
	    "onmouseover" ,
	    "onmouseup" ,
	    "style" ,
	    "title" ,
	    "valign" ,
	    "xml:lang" });
//
//
//

encodeAttributeParameters(context, component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "dr-tree-h-ic rich-tree-node-handleicon " + convertToString(variables.getVariable("line")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":handles" );
			

				
					if (Boolean.TRUE.equals(component.getAttributes().get("isAjaxUpdateRoot")) && component.getUITree().isShowConnectingLines()) {
						String lineBasic = getResource("org.richfaces.renderkit.html.images.TreeLineNodeImage").getUri(context, component);
						String lineLast = getResource("org.richfaces.renderkit.html.images.TreeLineLastImage").getUri(context, component);
						getUtils().writeAttribute(writer, "style", 
								"background-image:expression(this.parentNode.parentNode.parentNode.nextSibling.nextSibling ? " +
										"'url(" + lineBasic + ")' : 'url(" + lineLast + ")')");
					}
				
			
writer.startElement("div", component);


					
						if (leaf) {
					
				
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "alt", "" );
						getUtils().writeAttribute(writer, "class", "dr-tree-h-ic-img-md dr-tree-h-ic-img" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":handle:img" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("spacer") );
			
writer.endElement("img");

					
						} else {
					
				
writer.startElement("a", component);
			getUtils().writeAttribute(writer, "href", "#" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":handle" );
						getUtils().writeAttribute(writer, "onclick", convertToString(getToggleScript(context,component,"handle")) + " return false;" );
			

						
								UIComponent iconCollapsedFacet = component.getIconCollapsedFacet();
								if (iconCollapsedFacet != null && iconCollapsedFacet.isRendered()) {
						 
				
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "class", "dr-tree-pointer-cursor dr-tree-h-ic-img-md dr-tree-h-ic-img dr-tree-h-ic-facets rich-tree-node-handleicon-collapsed" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":handle:img:collapsed" );
						getUtils().writeAttribute(writer, "style", getHandleCollapsedDisplayStyle(context,component) );
			

					
										renderChild(context, iconCollapsedFacet);
					
				
writer.endElement("span");

						
								} else {
						
				
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "alt", "" );
						getUtils().writeAttribute(writer, "class", "dr-tree-pointer-cursor dr-tree-h-ic-img-md dr-tree-h-ic-img rich-tree-node-handleicon-collapsed" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":handle:img:collapsed" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("collapsed") );
						getUtils().writeAttribute(writer, "style", convertToString(getHandleCollapsedDisplayStyle(context,component)) + ";border:0" );
			
writer.endElement("img");

						
								}
						 
				

						
								UIComponent iconExpandedFacet = component.getIconExpandedFacet();
								if (iconExpandedFacet != null && iconExpandedFacet.isRendered()) {
						 
				
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "class", "dr-tree-pointer-cursor dr-tree-h-ic-img-md dr-tree-h-ic-img dr-tree-h-ic-facets rich-tree-node-handleicon-expanded" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":handle:img:expanded" );
						getUtils().writeAttribute(writer, "style", getHandleExpandedDisplayStyle(context,component) );
			

					
										renderChild(context, iconExpandedFacet);
					
				
writer.endElement("span");

						
								} else {
						 
				
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "alt", "" );
						getUtils().writeAttribute(writer, "class", "dr-tree-pointer-cursor dr-tree-h-ic-img-md dr-tree-h-ic-img rich-tree-node-handleicon-expanded" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":handle:img:expanded" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("expanded") );
						getUtils().writeAttribute(writer, "style", convertToString(getHandleExpandedDisplayStyle(context,component)) + ";border:0" );
			
writer.endElement("img");

						
								}
						 
				
writer.endElement("a");

					
						}
					
				

					
						if (org.richfaces.component.UITree.SWITCH_CLIENT.equals(component.getUITree().getSwitchType())) {
					
				
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "class", "dr-tree-h-input" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "NodeExpanded" );
						getUtils().writeAttribute(writer, "name", convertToString(clientId) + "NodeExpanded" );
						getUtils().writeAttribute(writer, "type", "hidden" );
						getUtils().writeAttribute(writer, "value", getExpandedValue(context,component) );
			
writer.endElement("input");

					
						}
					
				
writer.endElement("div");
writer.endElement("td");

				
				String iconClass = "rich-tree-node-icon";				         
				if (leaf) {
					iconClass += "-leaf";
				}
				variables.setVariable("iconClass",iconClass);
				
			
org.richfaces.renderkit.NodeRendererBase.DnDOptionsHolder scriptOptionsMap  = getScriptOptions(context,component) ;
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "dr-tree-h-ic " + convertToString(variables.getVariable("iconClass")) + " " + convertToString(variables.getVariable("lineFirst")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":icon" );
						getUtils().writeAttribute(writer, "rich:ajaxselectedlistener", getAjaxSelectedListenerFlag(context,component) );
						getUtils().writeAttribute(writer, "rich:dragcursoroptions", scriptOptionsMap.getDragCursorOptions() );
						getUtils().writeAttribute(writer, "rich:draggableoptions", scriptOptionsMap.getDragOptions() );
						getUtils().writeAttribute(writer, "rich:dropcursoroptions", scriptOptionsMap.getDropCursorOptions() );
						getUtils().writeAttribute(writer, "rich:dropzoneoptions", scriptOptionsMap.getDropOptions() );
						getUtils().writeAttribute(writer, "rich:oncollapse", component.getAttributes().get("oncollapse") );
						getUtils().writeAttribute(writer, "rich:oncontextmenu", component.getAttributes().get("oncontextmenu") );
						getUtils().writeAttribute(writer, "rich:onexpand", component.getAttributes().get("onexpand") );
						getUtils().writeAttribute(writer, "rich:onselected", component.getAttributes().get("onselected") );
			

				
				if (leaf) {
					UIComponent leafFacet = component.getIconLeafFacet();
					if (leafFacet != null && leafFacet.isRendered()) {

				
			
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "class", "dr-tree-h-ic-img-md dr-tree-h-ic-img dr-tree-h-ic-facets" );
			

							
								renderChild(context, leafFacet);
							
						
writer.endElement("span");

				
					} else {
				
			
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "alt", "" );
						getUtils().writeAttribute(writer, "class", "dr-tree-h-ic-img-md dr-tree-h-ic-img" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("leafIcon") );
			
writer.endElement("img");

				
					}
				
			

				
				} else {
					UIComponent iconFacet = component.getIconFacet();
					if (iconFacet != null && iconFacet.isRendered()) {
				
			
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "class", "dr-tree-h-ic-img-md dr-tree-h-ic-img dr-tree-h-ic-facets" );
			

								
									renderChild(context, iconFacet);
								
							
writer.endElement("span");

				
					} else {
				
			
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "alt", "" );
						getUtils().writeAttribute(writer, "class", "dr-tree-h-ic-img-md dr-tree-h-ic-img" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("folderIcon") );
			
writer.endElement("img");

				
					}
				}
				
			
writer.endElement("td");
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "dr-tree-h-text rich-tree-node-text " + convertToString(component.getAttributes().get("nodeClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":text" );
						getUtils().writeAttribute(writer, "rich:highlightedclass", variables.getVariable("highlightedClass") );
						getUtils().writeAttribute(writer, "rich:selectedclass", variables.getVariable("selectedClass") );
			

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UITreeNode component, ComponentVariables variables) throws IOException {
	  
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UITreeNode)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
