/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
//
//
//


import org.richfaces.renderkit.AbstractPageRenderer;



/**
 * Renderer for component class org.richfaces.renderkit.html.VioletRaysRenderer
 */
public class VioletRaysRenderer extends AbstractPageRenderer {

	public VioletRaysRenderer () {
		super();
	}

	// 
	// Declarations
	//
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	private boolean isEmpty(Object o) {
		if (null == o) {
			return true;
		}
		if (o instanceof String ) {
			return (0 == ((String)o).length());
		}
		if (o instanceof Collection) {
			return (0 == ((Collection)o).size());
		}
		if (o instanceof Map) {
			return (0 == ((Map)o).size());
		}
		if (o.getClass().isArray()) {
			return (0 == ((Object [])o).length);
		}
		return false;
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIPage.class;
	}

	
	public void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component ) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeBegin(writer, context, (org.richfaces.component.UIPage)component, variables );
	}		

	public void doEncodeBegin(ResponseWriter writer, FacesContext context, org.richfaces.component.UIPage component, ComponentVariables variables ) throws IOException {
	    variables.setVariable("namespace", prolog(context,component) );
writer.startElement("html", component);
			getUtils().writeAttribute(writer, "lang", context.getViewRoot().getLocale() );
						getUtils().writeAttribute(writer, "xmlns", variables.getVariable("namespace") );
			
writer.startElement("head", component);

writer.startElement("meta", component);
			getUtils().writeAttribute(writer, "content", "text/html; charset=utf-8" );
						getUtils().writeAttribute(writer, "http-equiv", "content-type" );
			
writer.endElement("meta");
writer.startElement("title", component);

writer.writeText(convertToString(component.getAttributes().get("pageTitle")),null);

writer.endElement("title");
themeStyle(context, component);

themeScript(context, component);

UIComponent indexChildren_45 = component.getFacet("pageHeader");
if (null != indexChildren_45 && indexChildren_45 .isRendered()) {
	renderChild(context, indexChildren_45);
}

writer.endElement("head");
writer.startElement("body", component);
//
// pass thru attributes
//
getUtils().encodeAttributesFromArray(context,component,new String[] {
    "alink" ,
	    "background" ,
	    "bgcolor" ,
	    "dir" ,
	    "lang" ,
	    "link" ,
	    "onclick" ,
	    "ondblclick" ,
	    "onkeydown" ,
	    "onkeypress" ,
	    "onkeyup" ,
	    "onload" ,
	    "onmousedown" ,
	    "onmousemove" ,
	    "onmouseout" ,
	    "onmouseover" ,
	    "onmouseup" ,
	    "onunload" ,
	    "style" ,
	    "text" ,
	    "title" ,
	    "vlink" ,
	    "xml:lang" });
//
//
//

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", "wrapper" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", "header" );
			
if ( Boolean.valueOf( String.valueOf(hasFacet(component,"header")) ).booleanValue() ) {


writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-header " + convertToString(component.getAttributes().get("headerClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(variables.getVariable("clientId")) + ":hd" );
			
UIComponent indexChildren_46 = component.getFacet("header");
if (null != indexChildren_46 && indexChildren_46 .isRendered()) {
	renderChild(context, indexChildren_46);
}

writer.endElement("div");
}
writer.endElement("div");
writer.writeComment(convertToString(" end #header "));

writer.writeComment(convertToString("div id=\"logo\""));

writer.writeComment(convertToString("/div"));

writer.startElement("hr", component);

writer.endElement("hr");
writer.writeComment(convertToString(" end #logo "));

writer.writeComment(convertToString(" end #header-wrapper "));

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", "page" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", "content" );
			

	}		
	
    public void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeChildren(writer, context, (org.richfaces.component.UIPage)component, variables );
	}		

    public void doEncodeChildren(ResponseWriter writer, FacesContext context, org.richfaces.component.UIPage component, ComponentVariables variables) throws IOException {
	    
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-body " + convertToString(component.getAttributes().get("bodyClass")) );
			
renderChildren(context, component);

writer.endElement("div");

	}		

	/* (non-Javadoc)
	 * @see javax.faces.render.Renderer#getRendersChildren()
	 */
	public boolean getRendersChildren() {
		return true;
	}

	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIPage component, ComponentVariables variables) throws IOException {
	  
writer.endElement("div");
writer.writeComment(convertToString(" end #content "));

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", "sidebar" );
			
if ( Boolean.valueOf( String.valueOf(hasFacet(component,"sidebar")) ).booleanValue() ) {


writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-sidebar " + convertToString(component.getAttributes().get("styleClass")) );
			
UIComponent indexChildren_47 = component.getFacet("sidebar");
if (null != indexChildren_47 && indexChildren_47 .isRendered()) {
	renderChild(context, indexChildren_47);
}

writer.endElement("div");
}
writer.endElement("div");
writer.writeComment(convertToString(" end #sidebar "));

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "style", "clear: both;" );
			
writer.endElement("div");
writer.endElement("div");
writer.writeComment(convertToString(" end #page "));

writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", "footer" );
			
if ( Boolean.valueOf( String.valueOf(hasFacet(component,"footer")) ).booleanValue() ) {


java.lang.String clientId = component.getClientId(context);
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-footer " + convertToString(component.getAttributes().get("footerClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":ft" );
			
UIComponent indexChildren_48 = component.getFacet("footer");
if (null != indexChildren_48 && indexChildren_48 .isRendered()) {
	renderChild(context, indexChildren_48);
}

writer.endElement("div");
}
writer.endElement("div");
writer.writeComment(convertToString(" end #footer "));

writer.endElement("body");
writer.endElement("html");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIPage)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
