/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.richfaces.component.LayoutPosition;
import org.richfaces.component.UILayout;
import org.richfaces.component.UILayoutPanel;

public abstract class AbstractLayoutRenderer
extends HeaderResourcesRendererBase {
    public void renderLayout(FacesContext context, UILayout layout) throws IOException {
        UILayoutPanel top = null;
        UILayoutPanel bottom = null;
        UILayoutPanel left = null;
        UILayoutPanel right = null;
        UILayoutPanel center = null;
        int columns = 0;
        for (UIComponent child : layout.getChildren()) {
            if (!(child instanceof UILayoutPanel)) continue;
            UILayoutPanel layoutPanel = (UILayoutPanel)child;
            LayoutPosition position = layoutPanel.getPosition();
            if (LayoutPosition.top.equals((Object)position)) {
                if (null != top) {
                    throw new FacesException("Duplicate layoutPanel's with same position" + (Object)((Object)position));
                }
                top = layoutPanel;
                continue;
            }
            if (LayoutPosition.bottom.equals((Object)position)) {
                if (null != bottom) {
                    throw new FacesException("Duplicate layoutPanel's with same position" + (Object)((Object)position));
                }
                bottom = layoutPanel;
                continue;
            }
            if (LayoutPosition.left.equals((Object)position)) {
                if (null != left) {
                    throw new FacesException("Duplicate layoutPanel's with same position" + (Object)((Object)position));
                }
                left = layoutPanel;
                ++columns;
                continue;
            }
            if (LayoutPosition.right.equals((Object)position)) {
                if (null != right) {
                    throw new FacesException("Duplicate layoutPanel's with same position" + (Object)((Object)position));
                }
                right = layoutPanel;
                ++columns;
                continue;
            }
            if (null != position && !LayoutPosition.center.equals((Object)position)) continue;
            if (null != center) {
                throw new FacesException("Duplicate layoutPanel's with same position" + (Object)((Object)position));
            }
            center = layoutPanel;
            ++columns;
        }
        if (columns > 0 && null == center) {
            throw new FacesException("Center layout panel for multi-column layout is not defined");
        }
        ResponseWriter writer = context.getResponseWriter();
        if (null != top) {
            this.renderChild(context, (UIComponent)top);
        }
        if (columns > 1) {
            writer.startElement("div", (UIComponent)layout);
            String yahooClass = "yui-g";
            if (columns > 2) {
                yahooClass = "yui-gb";
            } else {
                Object width = center.getAttributes().get("width");
                if ("75%".equals(width)) {
                    yahooClass = "yui-gc";
                } else if ("66%".equals(width)) {
                    yahooClass = "yui-gd";
                }
            }
            writer.writeAttribute("class", (Object)yahooClass, null);
            if (null != left) {
                left.getAttributes().put("first", "first");
                center.getAttributes().remove("first");
                this.renderChild(context, (UIComponent)left);
            } else {
                center.getAttributes().put("first", "first");
            }
            this.renderChild(context, (UIComponent)center);
            if (null != right) {
                right.getAttributes().remove("first");
                this.renderChild(context, (UIComponent)right);
            }
            writer.endElement("div");
        } else if (columns == 1) {
            this.renderChild(context, (UIComponent)center);
        }
        if (null != bottom) {
            this.renderChild(context, (UIComponent)bottom);
        }
    }
}

