/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.RendererBase;
import org.richfaces.component.MenuComponent;
import org.richfaces.component.UIMenuItem;
import org.richfaces.component.util.ViewUtil;
import org.richfaces.renderkit.CompositeRenderer;
import org.richfaces.renderkit.html.MenuItemRendererDelegate;

public class MenuItemRendererBase
extends CompositeRenderer {
    private MenuItemRendererDelegate delegate = new MenuItemRendererDelegate();

    protected Class getComponentClass() {
        return UIMenuItem.class;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void doDecode(FacesContext context, UIComponent component) {
        String mode;
        super.doDecode(context, component);
        ExternalContext exCtx = context.getExternalContext();
        Map rqMap = exCtx.getRequestParameterMap();
        Object clnId = rqMap.get(component.getClientId(context));
        if (clnId == null) {
            clnId = rqMap.get(component.getClientId(context) + ":hidden");
        }
        UIMenuItem menuItem = (UIMenuItem)component;
        if (clnId != null && !"none".equalsIgnoreCase(mode = this.resolveSubmitMode(menuItem))) {
            ActionEvent actionEvent = new ActionEvent((UIComponent)menuItem);
            if ("ajax".equalsIgnoreCase(mode)) {
                new AjaxEvent((UIComponent)menuItem).queue();
                if (AjaxRendererUtils.isAjaxRequest((FacesContext)context)) {
                    AjaxContext.getCurrentInstance((FacesContext)context).addAreasToProcessFromComponent(context, (UIComponent)menuItem);
                }
            }
            if (menuItem.isImmediate()) {
                actionEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                actionEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
            menuItem.queueEvent((FacesEvent)actionEvent);
        }
    }

    public List encodeParams(FacesContext context, UIMenuItem component) throws IOException {
        UIMenuItem menuItem = component;
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer buff = new StringBuffer();
        List children = menuItem.getChildren();
        for (UIComponent child : children) {
            UIParameter param;
            String name;
            if (!(child instanceof UIParameter) || (name = (param = (UIParameter)child).getName()) == null) continue;
            Object value = param.getValue();
            buff.append("params[");
            buff.append(ScriptUtils.toScript((Object)name));
            buff.append("] = ");
            buff.append(ScriptUtils.toScript((Object)value));
            buff.append(";");
            params.add(buff.toString());
        }
        return params;
    }

    public void initializeResources(FacesContext context, UIMenuItem menuItem) throws IOException {
        String resource;
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)menuItem);
        String string = resource = menuItem.isDisabled() ? ViewUtil.getResourceURL((String)menuItem.getIconDisabled()) : ViewUtil.getResourceURL((String)menuItem.getIcon());
        if (resource == null || resource.length() == 0) {
            resource = this.getResource("images/spacer.gif").getUri(context, (Object)menuItem);
        }
        variables.setVariable("icon", (Object)resource);
        if (menuItem.isDisabled()) {
            variables.setVariable("iconDisabledClasses", (Object)"dr-menu-icon-disabled rich-menu-item-icon-disabled");
        } else {
            variables.setVariable("onmouseoutInlineStyles", (Object)this.processInlineStyles(context, menuItem, false));
            variables.setVariable("onmouseoverInlineStyles", (Object)this.processInlineStyles(context, menuItem, true));
            StringBuffer scriptValue = new StringBuffer();
            String mode = this.resolveSubmitMode(menuItem);
            if ("ajax".equalsIgnoreCase(mode)) {
                scriptValue.append(AjaxRendererUtils.buildOnClick((UIComponent)menuItem, (FacesContext)context).toString());
            } else if ("server".equalsIgnoreCase(mode)) {
                String id = menuItem.getClientId(context);
                scriptValue.append('{');
                scriptValue.append("var form = A4J.findForm(this);");
                scriptValue.append("var params = new Object();");
                scriptValue.append("params[");
                scriptValue.append(ScriptUtils.toScript((Object)(id + ":hidden")));
                scriptValue.append("] = ");
                scriptValue.append(ScriptUtils.toScript((Object)id));
                scriptValue.append(";");
                List params = this.encodeParams(context, menuItem);
                if (!params.isEmpty()) {
                    Iterator iterator = params.iterator();
                    while (iterator.hasNext()) {
                        scriptValue.append(iterator.next());
                    }
                }
                scriptValue.append("Richfaces.jsFormSubmit(");
                scriptValue.append(ScriptUtils.toScript((Object)id)).append(",");
                scriptValue.append("form.id").append(",");
                Object target = menuItem.getAttributes().get("target");
                if (null != target) {
                    scriptValue.append(ScriptUtils.toScript(target));
                } else {
                    scriptValue.append("''");
                }
                scriptValue.append(",");
                scriptValue.append("params);}; return false;");
            } else {
                scriptValue.append(this.getStringAttributeOrEmptyString((UIComponent)menuItem, "onclick"));
            }
            if (resource.length() > 0) {
                variables.setVariable("onclick", (Object)scriptValue.toString());
            }
        }
    }

    protected String getStringAttributeOrEmptyString(UIComponent component, String attributeName) {
        String attributeValue = (String)component.getAttributes().get(attributeName);
        if (null == attributeValue) {
            attributeValue = "";
        }
        return attributeValue;
    }

    protected UIComponent getIconFacet(UIMenuItem menuItem) {
        UIComponent iconFacet = null;
        iconFacet = menuItem.isDisabled() ? menuItem.getFacet("iconDisabled") : menuItem.getFacet("icon");
        return iconFacet;
    }

    protected String resolveSubmitMode(UIMenuItem menuItem) {
        String submitMode = menuItem.getSubmitMode();
        if (null != submitMode) {
            return submitMode;
        }
        for (UIComponent parent = menuItem.getParent(); null != parent; parent = parent.getParent()) {
            if (!(parent instanceof MenuComponent)) continue;
            return ((MenuComponent)parent).getSubmitMode();
        }
        return "server";
    }

    protected String processInlineStyles(FacesContext context, UIMenuItem menuItem, boolean isOnmouseover) {
        return this.delegate.processInlineStyles(context, (UIComponent)menuItem, isOnmouseover);
    }

    protected UIComponent getParentMenu(FacesContext context, UIMenuItem menuItem) {
        return this.delegate.getParentMenu(context, (UIComponent)menuItem);
    }

    public void initializeStyles(FacesContext context, UIMenuItem menuItem) {
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)menuItem);
        this.delegate.initializeStyles(context, (UIComponent)menuItem, menuItem.isDisabled(), variables);
    }
}

