/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.richfaces.component.UIPanelMenu;
import org.richfaces.component.UIPanelMenuGroup;
import org.richfaces.component.UIPanelMenuItem;
import org.richfaces.renderkit.PanelMenuRendererBase;
import org.richfaces.renderkit.html.PanelMenuGroupRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelMenuRenderer
extends PanelMenuRendererBase {
    private static final String FIRST_EXPANDED_ENCODED = "firstExpandedEncoded";

    protected Class<? extends UIComponent> getComponentClass() {
        return UIComponent.class;
    }

    public List<String> encodeParams(FacesContext context, UIPanelMenuItem menuItem) throws IOException {
        ArrayList<String> params = new ArrayList<String>();
        List children = menuItem.getChildren();
        for (UIComponent child : children) {
            UIParameter param;
            String name;
            if (!(child instanceof UIParameter) || (name = (param = (UIParameter)child).getName()) == null) continue;
            Object value = param.getValue();
            StringBuffer buff = new StringBuffer();
            buff.append("params[").append(ScriptUtils.toScript((Object)name)).append("] = ").append(ScriptUtils.toScript((Object)value)).append(";");
            params.add(buff.toString());
        }
        return params;
    }

    protected void preEncodeBegin(FacesContext context, UIComponent component) throws IOException {
        UIPanelMenu panelMenu;
        super.preEncodeBegin(context, component);
        if (component instanceof UIPanelMenu && (panelMenu = (UIPanelMenu)component).isExpandSingle()) {
            panelMenu.getAttributes().put(FIRST_EXPANDED_ENCODED, false);
        }
    }

    public void insertScript(FacesContext context, UIComponent component) throws IOException {
        StringBuffer buffer = new StringBuffer();
        HashSet<String> itemNames = new HashSet<String>();
        UIPanelMenu panelMenu = (UIPanelMenu)component;
        HashMap<String, Integer> levels = new HashMap<String, Integer>();
        LinkedList<UIComponent> flatList = new LinkedList<UIComponent>();
        this.flatten(component.getChildren(), flatList, levels, 0);
        for (UIComponent child : flatList) {
            boolean childRendered;
            if (!(child instanceof UIPanelMenuItem) && !(child instanceof UIPanelMenuGroup)) continue;
            boolean parentRendered = child.getParent().isRendered();
            if (!parentRendered) {
                child.getAttributes().put("rendered", Boolean.FALSE);
            }
            if (!(childRendered = child.isRendered()) || !parentRendered || this.isParentDisabled(child)) continue;
            boolean childDisabled = panelMenu.isDisabled() || child instanceof UIPanelMenuGroup ? ((UIPanelMenuGroup)child).isDisabled() : ((UIPanelMenuItem)child).isDisabled();
            String childName = child instanceof UIPanelMenuGroup ? ((UIPanelMenuGroup)child).getName() : ((UIPanelMenuItem)child).getName();
            if (itemNames.contains(childName)) {
                throw new RuntimeException("Attibute \"name\" with value \"" + childName + "\" is already used in PanelMenu. It must be unique for every group/item.");
            }
            itemNames.add(childName);
            buffer.append("var params = new Object();");
            if (child instanceof UIPanelMenuItem) {
                for (String param : this.encodeParams(context, (UIPanelMenuItem)child)) {
                    buffer.append(param);
                }
            }
            buffer.append("new PanelMenuItem(ids, params,").append("{myId:'").append(child.getClientId(context)).append("',").append("parentId:'").append(child.getParent().getClientId(context)).append("'},").append("{type:").append(child instanceof UIPanelMenuItem ? "\"item\"" : "\"node\"").append(",").append("onopen:").append(this.getOnOpen(panelMenu, child)).append(",").append("onclose:").append(this.getNoClose(panelMenu, child)).append(",").append("event:\"").append(this.getEvent(panelMenu)).append("\",").append("mode:\"").append(this.getItemMode(child)).append("\",").append("disabled:").append(childDisabled).append(",").append("target:\"").append(this.getTarget(child)).append("\",").append("name:\"").append(childName).append("\"").append("},{").append(this.getHoveredStyle(panelMenu, child)).append("},").append(this.getHoverClass(panelMenu, child)).append(levels.get(child.getClientId(context))).append(this.switchOnImagesIfNeeded(context, child));
            this.addActionIfNeeded(context, child, buffer);
            this.setExpandedIfNeeded(context, child, buffer);
            this.addAjaxFunction(context, child, buffer);
            this.addOnItemHover(panelMenu.getOnitemhover(), child, buffer);
            boolean isTopLevel = this.isTopLevel(child);
            String iconPos = child instanceof UIPanelMenuGroup ? (isTopLevel ? panelMenu.getIconGroupTopPosition() : panelMenu.getIconGroupPosition()) : (isTopLevel ? panelMenu.getIconItemTopPosition() : panelMenu.getIconItemPosition());
            buffer.append(",\"" + iconPos + '\"');
            this.addImages(buffer, context, child, component.getClientId(context).toString());
            buffer.append(");\n");
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", component);
        writer.writeAttribute("id", (Object)("script" + component.getClientId(context)), null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)this.getPanelMenuScript(context, panelMenu), null);
        writer.writeText((Object)buffer, null);
        writer.endElement("script");
    }

    private String getNoClose(UIPanelMenu panelMenu, UIComponent child) {
        String onclose = child instanceof UIPanelMenuGroup && !((UIPanelMenuGroup)child).isDisabled() && !this.isParentDisabled(child) ? panelMenu.getOngroupcollapse() + ";" + ((UIPanelMenuGroup)child).getOncollapse() : "";
        return "".equals(onclose) ? "\"\"" : "\"" + onclose + "\"";
    }

    private String getOnOpen(UIPanelMenu panelMenu, UIComponent child) {
        String onopen = child instanceof UIPanelMenuGroup && !((UIPanelMenuGroup)child).isDisabled() && !this.isParentDisabled(child) ? panelMenu.getOngroupexpand() + ";" + ((UIPanelMenuGroup)child).getOnexpand() : "";
        return "".equals(onopen) ? "\"\"" : "\"" + onopen + "\"";
    }

    private String getTarget(UIComponent child) {
        Object target = child.getAttributes().get("target");
        return null == target ? "" : target.toString();
    }

    private String getHoverClass(UIPanelMenu panelMenu, UIComponent child) {
        String hoveredClass = (child instanceof UIPanelMenuGroup ? panelMenu.getHoveredGroupClass() : panelMenu.getHoveredItemClass()) + " " + (child instanceof UIPanelMenuGroup ? ((UIPanelMenuGroup)child).getHoverClass() : ((UIPanelMenuItem)child).getHoverClass());
        String[] hoveredClasses = hoveredClass.trim().split(" ");
        StringBuffer buffer = new StringBuffer();
        buffer.append("new Array(");
        for (int i = 0; i < hoveredClasses.length; ++i) {
            if ("".equals(hoveredClasses[i])) continue;
            buffer.append("\"").append(hoveredClasses[i]).append("\"");
            if (i == hoveredClasses.length - 1) continue;
            buffer.append(",");
        }
        buffer.append("),");
        return buffer.toString();
    }

    private String getHoveredStyle(UIPanelMenu panelMenu, UIComponent child) {
        String hoveredStyle = (child instanceof UIPanelMenuGroup ? panelMenu.getHoveredGroupStyle() : panelMenu.getHoveredItemStyle()) + ";" + (child instanceof UIPanelMenuGroup ? ((UIPanelMenuGroup)child).getHoverStyle() : ((UIPanelMenuItem)child).getHoverStyle());
        String[] hoveredStyles = hoveredStyle.split(";");
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < hoveredStyles.length; ++i) {
            if ("".equals(hoveredStyles[i])) continue;
            String[] temp = hoveredStyles[i].split(":");
            String cssName = temp[0].trim();
            String cssValue = temp[1].trim();
            buffer.append("\"" + cssName + "\": \"" + cssValue + "\"");
            if (i == hoveredStyles.length - 1) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    private String getEvent(UIPanelMenu panelMenu) {
        String event = panelMenu.getEvent();
        if ("".equals(event)) {
            event = "click";
        } else if (event.startsWith("on")) {
            event = event.substring(2);
        }
        return event;
    }

    private StringBuffer getPanelMenuScript(FacesContext context, UIPanelMenu parentMenu) {
        StringBuffer panelMenu = new StringBuffer();
        panelMenu.append("var ids = new PanelMenu('").append(parentMenu.getClientId(context).toString()).append("',").append(parentMenu.isExpandSingle()).append(",").append("'").append(parentMenu.getSelectedName()).append("'").append(").getIds();\n");
        return panelMenu;
    }

    public void flatten(List<UIComponent> children, List<UIComponent> flatList, Map<String, Integer> levels, int initialLevel) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (children == null) {
            return;
        }
        for (UIComponent child : children) {
            if (child instanceof UIPanelMenu) continue;
            flatList.add(child);
            levels.put(child.getClientId(context), initialLevel);
            this.flatten(child.getChildren(), flatList, levels, initialLevel + 1);
        }
    }

    private String switchOnImagesIfNeeded(FacesContext context, UIComponent child) throws IOException {
        boolean isToplevel = this.isTopLevel(child);
        String customIconOpened = "";
        String customIconClosed = "";
        UIPanelMenu panelMenu = this.findMenu(child);
        if (panelMenu == null) {
            return "";
        }
        String iconOpened = isToplevel ? panelMenu.getIconExpandedTopGroup() : panelMenu.getIconExpandedGroup();
        String iconClosed = isToplevel ? panelMenu.getIconCollapsedTopGroup() : panelMenu.getIconCollapsedGroup();
        try {
            customIconOpened = (String)child.getAttributes().get("iconOpened");
            customIconClosed = (String)child.getAttributes().get("iconClosed");
        }
        catch (Exception e) {
            // empty catch block
        }
        StringBuffer buffer = new StringBuffer();
        if (child instanceof UIPanelMenuItem) {
            buffer.append(",false");
        } else if (iconClosed.equals("custom") && iconOpened.equals("custom")) {
            if (customIconClosed.equals("") && customIconOpened.equals("")) {
                buffer.append(",false");
            } else {
                buffer.append(",true");
            }
        } else {
            buffer.append(",true");
        }
        return buffer.toString();
    }

    private void addActionIfNeeded(FacesContext context, UIComponent child, StringBuffer buffer) {
        if (child instanceof UIPanelMenuItem) {
            if (((UIPanelMenuItem)child).getAction() == null) {
                buffer.append(",false");
            } else {
                buffer.append(",true");
            }
        } else if (((UIPanelMenuGroup)child).getAction() != null && !((UIPanelMenuGroup)child).getAction().equals("")) {
            buffer.append(",'panelMenuNodeAction'");
        } else {
            buffer.append(",false");
        }
    }

    private void setExpandedIfNeeded(FacesContext context, UIComponent child, StringBuffer buffer) {
        if (child instanceof UIPanelMenuItem) {
            buffer.append(",false");
        } else {
            UIPanelMenuGroup group = (UIPanelMenuGroup)child;
            if (group.getValue() != null) {
                buffer.append(",").append(group.getValue().toString());
            } else {
                boolean isNodeOpened;
                PanelMenuGroupRenderer r = (PanelMenuGroupRenderer)context.getRenderKit().getRenderer(group.getFamily(), group.getRendererType());
                try {
                    isNodeOpened = r.isOpened(context, child);
                }
                catch (IOException e) {
                    isNodeOpened = false;
                }
                buffer.append(",").append(String.valueOf(isNodeOpened));
            }
        }
    }

    private void addImages(StringBuffer buffer, FacesContext context, UIComponent component, String id) {
        UIPanelMenu panelMenu = this.findMenu(component);
        if (panelMenu == null) {
            return;
        }
        boolean isTopLevel = this.isTopLevel(component);
        String PANEL_MENU_SPACER_ICON = this.getIconByType("spacer", isTopLevel, context, component);
        if (component instanceof UIPanelMenuItem) {
            UIPanelMenuItem item = (UIPanelMenuItem)component;
            String defaultItemIcon = null;
            String defaultItemIconSrc = null;
            String customItemIcon = null;
            String customIconSource = null;
            if (isTopLevel) {
                defaultItemIcon = item.isDisabled() ? panelMenu.getIconTopDisabledItem() : panelMenu.getIconTopItem();
                if (defaultItemIcon == null || defaultItemIcon.equals("")) {
                    defaultItemIcon = item.isDisabled() ? panelMenu.getIconDisabledItem() : panelMenu.getIconItem();
                }
            } else if (defaultItemIcon == null || defaultItemIcon.equals("")) {
                defaultItemIcon = item.isDisabled() ? panelMenu.getIconDisabledItem() : panelMenu.getIconItem();
            }
            defaultItemIconSrc = defaultItemIcon != null && defaultItemIcon.equals("none") ? PANEL_MENU_SPACER_ICON : this.getIconByType(defaultItemIcon, isTopLevel, context, component);
            customItemIcon = item.isDisabled() ? item.getIconDisabled() : item.getIcon();
            customIconSource = customItemIcon != null && customItemIcon.equals("none") ? PANEL_MENU_SPACER_ICON : this.getIconByType(customItemIcon, isTopLevel, context, component);
            if (customItemIcon != null && !customItemIcon.equals("")) {
                buffer.append(",\"" + customIconSource).append("\",\"" + customIconSource + "\" ");
            } else if (defaultItemIcon != null && !defaultItemIcon.equals("")) {
                buffer.append(",\"" + defaultItemIconSrc).append("\",\"" + defaultItemIconSrc + "\" ");
            } else {
                buffer.append(",\"" + PANEL_MENU_SPACER_ICON).append("\",\"" + PANEL_MENU_SPACER_ICON + "\" ");
            }
            buffer.append(",\"\" ");
        } else if (component instanceof UIPanelMenuGroup) {
            String defaultIconNodeOpened;
            String defaultIconNodeClosed;
            UIPanelMenuGroup group = (UIPanelMenuGroup)component;
            String string = isTopLevel ? (group.isDisabled() ? panelMenu.getIconTopDisableGroup() : panelMenu.getIconCollapsedTopGroup()) : (defaultIconNodeClosed = group.isDisabled() ? panelMenu.getIconDisabledGroup() : panelMenu.getIconCollapsedGroup());
            if (isTopLevel) {
                if (group.isDisabled()) {
                    defaultIconNodeClosed = panelMenu.getIconTopDisableGroup();
                    if (defaultIconNodeClosed == null || defaultIconNodeClosed.equals("")) {
                        defaultIconNodeClosed = panelMenu.getIconDisabledGroup();
                    }
                } else {
                    defaultIconNodeClosed = panelMenu.getIconCollapsedTopGroup();
                    if (defaultIconNodeClosed == null || defaultIconNodeClosed.equals("")) {
                        defaultIconNodeClosed = panelMenu.getIconCollapsedGroup();
                    }
                }
            } else {
                defaultIconNodeClosed = group.isDisabled() ? panelMenu.getIconDisabledGroup() : panelMenu.getIconCollapsedGroup();
            }
            String string2 = defaultIconNodeOpened = isTopLevel ? panelMenu.getIconExpandedTopGroup() : panelMenu.getIconExpandedGroup();
            if (isTopLevel) {
                defaultIconNodeOpened = panelMenu.getIconExpandedTopGroup();
                if (defaultIconNodeOpened == null || defaultIconNodeOpened.equals("")) {
                    defaultIconNodeOpened = panelMenu.getIconExpandedGroup();
                }
            } else {
                defaultIconNodeOpened = panelMenu.getIconExpandedGroup();
            }
            String defaultIconNodeOpenedSrc = this.getIconByType(defaultIconNodeOpened, isTopLevel, context, component);
            String iconExpanded = group.isDisabled() ? group.getIconDisabled() : group.getIconExpanded();
            String iconExpandedSource = this.getIconByType(iconExpanded, isTopLevel, context, component);
            if (iconExpanded != null && !iconExpanded.equals("")) {
                buffer.append(",\"" + iconExpandedSource + '\"');
            } else if (defaultIconNodeOpened != null && !defaultIconNodeOpened.equals("")) {
                buffer.append(",\"" + defaultIconNodeOpenedSrc + '\"');
            } else {
                buffer.append(",\"" + PANEL_MENU_SPACER_ICON + '\"');
            }
            String defaultIconNodeClosedSrc = this.getIconByType(defaultIconNodeClosed, isTopLevel, context, component);
            String iconCollapsed = group.isDisabled() ? group.getIconDisabled() : group.getIconCollapsed();
            String iconCollapsedSource = this.getIconByType(iconCollapsed, isTopLevel, context, component);
            if (iconCollapsed != null && !iconCollapsed.equals("")) {
                buffer.append(",\"" + iconCollapsedSource + '\"');
            } else if (defaultIconNodeClosed != null && !defaultIconNodeClosed.equals("")) {
                buffer.append(",\"" + defaultIconNodeClosedSrc + '\"');
            } else {
                buffer.append(",\"" + PANEL_MENU_SPACER_ICON + '\"');
            }
        }
        buffer.append(",\"" + PANEL_MENU_SPACER_ICON + "\"");
    }

    protected void addAjaxFunction(FacesContext context, UIComponent child, StringBuffer buffer) {
        JSFunction function = AjaxRendererUtils.buildAjaxFunction((UIComponent)child, (FacesContext)context);
        Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)child);
        function.addParameter((Object)eventOptions);
        buffer.append(",\"");
        function.appendScript(buffer);
        buffer.append("\"");
    }

    protected void addOnItemHover(String menuOnItemHover, UIComponent child, StringBuffer buffer) {
        buffer.append(",\"");
        if (child instanceof UIPanelMenuItem && menuOnItemHover != null && !menuOnItemHover.equals("")) {
            buffer.append(menuOnItemHover);
        }
        buffer.append("\"");
    }

    public void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (!(component instanceof UIPanelMenu)) {
            return;
        }
        UIPanelMenu panelMenu = (UIPanelMenu)component;
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UIPanelMenuGroup) {
                UIPanelMenuGroup group = (UIPanelMenuGroup)child;
                if (panelMenu.isExpandSingle()) {
                    if (!((Boolean)panelMenu.getAttributes().get(FIRST_EXPANDED_ENCODED)).booleanValue()) {
                        if (group.isExpanded()) {
                            panelMenu.getAttributes().put(FIRST_EXPANDED_ENCODED, true);
                        }
                    } else {
                        group.setExpanded(false);
                        if (((Boolean)group.getValue()).booleanValue()) {
                            group.setValue(null);
                        }
                    }
                }
            }
            this.renderChild(facesContext, child);
        }
    }

    public void doDecode(FacesContext context, UIComponent component) {
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String menuClientId = component.getClientId(context);
        UIPanelMenu menu = (UIPanelMenu)component;
        Object selectedItemName = requestMap.get(menuClientId + "selectedItemName");
        if (selectedItemName != null) {
            menu.setSubmittedValue(selectedItemName);
        }
    }
}

