package org.ajax4jsf.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.UIResource;

public class HtmlLoadStyle extends UIResource{

public final static  String COMPONENT_FAMILY = "org.ajax4jsf.LoadStyle";

public final static  String COMPONENT_TYPE = "org.ajax4jsf.LoadStyle";

/*
* This attribute defines the device to which it is necessary to apply style registration. 
				The possible values are "all", "screen" (by default), "print", "projection", "projection", "braille" and "speech".
*/
private  String _media = null;

/*
* name of JavaScript resource to load.
*/
private  Object _src = null;


public HtmlLoadStyle(){
setRendererType("org.ajax4jsf.LoadStyleRenderer");
}

public String getMedia(){
	if (this._media != null) {
		return this._media;
	}
	ValueExpression ve = getValueExpression("media");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setMedia(String _media){
this._media = _media;
}

public Object getSrc(){
	if (this._src != null) {
		return this._src;
	}
	ValueExpression ve = getValueExpression("src");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSrc(Object _src){
this._src = _src;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[3];
state[0] = super.saveState(context);
state[1] = _media;
state[2] = saveAttachedState(context, _src);
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_media = (String)states[1];;
		_src = (Object)restoreAttachedState(context, states[2]);
	
}

}
