package org.richfaces.renderkit;

import java.util.Set;

import javax.faces.context.FacesContext;

import org.ajax4jsf.context.AjaxContext;
import org.richfaces.component.UIColorPicker;

public abstract class ColorPickerRendererBase  extends InputRendererBase {

	public void addPopupToAjaxRendered(FacesContext context, UIColorPicker component) {
		AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
		Set<String> ajaxRenderedAreas = ajaxContext.getAjaxRenderedAreas();
		String clientId = component.getClientId(context);
		if (ajaxContext.isAjaxRequest() && ajaxRenderedAreas.contains(clientId)) {
			ajaxRenderedAreas.add(clientId + "-colorPicker-popup");
			ajaxRenderedAreas.add(clientId + "-colorPicker-script");
		}
	}
}