/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.convert.seamtext;

import antlr.SemanticException;
import antlr.Token;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.jboss.seam.text.SeamTextParser;
import org.richfaces.convert.seamtext.HtmlToSeamTransformer;
import org.richfaces.convert.seamtext.tags.HtmlTag;
import org.richfaces.convert.seamtext.tags.TagFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlToSeamSAXParser
extends DefaultHandler {
    private static final TagFactory TAG_FACTORY = new TagFactory();
    public static final String ROOT_TAG_NAME = "root";
    public final HtmlTag rootTag = TAG_FACTORY.getInstance("root");
    private SeamTextParser.Sanitizer sanitizer = new SeamTextParser.DefaultSanitizer();
    private HtmlToSeamTransformer transformer;
    private Stack<HtmlTag> tagStack = new Stack();
    private HtmlTag firstInvalidTag = null;

    public HtmlTag getRootTag() {
        return this.rootTag;
    }

    public HtmlToSeamSAXParser() {
        this.transformer = new HtmlToSeamTransformer();
        this.transformer.setHtmlElementStack(this.tagStack);
    }

    public static String convertHtmlToSeamText(String html) throws IOException, SAXException {
        HtmlToSeamSAXParser parser = new HtmlToSeamSAXParser();
        XMLReader p = XMLReaderFactory.createXMLReader();
        p.setContentHandler(parser);
        try {
            p.setFeature("http://xml.org/sax/features/namespaces", false);
            p.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        StringBuilder str = new StringBuilder(html.length() + 2 * ROOT_TAG_NAME.length() + 5);
        str.append('<').append(ROOT_TAG_NAME).append('>').append(html).append("</").append(ROOT_TAG_NAME).append('>');
        p.parse(new InputSource(new StringReader(str.toString())));
        return parser.getRootTag().toString();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (!this.tagStack.isEmpty()) {
            this.tagStack.peek().setNotEmpty();
        }
        if (ROOT_TAG_NAME.equalsIgnoreCase(qName)) {
            this.tagStack.push(this.rootTag);
            this.transformer.setCurrentTag(this.rootTag);
        } else if (this.hasInvalidParentTag()) {
            if (!this.isValidTag(qName)) {
                this.tagStack.push(TAG_FACTORY.getInstance(qName, this.processAttr(qName, attributes)));
            }
        } else {
            HtmlTag tag = TAG_FACTORY.getInstance(qName, this.processAttr(qName, attributes));
            if (this.isValidTag(tag)) {
                this.transformer.openTag(tag);
            } else {
                this.setFirstInvalidTag(tag);
            }
            this.tagStack.push(tag);
        }
    }

    private Map<String, String> processAttr(String tag, Attributes attributes) {
        HashMap<String, String> map = new HashMap<String, String>(attributes.getLength());
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!this.isValidAttr(tag, attributes.getQName(i), attributes.getValue(i))) continue;
            map.put(attributes.getQName(i), attributes.getValue(i));
        }
        return map;
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (ROOT_TAG_NAME.equalsIgnoreCase(qName)) {
            HtmlTag tag = this.tagStack.pop();
            if (!ROOT_TAG_NAME.equalsIgnoreCase(tag.getName())) {
                throw new IllegalStateException("Last tag must be 'root', you have " + qName);
            }
        } else if (this.hasInvalidParentTag()) {
            HtmlTag tag;
            if (!this.isValidTag(qName) && (tag = this.tagStack.pop()) == this.getFirstInvalidTag()) {
                this.cleanInvalidTag();
            }
        } else {
            HtmlTag tag = this.tagStack.pop();
            if (this.isValidTag(tag.getName())) {
                this.transformer.closeTagWithBody(tag);
            } else {
                throw new IllegalStateException("Sometning wrong! You can't have invalid tag at here!");
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        while (start < length) {
            switch (ch[start]) {
                case '\t': 
                case ' ': {
                    this.transformer.space(ch, start, length);
                    break;
                }
                case '\n': 
                case '\r': {
                    this.transformer.newline(ch, start, length);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknow char : '" + ch[start] + '\'');
                }
            }
            ++start;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (!this.tagStack.isEmpty()) {
            this.tagStack.peek().setNotEmpty();
        }
        this.transformer.text(ch, start, length);
    }

    private boolean isValidAttr(String tag, String name, String value) {
        try {
            FakeToken tagToken = new FakeToken(0, tag);
            FakeToken attrToken = new FakeToken(0, name);
            this.sanitizer.validateHtmlAttribute((Token)tagToken, (Token)attrToken);
            this.sanitizer.validateHtmlAttributeValue((Token)tagToken, (Token)attrToken, value);
        }
        catch (SemanticException e) {
            return false;
        }
        return true;
    }

    private boolean isValidTag(String tagName) {
        try {
            this.sanitizer.validateHtmlElement((Token)new FakeToken(0, tagName));
        }
        catch (SemanticException e) {
            return false;
        }
        return true;
    }

    private boolean isValidTag(HtmlTag tag) {
        return this.isValidTag(tag.getName());
    }

    private boolean hasInvalidParentTag() {
        return this.firstInvalidTag != null;
    }

    private void cleanInvalidTag() {
        this.firstInvalidTag = null;
    }

    private void setFirstInvalidTag(HtmlTag firstInvalidTag) {
        this.firstInvalidTag = firstInvalidTag;
    }

    private HtmlTag getFirstInvalidTag() {
        return this.firstInvalidTag;
    }

    public HtmlToSeamTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(HtmlToSeamTransformer transformer) {
        this.transformer = transformer;
    }

    private static final class FakeToken
    extends Token {
        private String text;

        private FakeToken(int t, String txt) {
            super(t, txt);
        }

        public String getText() {
            return this.text;
        }

        public void setText(String t) {
            this.text = t;
        }
    }
}

