package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import org.richfaces.component.UIPanelMenuGroup;

public class HtmlPanelMenuGroup extends UIPanelMenuGroup{

final public static  String COMPONENT_FAMILY = "org.richfaces.PanelMenuGroup";

final public static  String COMPONENT_TYPE = "org.richfaces.PanelMenuGroup";

/*
* This attribute assigns an access key to an element. An access key is a single character from the document character set. Note: Authors should consider the input method of the expected reader when specifying an accesskey
*/
private  String _accesskey = null;

/*
* MethodExpression pointing at the application action to be invoked,
            if this UIComponent is activated by you, during the Apply
            Request Values or Invoke Application phase of the request
            processing lifecycle, depending on the value of the immediate
            property
*/
private  MethodExpression _actionExpression = null;

/*
* MethodBinding pointing at method accepting  an ActionEvent with return type void
*/
@SuppressWarnings("deprecation")
private  MethodBinding _actionListener = null;

/*
* boolean attribute which provides possibility to limit JSF tree processing(decoding, conversion/validation, value applying) 
to the component which send the request only
*/
private  boolean _ajaxSingle = false;

private  boolean _ajaxSingleSet = false;

/*
* Deprecated. This attribute specifies the horizontal alignment of its element with respect to the surrounding context. The  possible values are "left", "center", "right" and "justify".  
            The default depends on the base text direction. For left to right text, the default is align="left", while for right to left text, the default is align="right".
*/
private  String _align = null;

/*
* For a user agents that cannot display images, forms, or applets, this attribute specifies alternate text. The language of the alternate text is specified by the lang attribute
*/
private  String _alt = null;

/*
* If "true", after process validations phase it skips updates of model beans on a force render response. It can be used for validating components input
*/
private  boolean _bypassUpdates = false;

private  boolean _bypassUpdatesSet = false;

/*
* Serialized (on default with JSON) data passed on the client by a developer on AJAX request. It's accessible via "data.foo" syntax
*/
private  Object _data = null;

/*
* When set for a form control, this boolean attribute disables the control for your input
*/
private  boolean _disabled = false;

private  boolean _disabledSet = false;

/*
* Class to be applied to disabled items.
*/
private  String _disabledClass = null;

/*
* CSS style rules to be applied to disabled items.
*/
private  String _disabledStyle = null;

/*
* Name of requests queue to avoid send next request before complete other from same event. Can be used to reduce number of requests of frequently events (key press, mouse move etc.)
*/
private  String _eventsQueue = null;

/*
* Set the submission mode for all panel menu groups after expand/collapse
				except ones where this attribute redefined. Possible value are "ajax", "server", "none". Default value is "none".
*/
private  String _expandMode = null;

/*
* id of element to set focus after request completed on client side
*/
private  String _focus = null;

/*
* Class to be applied to hovered items.
*/
private  String _hoverClass = null;

/*
* CSS style rules to be applied to hovered items.
*/
private  String _hoverStyle = null;

/*
* Class to be applied to icon element.
*/
private  String _iconClass = null;

/*
* Path to the icon to be displayed for the collapsed item state.
				You can also use predefined icons, setting the attribute to one of these possible values: "triangle", "triangleUp", "triangleDown", "disc", "chevron", "chevronUp", "chevronDown", "grid".
				Default value is "grid".
*/
private  String _iconCollapsed = null;

/*
* Path to the icon to be displayed for the disabled item state.
*/
private  String _iconDisabled = null;

/*
* Path to the icon to be displayed for the expanded item state.
				You can also use predefined icons, setting the attribute to one of these possible values: "triangle", "triangleUp", "triangleDown", "disc", "chevron", "chevronUp", "chevronDown", "grid".
				Default value is "grid".
*/
private  String _iconExpanded = null;

/*
* CSS style rules to be applied
*/
private  String _iconStyle = null;

/*
* Attribute allows to ignore an Ajax Response produced by a request if the newest 'similar' request is
in a queue already. ignoreDupResponses="true" does not cancel the request while it is processed on the server,
but just allows to avoid unnecessary updates on the client side if the response isn't actual now
*/
private  boolean _ignoreDupResponses = false;

private  boolean _ignoreDupResponsesSet = false;

/*
* Displayed node's text
*/
private  String _label = null;

/*
* If "true", then of all AJAX-rendered on the page components only those will be updated, 
		which ID's are passed to the "reRender" attribute of the describable component. 
		"false"-the default value-means that all components with ajaxRendered="true" will be updated.
*/
private  boolean _limitToList = false;

private  boolean _limitToListSet = false;

/*
* Specifies the maximum number of digits that could be entered into the input field. 
		The maximum number is unlimited by default. 
		If entered value exceeds the value specified in "maxValue" attribute than the slider takes a maximum value position.
*/
private  int _maxlength = Integer.MIN_VALUE;

private  boolean _maxlengthSet = false;

/*
* Refers to group/item with the same
				name. Default value is "getId()".
*/
private  String _name = null;

/*
* JavaScript code for call before DOM has been updated on client side
*/
private  String _onbeforedomupdate = null;

/*
* HTML: script expression; the element lost the focus
*/
private  String _onblur = null;

/*
* HTML: script expression; the element value was changed
*/
private  String _onchange = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* HTML: script expression; group was closed
*/
private  String _oncollapse = null;

/*
* JavaScript code for call after request completed on client side
*/
private  String _oncomplete = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* HTML: script expression; group was opened
*/
private  String _onexpand = null;

/*
* HTML: script expression; the element got the focus
*/
private  String _onfocus = null;

/*
* HTML: a script expression; a key is pressed down
*/
private  String _onkeydown = null;

/*
* HTML: a script expression; a key is pressed and released
*/
private  String _onkeypress = null;

/*
* HTML: a script expression; a key is released
*/
private  String _onkeyup = null;

/*
* HTML: script expression; a pointer button is pressed down
*/
private  String _onmousedown = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _onmouseover = null;

/*
* HTML: script expression; a pointer button is released
*/
private  String _onmouseup = null;

/*
* HTML: script expression; some text is selected in a text field. This attribute may be used with the INPUT and TEXTAREA elements
*/
private  String _onselect = null;

/*
* Id['s] (in format of call  UIComponent.findComponent()) of components, processed at the phases 2-5 in case of AjaxRequest  caused by this component. Can be single id, comma-separated list of Id's, or EL Expression  with array or Collection
*/
private  Object _process = null;

/*
* Id['s] (in format of call  UIComponent.findComponent()) of components, rendered in case of AjaxRequest  caused by this component. Can be single id, comma-separated list of Id's, or EL Expression  with array or Collection
*/
private  Object _reRender = null;

/*
* Attribute defines the time (in ms.) that the request will be wait in the queue before it is ready to send.
When the delay time is over, the request will be sent to the server or removed if the newest 'similar' request is in a queue already
*/
private  int _requestDelay = Integer.MIN_VALUE;

private  boolean _requestDelaySet = false;

/*
* If there are any component requests with identical IDs then these requests will be grouped.
*/
private  String _similarityGroupingId = null;

/*
* This attribute tells the user agent the initial width of the control. The width is given in pixels except when type attribute has the value "text" or "password". In that case, its value refers to the (integer) number of characters
*/
private  int _size = Integer.MIN_VALUE;

private  boolean _sizeSet = false;

/*
* ID (in format of call UIComponent.findComponent()) of Request status component
*/
private  String _status = null;

/*
* CSS style(s) to be applied when this component is rendered.
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute.
*/
private  String _styleClass = null;

/*
* This attribute specifies the position of the current element in the tabbing order for the current document. This value must be a number between 0 and 32767. User agents should ignore leading zeros
*/
private  String _tabindex = null;

/*
* Target frame for action to execute.
*/
private  String _target = null;

/*
* Response waiting time on a particular request. If a response is not received during this time, the request is aborted
*/
private  int _timeout = Integer.MIN_VALUE;

private  boolean _timeoutSet = false;


public HtmlPanelMenuGroup(){
setRendererType("org.richfaces.PanelMenuGroupRenderer");
}

public String getAccesskey(){
	if (this._accesskey != null) {
		return this._accesskey;
	}
	ValueExpression ve = getValueExpression("accesskey");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAccesskey(String _accesskey){
this._accesskey = _accesskey;
}

@SuppressWarnings("deprecation")
public MethodBinding getAction(){
	MethodExpression expression = getActionExpression();
	if (expression instanceof org.richfaces.webapp.taglib.MethodExpressionMethodBindingAdaptor) {
		return ((org.richfaces.webapp.taglib.MethodExpressionMethodBindingAdaptor) expression).getBinding();
	} else if (expression != null) {
		return new org.richfaces.webapp.taglib.MethodBindingMethodExpressionAdaptor(expression);
	}
	return null;

}

@SuppressWarnings("deprecation")
public void setAction(MethodBinding _action){
	if (_action != null) {
		setActionExpression(new org.richfaces.webapp.taglib.MethodExpressionMethodBindingAdaptor(_action));
	} else {
		setActionExpression(null);
	}

}

public MethodExpression getActionExpression(){
return _actionExpression;
}

public void setActionExpression(MethodExpression _actionExpression){
this._actionExpression = _actionExpression;
}

@SuppressWarnings("deprecation")
public MethodBinding getActionListener(){
return _actionListener;
}

@SuppressWarnings("deprecation")
public void setActionListener(MethodBinding _actionListener){
this._actionListener = _actionListener;
}

public boolean isAjaxSingle(){
	if (this._ajaxSingleSet) {
	    return (this._ajaxSingle);
	}
	ValueExpression ve = getValueExpression("ajaxSingle");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ajaxSingle);
	    }
	    
	    return value;
	} else {
	    return (this._ajaxSingle);
	}

}

public void setAjaxSingle(boolean _ajaxSingle){
this._ajaxSingle = _ajaxSingle;
this._ajaxSingleSet = true;
}

public String getAlign(){
	if (this._align != null) {
		return this._align;
	}
	ValueExpression ve = getValueExpression("align");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAlign(String _align){
this._align = _align;
}

public String getAlt(){
	if (this._alt != null) {
		return this._alt;
	}
	ValueExpression ve = getValueExpression("alt");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAlt(String _alt){
this._alt = _alt;
}

public boolean isBypassUpdates(){
	if (this._bypassUpdatesSet) {
	    return (this._bypassUpdates);
	}
	ValueExpression ve = getValueExpression("bypassUpdates");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._bypassUpdates);
	    }
	    
	    return value;
	} else {
	    return (this._bypassUpdates);
	}

}

public void setBypassUpdates(boolean _bypassUpdates){
this._bypassUpdates = _bypassUpdates;
this._bypassUpdatesSet = true;
}

public Object getData(){
	if (this._data != null) {
		return this._data;
	}
	ValueExpression ve = getValueExpression("data");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setData(Object _data){
this._data = _data;
}

public boolean isDisabled(){
	if (this._disabledSet) {
	    return (this._disabled);
	}
	ValueExpression ve = getValueExpression("disabled");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._disabled);
	    }
	    
	    return value;
	} else {
	    return (this._disabled);
	}

}

public void setDisabled(boolean _disabled){
this._disabled = _disabled;
this._disabledSet = true;
}

public String getDisabledClass(){
	if (this._disabledClass != null) {
		return this._disabledClass;
	}
	ValueExpression ve = getValueExpression("disabledClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setDisabledClass(String _disabledClass){
this._disabledClass = _disabledClass;
}

public String getDisabledStyle(){
	if (this._disabledStyle != null) {
		return this._disabledStyle;
	}
	ValueExpression ve = getValueExpression("disabledStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setDisabledStyle(String _disabledStyle){
this._disabledStyle = _disabledStyle;
}

public String getEventsQueue(){
	if (this._eventsQueue != null) {
		return this._eventsQueue;
	}
	ValueExpression ve = getValueExpression("eventsQueue");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setEventsQueue(String _eventsQueue){
this._eventsQueue = _eventsQueue;
}

public String getExpandMode(){
	if (this._expandMode != null) {
		return this._expandMode;
	}
	ValueExpression ve = getValueExpression("expandMode");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setExpandMode(String _expandMode){
this._expandMode = _expandMode;
}

public String getFocus(){
	if (this._focus != null) {
		return this._focus;
	}
	ValueExpression ve = getValueExpression("focus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFocus(String _focus){
this._focus = _focus;
}

public String getHoverClass(){
	if (this._hoverClass != null) {
		return this._hoverClass;
	}
	ValueExpression ve = getValueExpression("hoverClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setHoverClass(String _hoverClass){
this._hoverClass = _hoverClass;
}

public String getHoverStyle(){
	if (this._hoverStyle != null) {
		return this._hoverStyle;
	}
	ValueExpression ve = getValueExpression("hoverStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setHoverStyle(String _hoverStyle){
this._hoverStyle = _hoverStyle;
}

public String getIconClass(){
	if (this._iconClass != null) {
		return this._iconClass;
	}
	ValueExpression ve = getValueExpression("iconClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setIconClass(String _iconClass){
this._iconClass = _iconClass;
}

public String getIconCollapsed(){
	if (this._iconCollapsed != null) {
		return this._iconCollapsed;
	}
	ValueExpression ve = getValueExpression("iconCollapsed");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setIconCollapsed(String _iconCollapsed){
this._iconCollapsed = _iconCollapsed;
}

public String getIconDisabled(){
	if (this._iconDisabled != null) {
		return this._iconDisabled;
	}
	ValueExpression ve = getValueExpression("iconDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setIconDisabled(String _iconDisabled){
this._iconDisabled = _iconDisabled;
}

public String getIconExpanded(){
	if (this._iconExpanded != null) {
		return this._iconExpanded;
	}
	ValueExpression ve = getValueExpression("iconExpanded");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setIconExpanded(String _iconExpanded){
this._iconExpanded = _iconExpanded;
}

public String getIconStyle(){
	if (this._iconStyle != null) {
		return this._iconStyle;
	}
	ValueExpression ve = getValueExpression("iconStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setIconStyle(String _iconStyle){
this._iconStyle = _iconStyle;
}

public boolean isIgnoreDupResponses(){
	if (this._ignoreDupResponsesSet) {
	    return (this._ignoreDupResponses);
	}
	ValueExpression ve = getValueExpression("ignoreDupResponses");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ignoreDupResponses);
	    }
	    
	    return value;
	} else {
	    return (this._ignoreDupResponses);
	}

}

public void setIgnoreDupResponses(boolean _ignoreDupResponses){
this._ignoreDupResponses = _ignoreDupResponses;
this._ignoreDupResponsesSet = true;
}

public String getLabel(){
	if (this._label != null) {
		return this._label;
	}
	ValueExpression ve = getValueExpression("label");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setLabel(String _label){
this._label = _label;
}

public boolean isLimitToList(){
	if (this._limitToListSet) {
	    return (this._limitToList);
	}
	ValueExpression ve = getValueExpression("limitToList");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._limitToList);
	    }
	    
	    return value;
	} else {
	    return (this._limitToList);
	}

}

public void setLimitToList(boolean _limitToList){
this._limitToList = _limitToList;
this._limitToListSet = true;
}

public int getMaxlength(){
	if (this._maxlengthSet) {
	    return (this._maxlength);
	}
	ValueExpression ve = getValueExpression("maxlength");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._maxlength);
	    }
	    
	    return value;
	} else {
	    return (this._maxlength);
	}

}

public void setMaxlength(int _maxlength){
this._maxlength = _maxlength;
this._maxlengthSet = true;
}

public String getName(){
	if (this._name != null) {
		return this._name;
	}
	ValueExpression ve = getValueExpression("name");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return getId();
	

}

public void setName(String _name){
this._name = _name;
}

public String getOnbeforedomupdate(){
	if (this._onbeforedomupdate != null) {
		return this._onbeforedomupdate;
	}
	ValueExpression ve = getValueExpression("onbeforedomupdate");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnbeforedomupdate(String _onbeforedomupdate){
this._onbeforedomupdate = _onbeforedomupdate;
}

public String getOnblur(){
	if (this._onblur != null) {
		return this._onblur;
	}
	ValueExpression ve = getValueExpression("onblur");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnblur(String _onblur){
this._onblur = _onblur;
}

public String getOnchange(){
	if (this._onchange != null) {
		return this._onchange;
	}
	ValueExpression ve = getValueExpression("onchange");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnchange(String _onchange){
this._onchange = _onchange;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOncollapse(){
	if (this._oncollapse != null) {
		return this._oncollapse;
	}
	ValueExpression ve = getValueExpression("oncollapse");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOncollapse(String _oncollapse){
this._oncollapse = _oncollapse;
}

public String getOncomplete(){
	if (this._oncomplete != null) {
		return this._oncomplete;
	}
	ValueExpression ve = getValueExpression("oncomplete");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOncomplete(String _oncomplete){
this._oncomplete = _oncomplete;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOnexpand(){
	if (this._onexpand != null) {
		return this._onexpand;
	}
	ValueExpression ve = getValueExpression("onexpand");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnexpand(String _onexpand){
this._onexpand = _onexpand;
}

public String getOnfocus(){
	if (this._onfocus != null) {
		return this._onfocus;
	}
	ValueExpression ve = getValueExpression("onfocus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnfocus(String _onfocus){
this._onfocus = _onfocus;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getOnselect(){
	if (this._onselect != null) {
		return this._onselect;
	}
	ValueExpression ve = getValueExpression("onselect");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnselect(String _onselect){
this._onselect = _onselect;
}

public Object getProcess(){
	if (this._process != null) {
		return this._process;
	}
	ValueExpression ve = getValueExpression("process");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setProcess(Object _process){
this._process = _process;
}

public Object getReRender(){
	if (this._reRender != null) {
		return this._reRender;
	}
	ValueExpression ve = getValueExpression("reRender");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setReRender(Object _reRender){
this._reRender = _reRender;
}

public int getRequestDelay(){
	if (this._requestDelaySet) {
	    return (this._requestDelay);
	}
	ValueExpression ve = getValueExpression("requestDelay");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._requestDelay);
	    }
	    
	    return value;
	} else {
	    return (this._requestDelay);
	}

}

public void setRequestDelay(int _requestDelay){
this._requestDelay = _requestDelay;
this._requestDelaySet = true;
}

public String getSimilarityGroupingId(){
	if (this._similarityGroupingId != null) {
		return this._similarityGroupingId;
	}
	ValueExpression ve = getValueExpression("similarityGroupingId");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSimilarityGroupingId(String _similarityGroupingId){
this._similarityGroupingId = _similarityGroupingId;
}

public int getSize(){
	if (this._sizeSet) {
	    return (this._size);
	}
	ValueExpression ve = getValueExpression("size");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._size);
	    }
	    
	    return value;
	} else {
	    return (this._size);
	}

}

public void setSize(int _size){
this._size = _size;
this._sizeSet = true;
}

public String getStatus(){
	if (this._status != null) {
		return this._status;
	}
	ValueExpression ve = getValueExpression("status");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStatus(String _status){
this._status = _status;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getTabindex(){
	if (this._tabindex != null) {
		return this._tabindex;
	}
	ValueExpression ve = getValueExpression("tabindex");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTabindex(String _tabindex){
this._tabindex = _tabindex;
}

public String getTarget(){
	if (this._target != null) {
		return this._target;
	}
	ValueExpression ve = getValueExpression("target");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTarget(String _target){
this._target = _target;
}

public int getTimeout(){
	if (this._timeoutSet) {
	    return (this._timeout);
	}
	ValueExpression ve = getValueExpression("timeout");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._timeout);
	    }
	    
	    return value;
	} else {
	    return (this._timeout);
	}

}

public void setTimeout(int _timeout){
this._timeout = _timeout;
this._timeoutSet = true;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[65];
state[0] = super.saveState(context);
state[1] = _accesskey;
state[2] = saveAttachedState(context, _actionExpression);
state[3] = saveAttachedState(context, _actionListener);
state[4] = Boolean.valueOf(_ajaxSingle);
state[5] = Boolean.valueOf(_ajaxSingleSet);
state[6] = _align;
state[7] = _alt;
state[8] = Boolean.valueOf(_bypassUpdates);
state[9] = Boolean.valueOf(_bypassUpdatesSet);
state[10] = saveAttachedState(context, _data);
state[11] = Boolean.valueOf(_disabled);
state[12] = Boolean.valueOf(_disabledSet);
state[13] = _disabledClass;
state[14] = _disabledStyle;
state[15] = _eventsQueue;
state[16] = _expandMode;
state[17] = _focus;
state[18] = _hoverClass;
state[19] = _hoverStyle;
state[20] = _iconClass;
state[21] = _iconCollapsed;
state[22] = _iconDisabled;
state[23] = _iconExpanded;
state[24] = _iconStyle;
state[25] = Boolean.valueOf(_ignoreDupResponses);
state[26] = Boolean.valueOf(_ignoreDupResponsesSet);
state[27] = _label;
state[28] = Boolean.valueOf(_limitToList);
state[29] = Boolean.valueOf(_limitToListSet);
state[30] = Integer.valueOf(_maxlength);
state[31] = Boolean.valueOf(_maxlengthSet);
state[32] = _name;
state[33] = _onbeforedomupdate;
state[34] = _onblur;
state[35] = _onchange;
state[36] = _onclick;
state[37] = _oncollapse;
state[38] = _oncomplete;
state[39] = _ondblclick;
state[40] = _onexpand;
state[41] = _onfocus;
state[42] = _onkeydown;
state[43] = _onkeypress;
state[44] = _onkeyup;
state[45] = _onmousedown;
state[46] = _onmousemove;
state[47] = _onmouseout;
state[48] = _onmouseover;
state[49] = _onmouseup;
state[50] = _onselect;
state[51] = saveAttachedState(context, _process);
state[52] = saveAttachedState(context, _reRender);
state[53] = Integer.valueOf(_requestDelay);
state[54] = Boolean.valueOf(_requestDelaySet);
state[55] = _similarityGroupingId;
state[56] = Integer.valueOf(_size);
state[57] = Boolean.valueOf(_sizeSet);
state[58] = _status;
state[59] = _style;
state[60] = _styleClass;
state[61] = _tabindex;
state[62] = _target;
state[63] = Integer.valueOf(_timeout);
state[64] = Boolean.valueOf(_timeoutSet);
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_accesskey = (String)states[1];;
		_actionExpression = (MethodExpression)restoreAttachedState(context, states[2]);
		_actionListener = (MethodBinding)restoreAttachedState(context, states[3]);
		_ajaxSingle = ((Boolean)states[4]).booleanValue();
		_ajaxSingleSet = ((Boolean)states[5]).booleanValue();
		_align = (String)states[6];;
		_alt = (String)states[7];;
		_bypassUpdates = ((Boolean)states[8]).booleanValue();
		_bypassUpdatesSet = ((Boolean)states[9]).booleanValue();
		_data = (Object)restoreAttachedState(context, states[10]);
		_disabled = ((Boolean)states[11]).booleanValue();
		_disabledSet = ((Boolean)states[12]).booleanValue();
		_disabledClass = (String)states[13];;
		_disabledStyle = (String)states[14];;
		_eventsQueue = (String)states[15];;
		_expandMode = (String)states[16];;
		_focus = (String)states[17];;
		_hoverClass = (String)states[18];;
		_hoverStyle = (String)states[19];;
		_iconClass = (String)states[20];;
		_iconCollapsed = (String)states[21];;
		_iconDisabled = (String)states[22];;
		_iconExpanded = (String)states[23];;
		_iconStyle = (String)states[24];;
		_ignoreDupResponses = ((Boolean)states[25]).booleanValue();
		_ignoreDupResponsesSet = ((Boolean)states[26]).booleanValue();
		_label = (String)states[27];;
		_limitToList = ((Boolean)states[28]).booleanValue();
		_limitToListSet = ((Boolean)states[29]).booleanValue();
		_maxlength = ((Integer)states[30]).intValue();
		_maxlengthSet = ((Boolean)states[31]).booleanValue();
		_name = (String)states[32];;
		_onbeforedomupdate = (String)states[33];;
		_onblur = (String)states[34];;
		_onchange = (String)states[35];;
		_onclick = (String)states[36];;
		_oncollapse = (String)states[37];;
		_oncomplete = (String)states[38];;
		_ondblclick = (String)states[39];;
		_onexpand = (String)states[40];;
		_onfocus = (String)states[41];;
		_onkeydown = (String)states[42];;
		_onkeypress = (String)states[43];;
		_onkeyup = (String)states[44];;
		_onmousedown = (String)states[45];;
		_onmousemove = (String)states[46];;
		_onmouseout = (String)states[47];;
		_onmouseover = (String)states[48];;
		_onmouseup = (String)states[49];;
		_onselect = (String)states[50];;
		_process = (Object)restoreAttachedState(context, states[51]);
		_reRender = (Object)restoreAttachedState(context, states[52]);
		_requestDelay = ((Integer)states[53]).intValue();
		_requestDelaySet = ((Boolean)states[54]).booleanValue();
		_similarityGroupingId = (String)states[55];;
		_size = ((Integer)states[56]).intValue();
		_sizeSet = ((Boolean)states[57]).booleanValue();
		_status = (String)states[58];;
		_style = (String)states[59];;
		_styleClass = (String)states[60];;
		_tabindex = (String)states[61];;
		_target = (String)states[62];;
		_timeout = ((Integer)states[63]).intValue();
		_timeoutSet = ((Boolean)states[64]).booleanValue();
	
}

}
