/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.richfaces.component.util.HtmlUtil;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResource;
//
//
//


import org.richfaces.renderkit.PickListRenderer;



/**
 * Renderer for component class org.richfaces.renderkit.html.PickListRendererGen
 */
public class PickListRendererGen extends PickListRenderer {

	public PickListRendererGen () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] styles = {
						getResource("css/picklist.xcss")
	};

private InternetResource[] stylesAll = null;

protected InternetResource[] getStyles() {
	synchronized (this) {
		if (stylesAll == null) {
			InternetResource[] rsrcs = super.getStyles();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = styles == null || styles.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					stylesAll = new InternetResource[0];	
				} else {
					stylesAll = styles;
				}
			} else {
				if (ignoreThis) {
					stylesAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < styles.length; i++ ) {
						rsrcsSet.add(styles[i]);
					}

					stylesAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return stylesAll;
}
	private final InternetResource[] scripts = {
						new org.ajax4jsf.javascript.PrototypeScript()
						,
				getResource("/org/richfaces/renderkit/html/scripts/utils.js")
						,
				getResource("scripts/ShuttleUtils.js")
						,
				getResource("scripts/SelectItem.js")
						,
				getResource("scripts/PickListSI.js")
						,
				getResource("scripts/LayoutManager.js")
						,
				getResource("scripts/Control.js")
						,
				getResource("scripts/ListBase.js")
						,
				getResource("scripts/OrderingList.js")
						,
				getResource("scripts/ListShuttle.js")
						,
				getResource("scripts/PickList.js")
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	private boolean isEmpty(Object o) {
		if (null == o) {
			return true;
		}
		if (o instanceof String ) {
			return (0 == ((String)o).length());
		}
		if (o instanceof Collection) {
			return (0 == ((Collection)o).size());
		}
		if (o instanceof Map) {
			return (0 == ((Map)o).size());
		}
		if (o.getClass().isArray()) {
			return (0 == ((Object [])o).length);
		}
		return false;
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIPickList.class;
	}

	
	public void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component ) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeBegin(writer, context, (org.richfaces.component.UIPickList)component, variables );
	}		

	public void doEncodeBegin(ResponseWriter writer, FacesContext context, org.richfaces.component.UIPickList component, ComponentVariables variables ) throws IOException {
	    java.lang.String clientId = component.getClientId(context);
boolean componentEnabled  =  ( ! component.isDisabled() )  ;
java.lang.String componentStyle  = "" ;
java.lang.String componentStyleClass  = "" ;

	    if (componentEnabled) {
			componentStyle = HtmlUtil.concatStyles((String) component.getAttributes().get("style"), 
					(String) component.getAttributes().get("enabledStyle"));
			
			componentStyleClass = HtmlUtil.concatClasses((String) component.getAttributes().get("styleClass"), 
					(String) component.getAttributes().get("enabledStyleClass"));
	    } else {
			componentStyle = HtmlUtil.concatStyles((String) component.getAttributes().get("style"), 
					(String) component.getAttributes().get("disabledStyle"));
			
			componentStyleClass = HtmlUtil.concatClasses((String) component.getAttributes().get("styleClass"), 
					"rich-list-picklist-disabled", 
					(String) component.getAttributes().get("disabledStyleClass"));
	    }
    
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "rich-list-picklist " + convertToString(componentStyleClass) );
						getUtils().writeAttribute(writer, "id", clientId );
						getUtils().writeAttribute(writer, "style", componentStyle );
			//
// pass thru attributes
//
getUtils().encodeAttributesFromArray(context,component,new String[] {
    "align" ,
	    "bgcolor" ,
	    "border" ,
	    "cellpadding" ,
	    "cellspacing" ,
	    "dir" ,
	    "frame" ,
	    "lang" ,
	    "onclick" ,
	    "ondblclick" ,
	    "onkeydown" ,
	    "onkeypress" ,
	    "onkeyup" ,
	    "onmousedown" ,
	    "onmousemove" ,
	    "onmouseout" ,
	    "onmouseover" ,
	    "onmouseup" ,
	    "rules" ,
	    "summary" ,
	    "title" ,
	    "width" ,
	    "xml:lang" });
//
//
//

writer.startElement("tbody", component);


	}		
	
    public void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeChildren(writer, context, (org.richfaces.component.UIPickList)component, variables );
	}		

    public void doEncodeChildren(ResponseWriter writer, FacesContext context, org.richfaces.component.UIPickList component, ComponentVariables variables) throws IOException {
	    
java.lang.String clientId = component.getClientId(context);

					
						//SelectionState sourceSelectionState = new SelectionState();     
					    //variables.setVariable("selectionState", sourceSelectionState);
					    //String encodedSourceRows = encodeRows(context, component, true);
		
					    //SelectionState targetSelectionState = new SelectionState();     
					    //variables.setVariable("selectionState", targetSelectionState);
						//String encodedTargetRows = encodeRows(context, component, false);
						ListStateFlags listStateFlags = new ListStateFlags();
						
						Boolean switchByClick = (Boolean) component.getAttributes().get("switchByClick");
						variables.setVariable("switchByClick", switchByClick);
					
						variables.setVariable("baseClientId", component.getBaseClientId(context));
					
				
writer.startElement("tr", component);

writer.startElement("td", component);

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-picklist-source-items " + convertToString(component.getListClass()) );
			
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "focusKeeper" );
						getUtils().writeAttribute(writer, "style", "width: 1px; position: absolute; left: -32767px;" );
						getUtils().writeAttribute(writer, "type", "button" );
						getUtils().writeAttribute(writer, "value", "" );
			
writer.endElement("input");
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "rich-picklist-body" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "table" );
			
writer.startElement("tbody", component);

writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "style", "border:0px;padding : 0px;" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-picklist-list" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "headerBox" );
			

													
									                	String contentContainerStyle = "";
									                	String sourceListWidthValue = (String) component.getAttributes().get("sourceListWidth");
									                	if (sourceListWidthValue != null) {
									                		contentContainerStyle = contentContainerStyle.concat("width:").concat(HtmlUtil.qualifySize(sourceListWidthValue)).concat(";");
									                		variables.setVariable("contentContainerStyle", contentContainerStyle);
								                		}
													
		                						

													
														String listHeightValue = (String) component.getAttributes().get("listsHeight");
									                	if (listHeightValue != null) {
									                		contentContainerStyle = contentContainerStyle.concat("height:").concat(HtmlUtil.qualifySize(listHeightValue)).concat(";");
									                		variables.setVariable("contentContainerStyle", contentContainerStyle);
									                	}
	                								
	                							
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-picklist-list-content" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "contentBox" );
						getUtils().writeAttribute(writer, "style", variables.getVariable("contentContainerStyle") );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "rich-picklist-internal-tab" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "internal_tab" );
			
writer.startElement("tbody", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "tbody" );
			

																
																encodeSourceRows(context, component, listStateFlags);
				                								
				                							
writer.endElement("tbody");
writer.endElement("table");
writer.endElement("div");
writer.endElement("div");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");
writer.endElement("div");
writer.endElement("td");
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "style", "vertical-align: " + convertToString(component.getMoveControlsVerticalAlign()) + ";" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-picklist-controls " + convertToString(component.getControlClass()) );
			

								encodePickListControlsFacets(context, component, listStateFlags);
							
writer.endElement("div");
writer.endElement("td");
writer.startElement("td", component);

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-picklist-target-items " + convertToString(component.getListClass()) );
			
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "name", variables.getVariable("baseClientId") );
						getUtils().writeAttribute(writer, "style", "display: none;" );
						getUtils().writeAttribute(writer, "type", "hidden" );
						getUtils().writeAttribute(writer, "value", ":" );
			
writer.endElement("input");
encodeHiddenField(context, component);

writer.startElement("input", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "tlFocusKeeper" );
						getUtils().writeAttribute(writer, "style", "width: 1px; position: absolute; left: -32767px;" );
						getUtils().writeAttribute(writer, "type", "button" );
						getUtils().writeAttribute(writer, "value", "" );
			
writer.endElement("input");
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "rich-picklist-body" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "tlTable" );
			
writer.startElement("tbody", component);

writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "style", "border:0px;padding : 0px;" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-picklist-list" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "tlHeaderBox" );
			

													
									                	String trContentContainerStyle = "";
									                	String targetListWidthValue = (String) component.getAttributes().get("targetListWidth");
									                	if (targetListWidthValue != null) {
									                		trContentContainerStyle = trContentContainerStyle.concat("width:").concat(HtmlUtil.qualifySize(targetListWidthValue)).concat(";");
									                		variables.setVariable("trContentContainerStyle", trContentContainerStyle);
								                		}
													
			                					

													
									                	if (listHeightValue != null) {
									                		trContentContainerStyle = trContentContainerStyle.concat("height:").concat(HtmlUtil.qualifySize(listHeightValue)).concat(";");
									                		variables.setVariable("trContentContainerStyle", trContentContainerStyle);
									                	}
		                							
		                						
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-picklist-list-content" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "tlContentBox" );
						getUtils().writeAttribute(writer, "style", variables.getVariable("trContentContainerStyle") );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "rich-picklist-internal-tab" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "tlInternal_tab" );
			
writer.startElement("tbody", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "tlTbody" );
			

																
																encodeTargetRows(context, component, listStateFlags);
				                								
				                							
writer.endElement("tbody");
writer.endElement("table");
writer.endElement("div");
writer.endElement("div");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");
writer.endElement("div");
writer.endElement("td");
writer.endElement("tr");

	}		

	/* (non-Javadoc)
	 * @see javax.faces.render.Renderer#getRendersChildren()
	 */
	public boolean getRendersChildren() {
		return true;
	}

	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIPickList component, ComponentVariables variables) throws IOException {
	  
writer.endElement("tbody");
writer.endElement("table");
java.lang.String clientId = component.getClientId(context);
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "script" );
			
reRenderScript(context, component);

if ( Boolean.valueOf( String.valueOf( ( ! component.isDisabled() ) ) ).booleanValue() ) {


writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString("var clientId = '" + convertToString(clientId) + "';\n					new Richfaces.PickList(\n						new Richfaces.PickList.Target('" + convertToString(clientId) + "', '" + convertToString(clientId) + "tlInternal_tab', '" + convertToString(clientId) + "tlInternal_header_tab', '" + convertToString(clientId) + "tlFocusKeeper', undefined, Richfaces.PickList.Target.SelectItem, " + convertToString(getColumnClassesAsJSArray(context,component)) + ", " + convertToString(getRowClassesAsJSArray(context,component)) + "),\n						new Richfaces.PickList.Source('" + convertToString(clientId) + "', '" + convertToString(clientId) + "internal_tab', '" + convertToString(clientId) + "internal_header_tab', '" + convertToString(clientId) + "focusKeeper', undefined, Richfaces.PickList.Source.SelectItem, " + convertToString(getColumnClassesAsJSArray(context,component)) + ", " + convertToString(getRowClassesAsJSArray(context,component)) + "), \n						\"" + convertToString(clientId) + "\", [['copy', 'discopy'], ['copyAll', 'discopyAll'], ['remove', 'disremove'], ['removeAll','disremoveAll']],\n						\"" + convertToString(variables.getVariable("switchByClick")) + "\", {onlistchanged: " + convertToString(getAsEventHandler(context,component,"onlistchanged")) + ",\n											 onlistchange: " + convertToString(getAsEventHandler(context,component,"onlistchange")) + ",\n											 onfocus:" + convertToString(getAsEventHandler(context,component,"onfocus")) + ",\n											 onblur:" + convertToString(getAsEventHandler(context,component,"onblur")) + "},\n						\"" + convertToString(clientId) + "valueKeeper\");"),null);

writer.endElement("script");
}
writer.endElement("span");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIPickList)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
