package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIDndParam;

public class HtmlDndParam extends UIDndParam{

final public static  String COMPONENT_FAMILY = "org.richfaces.DndParam";

final public static  String COMPONENT_TYPE = "org.richfaces.DndParam";

/*
* A name of this parameter
*/
private  String _name = null;

/*
* This attribute defines parameter functionality. Possible values are "drag", "drop" and "default". Default value is "default".
*/
private  String _type = null;

/*
* The current value for this component
*/
private  Object _value = null;


public HtmlDndParam(){

}

public String getName(){
	if (this._name != null) {
		return this._name;
	}
	ValueExpression ve = getValueExpression("name");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setName(String _name){
this._name = _name;
}

public String getType(){
	if (this._type != null) {
		return this._type;
	}
	ValueExpression ve = getValueExpression("type");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "default";
	

}

public void setType(String _type){
this._type = _type;
}

public Object getValue(){
	if (this._value != null) {
		return this._value;
	}
	ValueExpression ve = getValueExpression("value");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setValue(Object _value){
this._value = _value;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[4];
state[0] = super.saveState(context);
state[1] = _name;
state[2] = _type;
state[3] = saveAttachedState(context, _value);
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_name = (String)states[1];;
		_type = (String)states[2];;
		_value = (Object)restoreAttachedState(context, states[3]);
	
}

}
