/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.validator;

import java.beans.FeatureDescriptor;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.ajax4jsf.el.ELContextWrapper;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidator {
    private static final String RESOURCE_BUNDLE_IS_NOT_REGISTERED_FOR_CURRENT_LOCALE = "Resource bundle is not registered for current locale";
    private static final String FACES_CONTEXT_IS_NULL = "Faces context is null";
    private static final String INPUT_PARAMETERS_IS_NOT_CORRECT = "Input parameters is not correct.";
    private static final String LOCALE_IS_NOT_SET = "Locale is not set";
    private static final String VIEW_ROOT_IS_NOT_INITIALIZED = "ViewRoot is not initialized";
    public static final String VALIDATOR_PARAM = BeanValidator.class.getName();
    private Map<ValidatorKey, ClassValidator<? extends Object>> classValidators = new ConcurrentHashMap<ValidatorKey, ClassValidator<? extends Object>>();
    private static final Object MUTEX = new Object();

    private BeanValidator() {
    }

    static BeanValidator createInstance() {
        return new BeanValidator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanValidator getInstance(FacesContext context) {
        BeanValidator instance;
        ExternalContext externalContext = context.getExternalContext();
        externalContext.getContext();
        Object object = MUTEX;
        synchronized (object) {
            Map applicationMap = externalContext.getApplicationMap();
            instance = (BeanValidator)applicationMap.get(VALIDATOR_PARAM);
            if (null == instance) {
                instance = BeanValidator.createInstance();
                applicationMap.put(VALIDATOR_PARAM, instance);
            }
        }
        return instance;
    }

    public String[] validate(FacesContext context, ValueExpression target, Object value) {
        if (null == context) {
            throw new FacesException(INPUT_PARAMETERS_IS_NOT_CORRECT);
        }
        String[] validationMessages = null;
        if (null != target) {
            ELContext elContext = context.getELContext();
            ValidationResolver validationResolver = this.createValidationResolver(elContext.getELResolver(), this.calculateLocale(context));
            ELContextWrapper wrappedElContext = new ELContextWrapper(elContext, (ELResolver)validationResolver);
            try {
                target.setValue((ELContext)wrappedElContext, value);
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
            if (!validationResolver.isValid()) {
                validationMessages = validationResolver.getValidationMessages();
            }
        }
        return validationMessages;
    }

    protected Locale calculateLocale(FacesContext context) {
        if (null == context.getViewRoot()) {
            throw new FacesException(VIEW_ROOT_IS_NOT_INITIALIZED);
        }
        if (null == context.getViewRoot().getLocale()) {
            throw new FacesException(LOCALE_IS_NOT_SET);
        }
        Locale locale = context.getViewRoot().getLocale();
        return locale;
    }

    private void checkInputParameters(FacesContext context, ValueExpression target) {
        if (null == context || null == target) {
            throw new FacesException(INPUT_PARAMETERS_IS_NOT_CORRECT);
        }
    }

    public String[] validate(Object base, String property, Object value, Locale locale) {
        InvalidValue[] invalidValues = this.validateBean(base, property, value, locale);
        if (null == invalidValues) {
            return null;
        }
        String[] result = new String[invalidValues.length];
        for (int i = 0; i < invalidValues.length; ++i) {
            InvalidValue invalidValue = invalidValues[i];
            result[i] = invalidValue.getMessage();
        }
        return result;
    }

    public String[] validateGraph(FacesContext context, Object value, Set<String> profiles) {
        InvalidValue[] invalidValues;
        ClassValidator<? extends Object> validator;
        if (null == context) {
            throw new FacesException(INPUT_PARAMETERS_IS_NOT_CORRECT);
        }
        String[] validationMessages = null;
        if (null != value && (validator = this.getValidator(value.getClass(), this.calculateLocale(context))).hasValidationRules() && null != (invalidValues = validator.getInvalidValues(value)) && invalidValues.length > 0) {
            validationMessages = new String[invalidValues.length];
            for (int i = 0; i < invalidValues.length; ++i) {
                InvalidValue invalidValue = invalidValues[i];
                validationMessages[i] = invalidValue.getMessage();
            }
        }
        return validationMessages;
    }

    protected InvalidValue[] validateBean(Object base, String property, Object value, Locale locale) {
        Class<?> beanClass = base.getClass();
        InvalidValue[] invalidValues = this.validateClass(beanClass, property, value, locale);
        return invalidValues;
    }

    protected InvalidValue[] validateClass(Class<? extends Object> beanClass, String property, Object value, Locale locale) {
        ClassValidator<? extends Object> classValidator = this.getValidator(beanClass, locale);
        InvalidValue[] invalidValues = classValidator.getPotentialInvalidValues(property, value);
        return invalidValues;
    }

    protected ClassValidator<? extends Object> getValidator(Class<? extends Object> beanClass, Locale locale) {
        ValidatorKey key = new ValidatorKey(beanClass, locale);
        ClassValidator<? extends Object> result = this.classValidators.get(key);
        if (null == result) {
            result = this.createValidator(beanClass, locale);
            this.classValidators.put(key, result);
        }
        return result;
    }

    protected ResourceBundle getCurrentResourceBundle(Locale locale) {
        if (null == FacesContext.getCurrentInstance() || null == FacesContext.getCurrentInstance().getApplication()) {
            throw new FacesException(FACES_CONTEXT_IS_NULL);
        }
        String appBundle = FacesContext.getCurrentInstance().getApplication().getMessageBundle();
        if (null == appBundle || null == locale) {
            return null;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ResourceBundle bundle = classLoader != null ? ResourceBundle.getBundle(appBundle, locale, classLoader) : ResourceBundle.getBundle(appBundle, locale);
        return bundle;
    }

    protected ClassValidator<? extends Object> createValidator(Class<? extends Object> beanClass, Locale locale) {
        ResourceBundle bundle = this.getCurrentResourceBundle(locale);
        return bundle == null ? new ClassValidator(beanClass) : new ClassValidator(beanClass, bundle);
    }

    protected ValidationResolver createValidationResolver(ELResolver parent, Locale locale) {
        return new ValidationResolver(parent, locale);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ValidatorKey {
        private final Class<? extends Object> validatableClass;
        private final Locale locale;

        public ValidatorKey(Class<? extends Object> validatableClass, Locale locale) {
            this.validatableClass = validatableClass;
            this.locale = locale;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            result = 31 * result + (this.validatableClass == null ? 0 : this.validatableClass.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ValidatorKey)) {
                return false;
            }
            ValidatorKey other = (ValidatorKey)obj;
            if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
                return false;
            }
            return !(this.validatableClass == null ? other.validatableClass != null : !this.validatableClass.equals(other.validatableClass));
        }
    }

    static class BasePropertyPair {
        private final Object base;
        private final Object property;

        public BasePropertyPair(Object base, Object property) {
            this.base = base;
            this.property = property;
        }

        public Object getBase() {
            return this.base;
        }

        public Object getProperty() {
            return this.property;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ValidationResolver
    extends ELResolver {
        private final ELResolver parent;
        private boolean valid = true;
        private String[] validationMessages = null;
        private Locale locale = null;
        private Stack<BasePropertyPair> valuesStack;

        public ValidationResolver(ELResolver parent, Locale locale) {
            this.parent = parent;
            this.locale = locale;
            this.valuesStack = new Stack();
        }

        public boolean isValid() {
            return this.valid;
        }

        public Class<?> getCommonPropertyType(ELContext context, Object base) {
            return this.parent.getCommonPropertyType(context, base);
        }

        public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
            return this.parent.getFeatureDescriptors(context, base);
        }

        public Class<?> getType(ELContext context, Object base, Object property) {
            return this.parent.getType(context, base, property);
        }

        public Object getValue(ELContext context, Object base, Object property) {
            Object value = this.parent.getValue(context, base, property);
            this.valuesStack.push(new BasePropertyPair(base, property));
            return value;
        }

        public boolean isReadOnly(ELContext context, Object base, Object property) {
            return this.parent.isReadOnly(context, base, property);
        }

        public void setValue(ELContext context, Object base, Object property, Object value) {
            if (null != base && null != property) {
                context.setPropertyResolved(true);
                BasePropertyPair basePropertyPair = this.lookupBeanProperty(new BasePropertyPair(base, property));
                base = basePropertyPair.getBase();
                property = basePropertyPair.getProperty();
                if (null != base && null != property) {
                    this.validationMessages = BeanValidator.this.validate(base, property.toString(), value, this.locale);
                    this.valid = null == this.validationMessages || 0 == this.validationMessages.length;
                }
            }
        }

        private BasePropertyPair lookupBeanProperty(BasePropertyPair pair) {
            Object base = pair.getBase();
            if (null != base && (base instanceof Collection || base instanceof Map || base.getClass().isArray())) {
                try {
                    pair = this.lookupBeanProperty(this.valuesStack.pop());
                }
                catch (EmptyStackException emptyStackException) {
                    // empty catch block
                }
            }
            return pair;
        }

        public String[] getValidationMessages() {
            return this.validationMessages;
        }
    }
}

