package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIPage;

public class HtmlPage extends UIPage{

public final static  String COMPONENT_FAMILY = "org.richfaces.Page";

public final static  String COMPONENT_TYPE = "org.richfaces.Page";

/*
* A name of CSS class for the body part of the page
*/
private  String _bodyClass = null;

/*
* Set custom mime content type to response
*/
private  String _contentType = null;

/*
* Direction indication for text that does not inherit
			directionality. Valid values are "LTR" (left-to-right)
			and "RTL" (right-to-left)
*/
private  String _dir = null;

/*
* A name of CSS class for the footer
*/
private  String _footerClass = null;

/*
* A name of CSS class for the header
*/
private  String _headerClass = null;

/*
* Code describing the language used in the generated markup for this component
*/
private  String _lang = null;

/*
* Page layout format ( html, xhtml, html-transitional, html-3.2 ) for encoding DOCTYPE, namespace and Content-Type definitions
*/
private  String _markupType = null;

/*
* Set html element default namespace
*/
private  String _namespace = null;

/*
* JavaScript code to execute on a page load.
*/
private  String _onload = null;

/*
* JavaScript code to execute on a page unload.
*/
private  String _onunload = null;

/*
* String for output as a page title.
*/
private  String _pageTitle = null;

/*
* A name of CSS class for the side panel
*/
private  String _sidebarClass = null;

/*
* Defines the position of the side panel. Possible values are "left", "right". Default value is "left".
*/
private  String _sidebarPosition = null;

/*
* Defines width for the side panel. Default value is "160".
*/
private  int _sidebarWidth = 160;

private  boolean _sidebarWidthSet = false;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* Specifies the way of the component rendering
*/
private  String _theme = null;

/*
* Advisory title information about markup elements generated for this component
*/
private  String _title = null;

/*
* Sets the width of the page
*/
private  int _width = Integer.MIN_VALUE;

private  boolean _widthSet = false;


public HtmlPage(){
setRendererType("org.richfaces.PageRenderer");
}

public String getBodyClass(){
	if (this._bodyClass != null) {
		return this._bodyClass;
	}
	ValueExpression ve = getValueExpression("bodyClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setBodyClass(String _bodyClass){
this._bodyClass = _bodyClass;
}

public String getContentType(){
	if (this._contentType != null) {
		return this._contentType;
	}
	ValueExpression ve = getValueExpression("contentType");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setContentType(String _contentType){
this._contentType = _contentType;
}

public String getDir(){
	if (this._dir != null) {
		return this._dir;
	}
	ValueExpression ve = getValueExpression("dir");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDir(String _dir){
this._dir = _dir;
}

public String getFooterClass(){
	if (this._footerClass != null) {
		return this._footerClass;
	}
	ValueExpression ve = getValueExpression("footerClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFooterClass(String _footerClass){
this._footerClass = _footerClass;
}

public String getHeaderClass(){
	if (this._headerClass != null) {
		return this._headerClass;
	}
	ValueExpression ve = getValueExpression("headerClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setHeaderClass(String _headerClass){
this._headerClass = _headerClass;
}

public String getLang(){
	if (this._lang != null) {
		return this._lang;
	}
	ValueExpression ve = getValueExpression("lang");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLang(String _lang){
this._lang = _lang;
}

public String getMarkupType(){
	if (this._markupType != null) {
		return this._markupType;
	}
	ValueExpression ve = getValueExpression("markupType");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setMarkupType(String _markupType){
this._markupType = _markupType;
}

public String getNamespace(){
	if (this._namespace != null) {
		return this._namespace;
	}
	ValueExpression ve = getValueExpression("namespace");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setNamespace(String _namespace){
this._namespace = _namespace;
}

public String getOnload(){
	if (this._onload != null) {
		return this._onload;
	}
	ValueExpression ve = getValueExpression("onload");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnload(String _onload){
this._onload = _onload;
}

public String getOnunload(){
	if (this._onunload != null) {
		return this._onunload;
	}
	ValueExpression ve = getValueExpression("onunload");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnunload(String _onunload){
this._onunload = _onunload;
}

public String getPageTitle(){
	if (this._pageTitle != null) {
		return this._pageTitle;
	}
	ValueExpression ve = getValueExpression("pageTitle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setPageTitle(String _pageTitle){
this._pageTitle = _pageTitle;
}

public String getSidebarClass(){
	if (this._sidebarClass != null) {
		return this._sidebarClass;
	}
	ValueExpression ve = getValueExpression("sidebarClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSidebarClass(String _sidebarClass){
this._sidebarClass = _sidebarClass;
}

public String getSidebarPosition(){
	if (this._sidebarPosition != null) {
		return this._sidebarPosition;
	}
	ValueExpression ve = getValueExpression("sidebarPosition");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSidebarPosition(String _sidebarPosition){
this._sidebarPosition = _sidebarPosition;
}

public int getSidebarWidth(){
	if (this._sidebarWidthSet) {
	    return (this._sidebarWidth);
	}
	ValueExpression ve = getValueExpression("sidebarWidth");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._sidebarWidth);
	    }
	    
	    return value;
	} else {
	    return (this._sidebarWidth);
	}

}

public void setSidebarWidth(int _sidebarWidth){
this._sidebarWidth = _sidebarWidth;
this._sidebarWidthSet = true;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getTheme(){
	if (this._theme != null) {
		return this._theme;
	}
	ValueExpression ve = getValueExpression("theme");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTheme(String _theme){
this._theme = _theme;
}

public String getTitle(){
	if (this._title != null) {
		return this._title;
	}
	ValueExpression ve = getValueExpression("title");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTitle(String _title){
this._title = _title;
}

public int getWidth(){
	if (this._widthSet) {
	    return (this._width);
	}
	ValueExpression ve = getValueExpression("width");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._width);
	    }
	    
	    return value;
	} else {
	    return (this._width);
	}

}

public void setWidth(int _width){
this._width = _width;
this._widthSet = true;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[22];
state[0] = super.saveState(context);
state[1] = _bodyClass;
state[2] = _contentType;
state[3] = _dir;
state[4] = _footerClass;
state[5] = _headerClass;
state[6] = _lang;
state[7] = _markupType;
state[8] = _namespace;
state[9] = _onload;
state[10] = _onunload;
state[11] = _pageTitle;
state[12] = _sidebarClass;
state[13] = _sidebarPosition;
state[14] = Integer.valueOf(_sidebarWidth);
state[15] = Boolean.valueOf(_sidebarWidthSet);
state[16] = _style;
state[17] = _styleClass;
state[18] = _theme;
state[19] = _title;
state[20] = Integer.valueOf(_width);
state[21] = Boolean.valueOf(_widthSet);
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_bodyClass = (String)states[1];;
		_contentType = (String)states[2];;
		_dir = (String)states[3];;
		_footerClass = (String)states[4];;
		_headerClass = (String)states[5];;
		_lang = (String)states[6];;
		_markupType = (String)states[7];;
		_namespace = (String)states[8];;
		_onload = (String)states[9];;
		_onunload = (String)states[10];;
		_pageTitle = (String)states[11];;
		_sidebarClass = (String)states[12];;
		_sidebarPosition = (String)states[13];;
		_sidebarWidth = ((Integer)states[14]).intValue();
		_sidebarWidthSet = ((Boolean)states[15]).booleanValue();
		_style = (String)states[16];;
		_styleClass = (String)states[17];;
		_theme = (String)states[18];;
		_title = (String)states[19];;
		_width = ((Integer)states[20]).intValue();
		_widthSet = ((Boolean)states[21]).booleanValue();
	
}

}
