/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.convert.seamtext.tags;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTag
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -372761460000118889L;
    public static final String HR = "hr";
    public static final String BR = "br";
    public static final String IMG = "img";
    public static final String AREA = "area";
    public static final String COL = "col";
    public static final String A = "a";
    public static final String H1 = "h1";
    public static final String H2 = "h2";
    public static final String H3 = "h3";
    public static final String H4 = "h4";
    public static final String P = "p";
    public static final String UL = "ul";
    public static final String OL = "ol";
    public static final String LI = "li";
    public static final String PRE = "pre";
    public static final String TT = "tt";
    public static final String DEL = "del";
    public static final String SUP = "sup";
    public static final String Q = "q";
    public static final String I = "i";
    public static final String U = "u";
    public static final String BLOCKQOUTE = "blockqoute";
    private String name;
    private Map<String, String> attributes;
    protected List<Object> body;
    private boolean isEmpty = true;

    HtmlTag() {
        this.cleanBody();
    }

    HtmlTag(String name) {
        this();
        this.setName(name);
    }

    HtmlTag(String name, Map<String, String> attributes) {
        this();
        this.setName(name);
        this.setAttributes(attributes);
    }

    protected String printPlainStart() {
        StringBuilder builder = new StringBuilder();
        builder.append('<').append(this.getName());
        if (!this.attributes.isEmpty()) {
            builder.append(' ').append(this.printAttributes());
        }
        builder.append('>');
        return builder.toString();
    }

    protected String printStartSuffix() {
        return ">";
    }

    protected String printStart() {
        return this.printPlainStart();
    }

    protected String printAttributes() {
        if (this.attributes == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> pair : this.attributes.entrySet()) {
            builder.append(pair.getKey()).append("=\"").append(this.prepareValue(pair.getValue())).append("\" ");
        }
        return builder.substring(0, builder.length() - 1);
    }

    protected String prepareValue(String value) {
        return value.replace('\"', '^');
    }

    protected void appendChildTag(StringBuilder res, HtmlTag child) {
        res.append(child);
    }

    protected String printBody() {
        StringBuilder res = new StringBuilder();
        for (Object child : this.body) {
            if (child instanceof HtmlTag) {
                this.appendChildTag(res, (HtmlTag)child);
                continue;
            }
            res.append(child);
        }
        return res.toString();
    }

    public void appendBody(HtmlTag tag) {
        this.body.add(tag);
    }

    public void appendBody(String str) {
        this.body.add(str);
    }

    public void cleanBody() {
        this.body = new LinkedList<Object>();
    }

    public boolean isBodyEmpty() {
        for (Object child : this.body) {
            if (child == null || "".equals(child.toString())) continue;
            return false;
        }
        return true;
    }

    protected String printPlainEnd() {
        if (this.isEmpty) {
            // empty if block
        }
        StringBuilder builder = new StringBuilder(this.getName().length() + 3);
        builder.append("</").append(this.getName()).append('>');
        return builder.toString();
    }

    protected String printEnd() {
        return this.printPlainEnd();
    }

    public boolean isLink() {
        return A.equals(this.name);
    }

    public boolean isHeader() {
        return H1.equals(this.name) || H2.equals(this.name) || H3.equals(this.name) || H4.equals(this.name);
    }

    public boolean isParagraph() {
        return P.equals(this.name);
    }

    public boolean isList() {
        return UL.equals(this.name) || OL.equals(this.name);
    }

    public boolean isListItem() {
        return LI.equals(this.name);
    }

    public boolean isPreFormattedElement() {
        return PRE.equals(this.name) || TT.equals(this.name);
    }

    public void setEmpty() {
        this.isEmpty = true;
    }

    public void setNotEmpty() {
        this.isEmpty = false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.toLowerCase();
    }

    public String getAttribute(String attr) {
        return this.attributes.get(attr);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public String toString() {
        return this.print();
    }

    public String print() {
        return this.printStart() + this.printBody() + this.printEnd();
    }

    public String printPlain() {
        return this.printPlainStart() + this.printBody() + this.printPlainEnd();
    }

    protected HtmlTag cloneTag() {
        HtmlTag clone;
        try {
            clone = (HtmlTag)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        clone.name = this.name;
        clone.cleanBody();
        return clone;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

