package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIToolTip;

public class HtmlToolTip extends UIToolTip{

static public final  String COMPONENT_FAMILY = "org.richfaces.component.ToolTip";

static public final  String COMPONENT_TYPE = "org.richfaces.component.ToolTip";

/*
* boolean attribute which provides possibility to limit JSF tree processing(decoding, conversion/validation, value applying) to the component which sends the request only.
				Default value is "true"
*/
private  boolean _ajaxSingle = true;

private  boolean _ajaxSingleSet = false;

/*
* If the value of the "attached" attribute is "true", a component is attached to the parent component;
            	if "false", component does not listen to activating browser events, but could be activated externally.  Default value is "true"
*/
private  boolean _attached = true;

private  boolean _attachedSet = false;

/*
* Defines direction of the popup list to appear. 
	    		Possible values are "top-right", "top-left", "bottom-right", "bottom-left", "auto".
	    		Default value is "bottom-right"
*/
private  String _direction = null;

/*
* If false the components is rendered on the client but JavaScript for calling disabled. Default value is "false"
*/
private  boolean _disabled = false;

private  boolean _disabledSet = false;

/*
* DEPRECATED. Use showEvent instead.  Default value is "mouseover"
*/
private  String _event = null;

/*
* If "true" tooltip should follow the mouse while it moves over the parent element. Default value is "false"
*/
private  boolean _followMouse = false;

private  boolean _followMouseSet = false;

/*
* Id of the target component
*/
private  String _for = null;

/*
* Delay in milliseconds before tooltip will be hidden. Default value is "0"
*/
private  int _hideDelay = 0;

private  boolean _hideDelaySet = false;

/*
* Event that triggers the tooltip disappearance.
	    		Default value is "none" (so, the component does not disappears)
*/
private  String _hideEvent = null;

/*
* Sets the horizontal offset between pop-up list and mouse pointer. Default value is "10"
*/
private  int _horizontalOffset = 10;

private  boolean _horizontalOffsetSet = false;

/*
* Block/inline mode flag. Possible value are: "inline" or "block".  Default value is "inline". Tooltip will contain div/span elements respectively
*/
private  String _layout = null;

/*
* Controls the way of data loading to a tooltip. May have following values: "client" (default) and "ajax"
*/
private  String _mode = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* JavaScript code for call after the tooltip shown
*/
private  String _oncomplete = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* JavaScript code for call after the tooltip hidden
*/
private  String _onhide = null;

/*
* The client side script method to be called when a key is pressed down over the element
*/
private  String _onkeydown = null;

/*
* The client side script method to be called when a key is pressed over the element and released
*/
private  String _onkeypress = null;

/*
* The client side script method to be called when a key is released
*/
private  String _onkeyup = null;

/*
* The client side script method to be called when a mouse button is pressed down over the element
*/
private  String _onmousedown = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _onmouseover = null;

/*
* The client side script method to be called when a mouse button is released
*/
private  String _onmouseup = null;

/*
* JavaScript code for call after the tooltip called (some element overed) but before its requesting
*/
private  String _onshow = null;

/*
* Delay in milliseconds before tooltip will be displayed. Default value is "0"
*/
private  int _showDelay = 0;

private  boolean _showDelaySet = false;

/*
* Event that triggers the tooltip.  Default value is "onmouseover"
*/
private  String _showEvent = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* Sets the vertical offset between pop-up list and mouse pointer. Default value is "10"
*/
private  int _verticalOffset = 10;

private  boolean _verticalOffsetSet = false;

/*
* The same as CSS z-index for toolTip. Default value is "99"
*/
private  int _zorder = 99;

private  boolean _zorderSet = false;


public HtmlToolTip(){
setRendererType("org.richfaces.renderkit.html.ToolTipRenderer");
}

public boolean isAjaxSingle(){
	if (this._ajaxSingleSet) {
	    return (this._ajaxSingle);
	}
	ValueExpression ve = getValueExpression("ajaxSingle");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ajaxSingle);
	    }
	    
	    return value;
	} else {
	    return (this._ajaxSingle);
	}

}

public void setAjaxSingle(boolean _ajaxSingle){
this._ajaxSingle = _ajaxSingle;
this._ajaxSingleSet = true;
}

public boolean isAttached(){
	if (this._attachedSet) {
	    return (this._attached);
	}
	ValueExpression ve = getValueExpression("attached");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._attached);
	    }
	    
	    return value;
	} else {
	    return (this._attached);
	}

}

public void setAttached(boolean _attached){
this._attached = _attached;
this._attachedSet = true;
}

public String getDirection(){
	if (this._direction != null) {
		return this._direction;
	}
	ValueExpression ve = getValueExpression("direction");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "bottom-right";
	

}

public void setDirection(String _direction){
this._direction = _direction;
}

public boolean isDisabled(){
	if (this._disabledSet) {
	    return (this._disabled);
	}
	ValueExpression ve = getValueExpression("disabled");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._disabled);
	    }
	    
	    return value;
	} else {
	    return (this._disabled);
	}

}

public void setDisabled(boolean _disabled){
this._disabled = _disabled;
this._disabledSet = true;
}

public String getEvent(){
	if (this._event != null) {
		return this._event;
	}
	ValueExpression ve = getValueExpression("event");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "mouseover";
	

}

public void setEvent(String _event){
this._event = _event;
}

public boolean isFollowMouse(){
	if (this._followMouseSet) {
	    return (this._followMouse);
	}
	ValueExpression ve = getValueExpression("followMouse");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._followMouse);
	    }
	    
	    return value;
	} else {
	    return (this._followMouse);
	}

}

public void setFollowMouse(boolean _followMouse){
this._followMouse = _followMouse;
this._followMouseSet = true;
}

public String getFor(){
	if (this._for != null) {
		return this._for;
	}
	ValueExpression ve = getValueExpression("for");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFor(String _for){
this._for = _for;
}

public int getHideDelay(){
	if (this._hideDelaySet) {
	    return (this._hideDelay);
	}
	ValueExpression ve = getValueExpression("hideDelay");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._hideDelay);
	    }
	    
	    return value;
	} else {
	    return (this._hideDelay);
	}

}

public void setHideDelay(int _hideDelay){
this._hideDelay = _hideDelay;
this._hideDelaySet = true;
}

public String getHideEvent(){
	if (this._hideEvent != null) {
		return this._hideEvent;
	}
	ValueExpression ve = getValueExpression("hideEvent");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setHideEvent(String _hideEvent){
this._hideEvent = _hideEvent;
}

public int getHorizontalOffset(){
	if (this._horizontalOffsetSet) {
	    return (this._horizontalOffset);
	}
	ValueExpression ve = getValueExpression("horizontalOffset");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._horizontalOffset);
	    }
	    
	    return value;
	} else {
	    return (this._horizontalOffset);
	}

}

public void setHorizontalOffset(int _horizontalOffset){
this._horizontalOffset = _horizontalOffset;
this._horizontalOffsetSet = true;
}

public String getLayout(){
	if (this._layout != null) {
		return this._layout;
	}
	ValueExpression ve = getValueExpression("layout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "inline";
	

}

public void setLayout(String _layout){
this._layout = _layout;
}

public String getMode(){
	if (this._mode != null) {
		return this._mode;
	}
	ValueExpression ve = getValueExpression("mode");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "client";
	

}

public void setMode(String _mode){
this._mode = _mode;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOncomplete(){
	if (this._oncomplete != null) {
		return this._oncomplete;
	}
	ValueExpression ve = getValueExpression("oncomplete");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOncomplete(String _oncomplete){
this._oncomplete = _oncomplete;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOnhide(){
	if (this._onhide != null) {
		return this._onhide;
	}
	ValueExpression ve = getValueExpression("onhide");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnhide(String _onhide){
this._onhide = _onhide;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getOnshow(){
	if (this._onshow != null) {
		return this._onshow;
	}
	ValueExpression ve = getValueExpression("onshow");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnshow(String _onshow){
this._onshow = _onshow;
}

public int getShowDelay(){
	if (this._showDelaySet) {
	    return (this._showDelay);
	}
	ValueExpression ve = getValueExpression("showDelay");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._showDelay);
	    }
	    
	    return value;
	} else {
	    return (this._showDelay);
	}

}

public void setShowDelay(int _showDelay){
this._showDelay = _showDelay;
this._showDelaySet = true;
}

public String getShowEvent(){
	if (this._showEvent != null) {
		return this._showEvent;
	}
	ValueExpression ve = getValueExpression("showEvent");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "onmouseover";
	

}

public void setShowEvent(String _showEvent){
this._showEvent = _showEvent;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public int getVerticalOffset(){
	if (this._verticalOffsetSet) {
	    return (this._verticalOffset);
	}
	ValueExpression ve = getValueExpression("verticalOffset");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._verticalOffset);
	    }
	    
	    return value;
	} else {
	    return (this._verticalOffset);
	}

}

public void setVerticalOffset(int _verticalOffset){
this._verticalOffset = _verticalOffset;
this._verticalOffsetSet = true;
}

public int getZorder(){
	if (this._zorderSet) {
	    return (this._zorder);
	}
	ValueExpression ve = getValueExpression("zorder");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._zorder);
	    }
	    
	    return value;
	} else {
	    return (this._zorder);
	}

}

public void setZorder(int _zorder){
this._zorder = _zorder;
this._zorderSet = true;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[41];
state[0] = super.saveState(context);
state[1] = Boolean.valueOf(_ajaxSingle);
state[2] = Boolean.valueOf(_ajaxSingleSet);
state[3] = Boolean.valueOf(_attached);
state[4] = Boolean.valueOf(_attachedSet);
state[5] = _direction;
state[6] = Boolean.valueOf(_disabled);
state[7] = Boolean.valueOf(_disabledSet);
state[8] = _event;
state[9] = Boolean.valueOf(_followMouse);
state[10] = Boolean.valueOf(_followMouseSet);
state[11] = _for;
state[12] = Integer.valueOf(_hideDelay);
state[13] = Boolean.valueOf(_hideDelaySet);
state[14] = _hideEvent;
state[15] = Integer.valueOf(_horizontalOffset);
state[16] = Boolean.valueOf(_horizontalOffsetSet);
state[17] = _layout;
state[18] = _mode;
state[19] = _onclick;
state[20] = _oncomplete;
state[21] = _ondblclick;
state[22] = _onhide;
state[23] = _onkeydown;
state[24] = _onkeypress;
state[25] = _onkeyup;
state[26] = _onmousedown;
state[27] = _onmousemove;
state[28] = _onmouseout;
state[29] = _onmouseover;
state[30] = _onmouseup;
state[31] = _onshow;
state[32] = Integer.valueOf(_showDelay);
state[33] = Boolean.valueOf(_showDelaySet);
state[34] = _showEvent;
state[35] = _style;
state[36] = _styleClass;
state[37] = Integer.valueOf(_verticalOffset);
state[38] = Boolean.valueOf(_verticalOffsetSet);
state[39] = Integer.valueOf(_zorder);
state[40] = Boolean.valueOf(_zorderSet);
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_ajaxSingle = ((Boolean)states[1]).booleanValue();
		_ajaxSingleSet = ((Boolean)states[2]).booleanValue();
		_attached = ((Boolean)states[3]).booleanValue();
		_attachedSet = ((Boolean)states[4]).booleanValue();
		_direction = (String)states[5];;
		_disabled = ((Boolean)states[6]).booleanValue();
		_disabledSet = ((Boolean)states[7]).booleanValue();
		_event = (String)states[8];;
		_followMouse = ((Boolean)states[9]).booleanValue();
		_followMouseSet = ((Boolean)states[10]).booleanValue();
		_for = (String)states[11];;
		_hideDelay = ((Integer)states[12]).intValue();
		_hideDelaySet = ((Boolean)states[13]).booleanValue();
		_hideEvent = (String)states[14];;
		_horizontalOffset = ((Integer)states[15]).intValue();
		_horizontalOffsetSet = ((Boolean)states[16]).booleanValue();
		_layout = (String)states[17];;
		_mode = (String)states[18];;
		_onclick = (String)states[19];;
		_oncomplete = (String)states[20];;
		_ondblclick = (String)states[21];;
		_onhide = (String)states[22];;
		_onkeydown = (String)states[23];;
		_onkeypress = (String)states[24];;
		_onkeyup = (String)states[25];;
		_onmousedown = (String)states[26];;
		_onmousemove = (String)states[27];;
		_onmouseout = (String)states[28];;
		_onmouseover = (String)states[29];;
		_onmouseup = (String)states[30];;
		_onshow = (String)states[31];;
		_showDelay = ((Integer)states[32]).intValue();
		_showDelaySet = ((Boolean)states[33]).booleanValue();
		_showEvent = (String)states[34];;
		_style = (String)states[35];;
		_styleClass = (String)states[36];;
		_verticalOffset = ((Integer)states[37]).intValue();
		_verticalOffsetSet = ((Boolean)states[38]).booleanValue();
		_zorder = ((Integer)states[39]).intValue();
		_zorderSet = ((Boolean)states[40]).booleanValue();
	
}

}
