package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import org.richfaces.component.UITreeNode;

public class HtmlTreeNode extends UITreeNode{

static public final  String COMPONENT_FAMILY = "org.richfaces.TreeNode";

static public final  String COMPONENT_TYPE = "org.richfaces.TreeNode";

/*
* List of comma separated cursors that indicates when acceptable draggable over dropzone
*/
private  String _acceptCursors = null;

/*
* An algorithm of AJAX request submission. Possible values are "inherit", "true", "false". Default value is "inherit".
*/
private  String _ajaxSubmitSelection = null;

/*
* Listener called on expand/collapse event on the node
*/
private  MethodBinding _changeExpandListener = null;

/*
* Mapping between drop types and acceptable cursors
*/
private  Object _cursorTypeMapping = null;

/*
* MethodBinding representing an action listener method that will be notified after drag operation
*/
private  MethodBinding _dragListener = null;

/*
* Data to be sent to the drop zone after a drop event. Default value is "getUITree().getDragValue()".
*/
private  Object _dragValue = null;

/*
* MethodBinding representing an action listener method that will be notified after drop operation
*/
private  MethodBinding _dropListener = null;

/*
* Data to be processed after a drop event. Default value is "getUITree().getDropValue()".
*/
private  Object _dropValue = null;

/*
* List of comma separated cursors that indicates when you can grab and drag an object
*/
private  String _grabCursors = null;

/*
* List of comma separated cursors that indicates when you has grabbed something
*/
private  String _grabbingCursors = null;

/*
* Corresponds to the HTML class attribute. Applied to highlighted node
*/
private  String _highlightedClass = null;

/*
* The icon for node
*/
private  String _icon = null;

/*
* The icon for collapsed node
*/
private  String _iconCollapsed = null;

/*
* The icon for expanded node
*/
private  String _iconExpanded = null;

/*
* An icon for component leaves
*/
private  String _iconLeaf = null;

/*
* Name of node CSS class
*/
private  String _nodeClass = null;

/*
* MethodBinding representing an action listener method that will be notified after selection of node.
*/
private  MethodBinding _nodeSelectListener = null;

/*
* The client side script method to be called before DOM is updated
*/
private  String _onbeforedomupdate = null;

/*
* The clientside script method to be called when the element is clicked
*/
private  String _onclick = null;

/*
* HTML: script expression to invoke on node collapsing
*/
private  String _oncollapse = null;

/*
* JavaScript handler to be called on right click.
		   Returning false prevents default browser context menu from being displayed
*/
private  String _oncontextmenu = null;

/*
* The client side script method to be called when the element is double-clicked
*/
private  String _ondblclick = null;

/*
* A JavaScript event handler called after a drag operation. Default value is "getDefaultOndragend()".
*/
private  String _ondragend = null;

/*
* A JavaScript event handler called on enter draggable object to zone. Default value is "getDefaultOndragenter()".
*/
private  String _ondragenter = null;

/*
* A JavaScript event handler called after a drag object leaves zone. Default value is "getDefaultOndragexit()".
*/
private  String _ondragexit = null;

/*
* A JavaScript event handler called before drag object. Default value is "getDefaultOndragstart()".
*/
private  String _ondragstart = null;

/*
* It's an event that is called when something is dropped on a drop zone. Default value is "getDefaultOndrop()".
*/
private  String _ondrop = null;

/*
* A JavaScript handler for event fired on a drop even the drop for a given type is not available. Default value is "getDefaultOndropend()".
*/
private  String _ondropend = null;

/*
* A JavaScript event handler called after a out operation
*/
private  String _ondropout = null;

/*
* A JavaScript event handler called after a drop operation
*/
private  String _ondropover = null;

/*
* HTML: script expression to invoke on node expansion
*/
private  String _onexpand = null;

/*
* The client side script method to be called when a key is pressed down over the element
*/
private  String _onkeydown = null;

/*
* The client side script method to be called when a key is pressed over the element and released
*/
private  String _onkeypress = null;

/*
* The client side script method to be called when a key is released
*/
private  String _onkeyup = null;

/*
* The client side script method to be called when a mouse button is pressed down over the element
*/
private  String _onmousedown = null;

/*
* The client side script method to be called when a pointer is moved within the element
*/
private  String _onmousemove = null;

/*
* The client side script method to be called when a pointer is moved away from the element
*/
private  String _onmouseout = null;

/*
* The client side script method to be called when a pointer is moved onto the element
*/
private  String _onmouseover = null;

/*
* The client side script method to be called when a mouse button is released
*/
private  String _onmouseup = null;

/*
* HTML: script expression to invoke on node selection
*/
private  String _onselected = null;

/*
* Id['s] (in format of call  UIComponent.findComponent()) of components, processed at the phases 2-5 in case of AjaxRequest  caused by this component. Can be single id, comma-separated list of Id's, or EL Expression  with array or Collection
*/
private  Object _process = null;

/*
* List of comma separated cursors that indicates when rejectable draggable over dropzone
*/
private  String _rejectCursors = null;

/*
* Corresponds to the HTML class attribute. Applied to selected node
*/
private  String _selectedClass = null;

/*
* A node type
*/
private  String _type = null;

/*
* The attribute associates a type of dragable zone (dragType) with &amp;lt;rich:dndParam&amp;gt; defined for &amp;lt;rich:dropSupport&amp;gt; for passing parameter value to &amp;lt;rich:dragIndicator&amp;gt;. It uses JSON format: (drag_type: parameter_name).
*/
private  Object _typeMapping = null;


public HtmlTreeNode(){
setRendererType("org.richfaces.TreeNodeRenderer");
}

public String getAcceptCursors(){
	if (this._acceptCursors != null) {
		return this._acceptCursors;
	}
	ValueExpression ve = getValueExpression("acceptCursors");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setAcceptCursors(String _acceptCursors){
this._acceptCursors = _acceptCursors;
}

public String getAjaxSubmitSelection(){
	if (this._ajaxSubmitSelection != null) {
		return this._ajaxSubmitSelection;
	}
	ValueExpression ve = getValueExpression("ajaxSubmitSelection");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "inherit";
	

}

public void setAjaxSubmitSelection(String _ajaxSubmitSelection){
this._ajaxSubmitSelection = _ajaxSubmitSelection;
}

public MethodBinding getChangeExpandListener(){
return _changeExpandListener;
}

public void setChangeExpandListener(MethodBinding _changeExpandListener){
this._changeExpandListener = _changeExpandListener;
}

public Object getCursorTypeMapping(){
	if (this._cursorTypeMapping != null) {
		return this._cursorTypeMapping;
	}
	ValueExpression ve = getValueExpression("cursorTypeMapping");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCursorTypeMapping(Object _cursorTypeMapping){
this._cursorTypeMapping = _cursorTypeMapping;
}

public MethodBinding getDragListener(){
return _dragListener;
}

public void setDragListener(MethodBinding _dragListener){
this._dragListener = _dragListener;
}

public Object getDragValue(){
	if (this._dragValue != null) {
		return this._dragValue;
	}
	ValueExpression ve = getValueExpression("dragValue");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return getUITree().getDragValue();
	

}

public void setDragValue(Object _dragValue){
this._dragValue = _dragValue;
}

public MethodBinding getDropListener(){
return _dropListener;
}

public void setDropListener(MethodBinding _dropListener){
this._dropListener = _dropListener;
}

public Object getDropValue(){
	if (this._dropValue != null) {
		return this._dropValue;
	}
	ValueExpression ve = getValueExpression("dropValue");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return getUITree().getDropValue();
	

}

public void setDropValue(Object _dropValue){
this._dropValue = _dropValue;
}

public String getGrabCursors(){
	if (this._grabCursors != null) {
		return this._grabCursors;
	}
	ValueExpression ve = getValueExpression("grabCursors");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setGrabCursors(String _grabCursors){
this._grabCursors = _grabCursors;
}

public String getGrabbingCursors(){
	if (this._grabbingCursors != null) {
		return this._grabbingCursors;
	}
	ValueExpression ve = getValueExpression("grabbingCursors");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setGrabbingCursors(String _grabbingCursors){
this._grabbingCursors = _grabbingCursors;
}

public String getHighlightedClass(){
	if (this._highlightedClass != null) {
		return this._highlightedClass;
	}
	ValueExpression ve = getValueExpression("highlightedClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setHighlightedClass(String _highlightedClass){
this._highlightedClass = _highlightedClass;
}

public String getIcon(){
	if (this._icon != null) {
		return this._icon;
	}
	ValueExpression ve = getValueExpression("icon");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setIcon(String _icon){
this._icon = _icon;
}

public String getIconCollapsed(){
	if (this._iconCollapsed != null) {
		return this._iconCollapsed;
	}
	ValueExpression ve = getValueExpression("iconCollapsed");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setIconCollapsed(String _iconCollapsed){
this._iconCollapsed = _iconCollapsed;
}

public String getIconExpanded(){
	if (this._iconExpanded != null) {
		return this._iconExpanded;
	}
	ValueExpression ve = getValueExpression("iconExpanded");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setIconExpanded(String _iconExpanded){
this._iconExpanded = _iconExpanded;
}

public String getIconLeaf(){
	if (this._iconLeaf != null) {
		return this._iconLeaf;
	}
	ValueExpression ve = getValueExpression("iconLeaf");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setIconLeaf(String _iconLeaf){
this._iconLeaf = _iconLeaf;
}

public String getNodeClass(){
	if (this._nodeClass != null) {
		return this._nodeClass;
	}
	ValueExpression ve = getValueExpression("nodeClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setNodeClass(String _nodeClass){
this._nodeClass = _nodeClass;
}

public MethodBinding getNodeSelectListener(){
return _nodeSelectListener;
}

public void setNodeSelectListener(MethodBinding _nodeSelectListener){
this._nodeSelectListener = _nodeSelectListener;
}

public String getOnbeforedomupdate(){
	if (this._onbeforedomupdate != null) {
		return this._onbeforedomupdate;
	}
	ValueExpression ve = getValueExpression("onbeforedomupdate");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnbeforedomupdate(String _onbeforedomupdate){
this._onbeforedomupdate = _onbeforedomupdate;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOncollapse(){
	if (this._oncollapse != null) {
		return this._oncollapse;
	}
	ValueExpression ve = getValueExpression("oncollapse");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOncollapse(String _oncollapse){
this._oncollapse = _oncollapse;
}

public String getOncontextmenu(){
	if (this._oncontextmenu != null) {
		return this._oncontextmenu;
	}
	ValueExpression ve = getValueExpression("oncontextmenu");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOncontextmenu(String _oncontextmenu){
this._oncontextmenu = _oncontextmenu;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOndragend(){
	if (this._ondragend != null) {
		return this._ondragend;
	}
	ValueExpression ve = getValueExpression("ondragend");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return getDefaultOndragend();
	

}

public void setOndragend(String _ondragend){
this._ondragend = _ondragend;
}

public String getOndragenter(){
	if (this._ondragenter != null) {
		return this._ondragenter;
	}
	ValueExpression ve = getValueExpression("ondragenter");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return getDefaultOndragenter();
	

}

public void setOndragenter(String _ondragenter){
this._ondragenter = _ondragenter;
}

public String getOndragexit(){
	if (this._ondragexit != null) {
		return this._ondragexit;
	}
	ValueExpression ve = getValueExpression("ondragexit");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return getDefaultOndragexit();
	

}

public void setOndragexit(String _ondragexit){
this._ondragexit = _ondragexit;
}

public String getOndragstart(){
	if (this._ondragstart != null) {
		return this._ondragstart;
	}
	ValueExpression ve = getValueExpression("ondragstart");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return getDefaultOndragstart();
	

}

public void setOndragstart(String _ondragstart){
this._ondragstart = _ondragstart;
}

public String getOndrop(){
	if (this._ondrop != null) {
		return this._ondrop;
	}
	ValueExpression ve = getValueExpression("ondrop");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return getDefaultOndrop();
	

}

public void setOndrop(String _ondrop){
this._ondrop = _ondrop;
}

public String getOndropend(){
	if (this._ondropend != null) {
		return this._ondropend;
	}
	ValueExpression ve = getValueExpression("ondropend");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return getDefaultOndropend();
	

}

public void setOndropend(String _ondropend){
this._ondropend = _ondropend;
}

public String getOndropout(){
	if (this._ondropout != null) {
		return this._ondropout;
	}
	ValueExpression ve = getValueExpression("ondropout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndropout(String _ondropout){
this._ondropout = _ondropout;
}

public String getOndropover(){
	if (this._ondropover != null) {
		return this._ondropover;
	}
	ValueExpression ve = getValueExpression("ondropover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndropover(String _ondropover){
this._ondropover = _ondropover;
}

public String getOnexpand(){
	if (this._onexpand != null) {
		return this._onexpand;
	}
	ValueExpression ve = getValueExpression("onexpand");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnexpand(String _onexpand){
this._onexpand = _onexpand;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getOnselected(){
	if (this._onselected != null) {
		return this._onselected;
	}
	ValueExpression ve = getValueExpression("onselected");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnselected(String _onselected){
this._onselected = _onselected;
}

public Object getProcess(){
	if (this._process != null) {
		return this._process;
	}
	ValueExpression ve = getValueExpression("process");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setProcess(Object _process){
this._process = _process;
}

public String getRejectCursors(){
	if (this._rejectCursors != null) {
		return this._rejectCursors;
	}
	ValueExpression ve = getValueExpression("rejectCursors");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setRejectCursors(String _rejectCursors){
this._rejectCursors = _rejectCursors;
}

public String getSelectedClass(){
	if (this._selectedClass != null) {
		return this._selectedClass;
	}
	ValueExpression ve = getValueExpression("selectedClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSelectedClass(String _selectedClass){
this._selectedClass = _selectedClass;
}

public String getType(){
	if (this._type != null) {
		return this._type;
	}
	ValueExpression ve = getValueExpression("type");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setType(String _type){
this._type = _type;
}

public Object getTypeMapping(){
	if (this._typeMapping != null) {
		return this._typeMapping;
	}
	ValueExpression ve = getValueExpression("typeMapping");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTypeMapping(Object _typeMapping){
this._typeMapping = _typeMapping;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[46];
state[0] = super.saveState(context);
state[1] = _acceptCursors;
state[2] = _ajaxSubmitSelection;
state[3] = saveAttachedState(context, _changeExpandListener);
state[4] = saveAttachedState(context, _cursorTypeMapping);
state[5] = saveAttachedState(context, _dragListener);
state[6] = saveAttachedState(context, _dragValue);
state[7] = saveAttachedState(context, _dropListener);
state[8] = saveAttachedState(context, _dropValue);
state[9] = _grabCursors;
state[10] = _grabbingCursors;
state[11] = _highlightedClass;
state[12] = _icon;
state[13] = _iconCollapsed;
state[14] = _iconExpanded;
state[15] = _iconLeaf;
state[16] = _nodeClass;
state[17] = saveAttachedState(context, _nodeSelectListener);
state[18] = _onbeforedomupdate;
state[19] = _onclick;
state[20] = _oncollapse;
state[21] = _oncontextmenu;
state[22] = _ondblclick;
state[23] = _ondragend;
state[24] = _ondragenter;
state[25] = _ondragexit;
state[26] = _ondragstart;
state[27] = _ondrop;
state[28] = _ondropend;
state[29] = _ondropout;
state[30] = _ondropover;
state[31] = _onexpand;
state[32] = _onkeydown;
state[33] = _onkeypress;
state[34] = _onkeyup;
state[35] = _onmousedown;
state[36] = _onmousemove;
state[37] = _onmouseout;
state[38] = _onmouseover;
state[39] = _onmouseup;
state[40] = _onselected;
state[41] = saveAttachedState(context, _process);
state[42] = _rejectCursors;
state[43] = _selectedClass;
state[44] = _type;
state[45] = saveAttachedState(context, _typeMapping);
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_acceptCursors = (String)states[1];;
		_ajaxSubmitSelection = (String)states[2];;
		_changeExpandListener = (MethodBinding)restoreAttachedState(context, states[3]);
		_cursorTypeMapping = (Object)restoreAttachedState(context, states[4]);
		_dragListener = (MethodBinding)restoreAttachedState(context, states[5]);
		_dragValue = (Object)restoreAttachedState(context, states[6]);
		_dropListener = (MethodBinding)restoreAttachedState(context, states[7]);
		_dropValue = (Object)restoreAttachedState(context, states[8]);
		_grabCursors = (String)states[9];;
		_grabbingCursors = (String)states[10];;
		_highlightedClass = (String)states[11];;
		_icon = (String)states[12];;
		_iconCollapsed = (String)states[13];;
		_iconExpanded = (String)states[14];;
		_iconLeaf = (String)states[15];;
		_nodeClass = (String)states[16];;
		_nodeSelectListener = (MethodBinding)restoreAttachedState(context, states[17]);
		_onbeforedomupdate = (String)states[18];;
		_onclick = (String)states[19];;
		_oncollapse = (String)states[20];;
		_oncontextmenu = (String)states[21];;
		_ondblclick = (String)states[22];;
		_ondragend = (String)states[23];;
		_ondragenter = (String)states[24];;
		_ondragexit = (String)states[25];;
		_ondragstart = (String)states[26];;
		_ondrop = (String)states[27];;
		_ondropend = (String)states[28];;
		_ondropout = (String)states[29];;
		_ondropover = (String)states[30];;
		_onexpand = (String)states[31];;
		_onkeydown = (String)states[32];;
		_onkeypress = (String)states[33];;
		_onkeyup = (String)states[34];;
		_onmousedown = (String)states[35];;
		_onmousemove = (String)states[36];;
		_onmouseout = (String)states[37];;
		_onmouseover = (String)states[38];;
		_onmouseup = (String)states[39];;
		_onselected = (String)states[40];;
		_process = (Object)restoreAttachedState(context, states[41]);
		_rejectCursors = (String)states[42];;
		_selectedClass = (String)states[43];;
		_type = (String)states[44];;
		_typeMapping = (Object)restoreAttachedState(context, states[45]);
	
}

}
