/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component.events;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.richfaces.event.AjaxExpandedEvent;
import org.richfaces.event.AjaxSelectedEvent;
import org.richfaces.event.DragEvent;
import org.richfaces.event.DropEvent;
import org.richfaces.event.NodeExpandedEvent;
import org.richfaces.event.NodeSelectedEvent;
import org.richfaces.event.TreeAjaxEvent;
import org.richfaces.event.TreeAjaxEventType;
import org.richfaces.event.TreeListenerEventsProducer;

public class TreeEvents {
    public static void invokeListenerBindings(TreeListenerEventsProducer eventsProducer, FacesEvent event, FacesContext context) throws AbortProcessingException {
        MethodBinding binding = null;
        UIComponent component = event.getComponent();
        if (event instanceof NodeExpandedEvent) {
            binding = eventsProducer.getChangeExpandListener();
            if (event instanceof AjaxExpandedEvent) {
                new TreeAjaxEvent(component, TreeAjaxEventType.EXPANSION).queue();
            }
        } else if (event instanceof AjaxSelectedEvent) {
            if (eventsProducer.hasAjaxSubmitSelection()) {
                binding = eventsProducer.getNodeSelectListener();
                new TreeAjaxEvent(component, TreeAjaxEventType.SELECTION).queue();
            }
        } else if (event instanceof NodeSelectedEvent) {
            binding = eventsProducer.getNodeSelectListener();
        } else if (event instanceof DropEvent) {
            binding = eventsProducer.getDropListener();
        } else if (event instanceof DragEvent) {
            binding = eventsProducer.getDragListener();
        }
        if (binding != null) {
            binding.invoke(context, new Object[]{event});
        }
    }
}

