package org.richfaces.component.html;

import java.util.Set;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIGraphValidator;

public class HtmlGraphValidator extends UIGraphValidator{

final public static  String COMPONENT_FAMILY = "org.richfaces.GraphValidator";

final public static  String COMPONENT_TYPE = "org.richfaces.GraphValidator";

/*
* This attribute is reserved till the implementation of JavaBean Validation feature (JSR-303).
*/
private  Set _profile = null;

/*
* Summary message for a validation errors.
*/
private  String _summary = null;

/*
* JSF Validator type, that implements GraphValidator interface.This validator is used for the Graph and input fields validation.
*/
private  String _type = null;

/*
* The current value for this component.
*/
private  Object _value = null;


public HtmlGraphValidator(){

}

public Set getProfile(){
	if (this._profile != null) {
		return this._profile;
	}
	ValueExpression ve = getValueExpression("profile");
	if (ve != null) {
	    Set value = null;
	    
	    try {
			value = (Set) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setProfile(Set _profile){
this._profile = _profile;
}

public String getSummary(){
	if (this._summary != null) {
		return this._summary;
	}
	ValueExpression ve = getValueExpression("summary");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSummary(String _summary){
this._summary = _summary;
}

public String getType(){
	if (this._type != null) {
		return this._type;
	}
	ValueExpression ve = getValueExpression("type");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "org.richfaces.BeanValidator";
	

}

public void setType(String _type){
this._type = _type;
}

public Object getValue(){
	if (this._value != null) {
		return this._value;
	}
	ValueExpression ve = getValueExpression("value");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setValue(Object _value){
this._value = _value;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[5];
state[0] = super.saveState(context);
state[1] = saveAttachedState(context, _profile);
state[2] = _summary;
state[3] = _type;
state[4] = saveAttachedState(context, _value);
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_profile = (Set)restoreAttachedState(context, states[1]);
		_summary = (String)states[2];;
		_type = (String)states[3];;
		_value = (Object)restoreAttachedState(context, states[4]);
	
}

}
