/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
//
//
//


import org.richfaces.renderkit.InputRendererBase;



/**
 * Renderer for component class org.richfaces.renderkit.html.InputNumberSpinnerRenderer
 */
public class InputNumberSpinnerRenderer extends InputRendererBase {

	public InputNumberSpinnerRenderer () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] scripts = {
						new org.ajax4jsf.javascript.PrototypeScript()
						,
				getResource("script/SpinnerScript.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/browser_info.js")
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	private final InternetResource[] styles = {
						getResource("css/spinner.xcss")
	};

private InternetResource[] stylesAll = null;

protected InternetResource[] getStyles() {
	synchronized (this) {
		if (stylesAll == null) {
			InternetResource[] rsrcs = super.getStyles();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = styles == null || styles.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					stylesAll = new InternetResource[0];	
				} else {
					stylesAll = styles;
				}
			} else {
				if (ignoreThis) {
					stylesAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < styles.length; i++ ) {
						rsrcsSet.add(styles[i]);
					}

					stylesAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return stylesAll;
}
	// 
	// 
	//

	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIInputNumberSpinner.class;
	}


	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIInputNumberSpinner component, ComponentVariables variables) throws IOException {
	  java.lang.String clientId = component.getClientId(context);
variables.setVariable("up_arrow", getResource( "org.richfaces.renderkit.html.images.SpinnerButtonUp" ).getUri(context, component) );

variables.setVariable("down_arrow", getResource( "org.richfaces.renderkit.html.images.SpinnerButtonDown" ).getUri(context, component) );

writer.startElement("table", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "rich-spinner-c " + convertToString(component.getAttributes().get("styleClass")) );
						getUtils().writeAttribute(writer, "id", clientId );
						getUtils().writeAttribute(writer, "onclick", component.getAttributes().get("onclick") );
						getUtils().writeAttribute(writer, "ondblclick", component.getAttributes().get("ondblclick") );
						getUtils().writeAttribute(writer, "onmousedown", component.getAttributes().get("onmousedown") );
						getUtils().writeAttribute(writer, "onmousemove", component.getAttributes().get("onmousemove") );
						getUtils().writeAttribute(writer, "onmouseout", component.getAttributes().get("onmouseout") );
						getUtils().writeAttribute(writer, "onmouseover", component.getAttributes().get("onmouseover") );
						getUtils().writeAttribute(writer, "onmouseup", component.getAttributes().get("onmouseup") );
						getUtils().writeAttribute(writer, "style", component.getAttributes().get("style") );
						getUtils().writeAttribute(writer, "width", "2%" );
			
writer.startElement("tbody", component);

writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-spinner-input-container" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Edit" );
						getUtils().writeAttribute(writer, "style", "width:1%" );
			

			    String autocomplete = "";
               	boolean disableBrowserAutoComplete = getUtils().isBooleanAttribute(component, "disableBrowserAutoComplete");
			    if (disableBrowserAutoComplete)
			    {
			    	autocomplete = "off";
			    }
			    variables.setVariable("autocomplete", autocomplete);
			
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "accesskey", component.getAttributes().get("accesskey") );
						getUtils().writeAttribute(writer, "autocomplete", variables.getVariable("autocomplete") );
						getUtils().writeAttribute(writer, "class", "rich-spinner-input " + convertToString(component.getAttributes().get("inputClass")) );
						getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "onblur", component.getAttributes().get("onblur") );
						getUtils().writeAttribute(writer, "onchange", component.getAttributes().get("onchange") );
						getUtils().writeAttribute(writer, "onclick", component.getAttributes().get("oninputclick") );
						getUtils().writeAttribute(writer, "ondblclick", component.getAttributes().get("oninputdblclick") );
						getUtils().writeAttribute(writer, "onfocus", component.getAttributes().get("onfocus") );
						getUtils().writeAttribute(writer, "onkeydown", component.getAttributes().get("oninputkeydown") );
						getUtils().writeAttribute(writer, "onkeypress", component.getAttributes().get("oninputkeypress") );
						getUtils().writeAttribute(writer, "onkeyup", component.getAttributes().get("oninputkeyup") );
						getUtils().writeAttribute(writer, "onmousedown", component.getAttributes().get("oninputmousedown") );
						getUtils().writeAttribute(writer, "onmousemove", component.getAttributes().get("oninputmousemove") );
						getUtils().writeAttribute(writer, "onmouseout", component.getAttributes().get("oninputmouseout") );
						getUtils().writeAttribute(writer, "onmouseover", component.getAttributes().get("oninputmouseover") );
						getUtils().writeAttribute(writer, "onmouseup", component.getAttributes().get("oninputmouseup") );
						getUtils().writeAttribute(writer, "onselect", component.getAttributes().get("onselect") );
						getUtils().writeAttribute(writer, "size", component.getAttributes().get("inputSize") );
						getUtils().writeAttribute(writer, "style", component.getInputStyle() );
						getUtils().writeAttribute(writer, "tabindex", component.getAttributes().get("tabindex") );
						getUtils().writeAttribute(writer, "type", "text" );
						getUtils().writeAttribute(writer, "value", getInputValue(context,component) );
			
writer.endElement("input");
writer.endElement("td");
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-spinner-buttons" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "For" );
						getUtils().writeAttribute(writer, "style", "width:1%" );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Buttons" );
			
writer.startElement("tbody", component);

writer.startElement("tr", component);

writer.startElement("td", component);


				                	boolean disabled = ((Boolean) component.getAttributes().get("disabled")).booleanValue();
				                	if (! disabled) {
                				
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "class", "rich-spinner-btn rich-spinner-button" );
						getUtils().writeAttribute(writer, "onclick", "return false" );
						getUtils().writeAttribute(writer, "onmousedown", "this.className='rich-spinner-btn-press rich-spinner-button'" );
						getUtils().writeAttribute(writer, "onmouseout", "this.className='rich-spinner-btn rich-spinner-button'" );
						getUtils().writeAttribute(writer, "onmouseup", "this.className='rich-spinner-btn rich-spinner-button'" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("up_arrow") );
						getUtils().writeAttribute(writer, "style", "border:0" );
						getUtils().writeAttribute(writer, "tabindex", component.getAttributes().get("tabindex") );
						getUtils().writeAttribute(writer, "type", "image" );
			
writer.endElement("input");

				                	} else {
                				
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "class", "rich-spinner-btn rich-spinner-button" );
						getUtils().writeAttribute(writer, "onclick", "return false" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("up_arrow") );
						getUtils().writeAttribute(writer, "style", "border:0" );
						getUtils().writeAttribute(writer, "tabindex", component.getAttributes().get("tabindex") );
						getUtils().writeAttribute(writer, "type", "image" );
			
writer.endElement("input");

				                	}
                				
writer.endElement("td");
writer.endElement("tr");
writer.startElement("tr", component);

writer.startElement("td", component);

				                	
				                	if (! disabled) {
                				
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "class", "rich-spinner-btn rich-spinner-button" );
						getUtils().writeAttribute(writer, "onclick", "return false" );
						getUtils().writeAttribute(writer, "onmousedown", "this.className='rich-spinner-btn-press rich-spinner-button'" );
						getUtils().writeAttribute(writer, "onmouseout", "this.className='rich-spinner-btn rich-spinner-button'" );
						getUtils().writeAttribute(writer, "onmouseup", "this.className='rich-spinner-btn rich-spinner-button'" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("down_arrow") );
						getUtils().writeAttribute(writer, "style", "border:0" );
						getUtils().writeAttribute(writer, "type", "image" );
			
writer.endElement("input");

				                	} else {
                				
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "class", "rich-spinner-btn rich-spinner-button" );
						getUtils().writeAttribute(writer, "onclick", "return false" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("down_arrow") );
						getUtils().writeAttribute(writer, "style", "border:0" );
						getUtils().writeAttribute(writer, "type", "image" );
			
writer.endElement("input");

				                	}
                				
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");
java.util.HashMap options = new java.util.HashMap();
	getUtils().addToScriptHash(options, "cycled", component.getAttributes().get("cycled"),  "true" , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(options, "enableManualInput", component.getAttributes().get("enableManualInput"),  "true" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "disabled", component.getAttributes().get("disabled"),  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(options, "required", component.getAttributes().get("required"),  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(options, "clientErrorMessage", component.getAttributes().get("clientErrorMessage"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "min", component.getAttributes().get("minValue"),  "0" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "max", component.getAttributes().get("maxValue"),  "100" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "delta", component.getAttributes().get("step"),  "1" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "onup", component.getAttributes().get("onupclick"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "ondown", component.getAttributes().get("ondownclick"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "onerr", component.getAttributes().get("onerror"),  null , ScriptHashVariableWrapper.DEFAULT);

writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString("new Richfaces.Spinner(\n					\"" + convertToString(clientId) + "\""),null);

if ( Boolean.valueOf( String.valueOf( ( !  getUtils().isEmpty( options )  ) ) ).booleanValue() ) {


writer.writeText(convertToString(","),null);

org.ajax4jsf.javascript.ScriptUtils.writeToStream(writer, options);

}
writer.writeText(convertToString(");"),null);

writer.endElement("script");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIInputNumberSpinner)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
