/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResource;
//
//
//


import org.richfaces.renderkit.html.SimpleTogglePanelRenderer;



/**
 * Renderer for component class org.richfaces.renderkit.html.SimpleToggleControlTemplate
 */
public class SimpleToggleControlTemplate extends SimpleTogglePanelRenderer {

	public SimpleToggleControlTemplate () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] styles = {
						getResource("css/simpleTogglePanel.xcss")
	};

private InternetResource[] stylesAll = null;

protected InternetResource[] getStyles() {
	synchronized (this) {
		if (stylesAll == null) {
			InternetResource[] rsrcs = super.getStyles();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = styles == null || styles.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					stylesAll = new InternetResource[0];	
				} else {
					stylesAll = styles;
				}
			} else {
				if (ignoreThis) {
					stylesAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < styles.length; i++ ) {
						rsrcsSet.add(styles[i]);
					}

					stylesAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return stylesAll;
}
	private final InternetResource[] scripts = {
						new org.ajax4jsf.javascript.PrototypeScript()
						,
				new org.ajax4jsf.javascript.AjaxScript()
						,
				new org.ajax4jsf.javascript.ImageCacheScript()
						,
				getResource("/org/ajax4jsf/javascript/scripts/form.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/browser_info.js")
						,
				getResource("scripts/simpleTogglePanel.js")
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	// 
	// 
	//

	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UISimpleTogglePanel.class;
	}

	
	public void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component ) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeBegin(writer, context, (org.richfaces.component.UISimpleTogglePanel)component, variables );
	}		

	public void doEncodeBegin(ResponseWriter writer, FacesContext context, org.richfaces.component.UISimpleTogglePanel component, ComponentVariables variables ) throws IOException {
	    java.lang.String clientId = component.getClientId(context);

        encodeDivStart(writer, context, component);
    
writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString("SimpleTogglePanelManager.add(new SimpleTogglePanel(\"" + convertToString(clientId) + "\", \n            													\"" + convertToString(component.getAttributes().get("opened")) + "\",{"),null);

writeEventHandlerFunction(context, component, "onexpand");

writer.writeText(convertToString(","),null);

writeEventHandlerFunction(context, component, "oncollapse");

writer.writeText(convertToString("}\n            													\n            							 ));"),null);

writer.endElement("script");
getUtils().encodeBeginFormIfNessesary(context, component);

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-stglpanel-header " + convertToString(component.getAttributes().get("headerClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "_header" );
						getUtils().writeAttribute(writer, "onclick", getOnClick(context,component) );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-stglpanel-marker" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-stglpnl-marker" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "_switch_on" );
						getUtils().writeAttribute(writer, "style", "display: " + convertToString(getSwitchOnStatus(context,component)) + ";" );
			

	                	if(component.getFacet("closeMarker")!=null && component.getFacet("closeMarker").isRendered()) {
	               	 
UIComponent indexChildren_6 = component.getFacet("closeMarker");
if (null != indexChildren_6 && indexChildren_6 .isRendered()) {
	renderChild(context, indexChildren_6);
}


	                    } else {
	                      writer.write("&#171;");
	                    }
	                
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-stglpnl-marker" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "_switch_off" );
						getUtils().writeAttribute(writer, "style", "display: " + convertToString(getSwitchOffStatus(context,component)) + ";" );
			

	                    if(component.getFacet("openMarker")!=null && component.getFacet("openMarker").isRendered()) {
	                
UIComponent indexChildren_7 = component.getFacet("openMarker");
if (null != indexChildren_7 && indexChildren_7 .isRendered()) {
	renderChild(context, indexChildren_7);
}


	                    } else {
	                       writer.write("&#187;");
	                    }
	                
writer.endElement("div");
writer.endElement("div");

            	if(component.getFacet("header")!=null && component.getFacet("header").isRendered()) {
            	
UIComponent indexChildren_8 = component.getFacet("header");
if (null != indexChildren_8 && indexChildren_8 .isRendered()) {
	renderChild(context, indexChildren_8);
}


            	} else {
            	
writer.writeText(convertToString(component.getAttributes().get("label")),null);


                	writer.write("&#160;");
            	}
           	
writer.endElement("div");

            if((component.getSwitchType()!=null) && (component.getSwitchType().equals(component.CLIENT_SWITCH_TYPE)==true)){
        
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "style", "display: none;" );
			
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "autocomplete", "off" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "_input" );
						getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "type", "hidden" );
						getUtils().writeAttribute(writer, "value", component.getAttributes().get("opened") );
			
writer.endElement("input");
writer.endElement("div");

            }
        
getUtils().encodeEndFormIfNessesary(context, component);


            encodeBodyDivStart(writer, context, component);
        

	}		
	
    public void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeChildren(writer, context, (org.richfaces.component.UISimpleTogglePanel)component, variables );
	}		

    public void doEncodeChildren(ResponseWriter writer, FacesContext context, org.richfaces.component.UISimpleTogglePanel component, ComponentVariables variables) throws IOException {
	    
renderChildren(context, component);


	}		

	/* (non-Javadoc)
	 * @see javax.faces.render.Renderer#getRendersChildren()
	 */
	public boolean getRendersChildren() {
		return true;
	}

	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UISimpleTogglePanel component, ComponentVariables variables) throws IOException {
	  

            encodeDivEnd(writer);
            encodeDivEnd(writer);
        

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UISimpleTogglePanel)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
