/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.javascript.DnDScript;
import org.ajax4jsf.javascript.PrototypeScript;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.Draggable;
import org.richfaces.renderkit.CompositeRenderer;
import org.richfaces.renderkit.RendererContributor;
import org.richfaces.renderkit.ScriptOptions;

public class DraggableRendererContributor
implements RendererContributor {
    public static final String DRAG_SOURCE_ID = "dragSourceId";
    private static DraggableRendererContributor instance;

    private DraggableRendererContributor() {
    }

    public static synchronized RendererContributor getInstance() {
        if (instance == null) {
            instance = new DraggableRendererContributor();
        }
        return instance;
    }

    public void decode(FacesContext context, UIComponent component, CompositeRenderer compositeRenderer) {
    }

    public String[] getStyleDependencies() {
        return new String[]{"/org/richfaces/renderkit/html/css/dragIndicator.xcss"};
    }

    public String[] getScriptDependencies() {
        return new String[]{PrototypeScript.class.getName(), "/org/richfaces/renderkit/html/scripts/json/json-mini.js", DnDScript.class.getName(), "/org/richfaces/renderkit/html/scripts/utils.js", "/org/richfaces/renderkit/html/scripts/json/json-dom.js", "/org/richfaces/renderkit/html/scripts/dnd/dnd-common.js", "/org/richfaces/renderkit/html/scripts/dnd/dnd-draggable.js"};
    }

    public ScriptOptions buildOptions(FacesContext context, UIComponent component) {
        if (component instanceof Draggable) {
            UIComponent indicator;
            String simpleId;
            Draggable draggable = (Draggable)component;
            DraggableOptions options = new DraggableOptions(draggable);
            Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)component, Collections.singletonMap(DRAG_SOURCE_ID, component.getClientId(context)), (boolean)true);
            HashMap parameters = (HashMap)eventOptions.get("parameters");
            if (parameters == null) {
                parameters = new HashMap();
            }
            options.addOption("parameters", parameters);
            String indicatorId = draggable.getResolvedDragIndicator(context);
            if (indicatorId == null && (simpleId = draggable.getDragIndicator()) != null && (indicator = RendererUtils.getInstance().findComponentFor(component, simpleId)) != null) {
                indicatorId = indicator.getClientId(context);
            }
            if (indicatorId != null) {
                options.addOption("dragIndicator", indicatorId);
            }
            return options;
        }
        return null;
    }

    public String getScriptContribution(FacesContext context, UIComponent component) {
        return null;
    }

    public Class getAcceptableClass() {
        return Draggable.class;
    }

    public class DraggableOptions
    extends ScriptOptions {
        public DraggableOptions(Draggable draggable) {
            String grabbing;
            super((UIComponent)draggable);
            this.addOption("dragType", draggable.getDragType());
            String grab = draggable.getGrabCursors();
            if (!grab.equals("")) {
                this.addOption("grab", grab);
            }
            if (!(grabbing = draggable.getGrabbingCursors()).equals("")) {
                this.addOption("grabbing", grabbing);
            }
            this.addEventHandler("ondragstart", draggable.getOndragstart());
            this.addEventHandler("ondragend", draggable.getOndragend());
            this.addEventHandler("ondropover", draggable.getOndropover());
            this.addEventHandler("ondropout", draggable.getOndropout());
        }
    }
}

