/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.ContextCallbackWrapper;
import org.ajax4jsf.javascript.DnDScript;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.PrototypeScript;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.richfaces.component.Draggable;
import org.richfaces.component.Dropzone;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.event.DragEvent;
import org.richfaces.event.DropEvent;
import org.richfaces.json.JSONCollection;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONMap;
import org.richfaces.renderkit.CompositeRenderer;
import org.richfaces.renderkit.RendererContributor;
import org.richfaces.renderkit.ScriptOptions;

public class DropzoneRendererContributor
implements RendererContributor {
    public static final String DROP_TARGET_ID = "dropTargetId";
    private static RendererContributor instance;
    private static final String MISTYPED_DND_MESSAGE = "Dropzone [{0}] with accepted types {1} cannot accept Draggable [{2}] with dragType [{3}]";

    private DropzoneRendererContributor() {
    }

    public static synchronized RendererContributor getInstance() {
        if (instance == null) {
            instance = new DropzoneRendererContributor();
        }
        return instance;
    }

    public ScriptOptions buildOptions(FacesContext context, UIComponent drop) {
        if (drop instanceof Dropzone) {
            return new DropZoneOptions((Dropzone)drop);
        }
        return null;
    }

    public void decode(FacesContext context, UIComponent component, CompositeRenderer compositeRenderer) {
        String dragSourceId;
        Map paramMap;
        String clientId = component.getClientId(context);
        if (clientId.equals((paramMap = context.getExternalContext().getRequestParameterMap()).get(DROP_TARGET_ID)) && (dragSourceId = (String)paramMap.get("dragSourceId")) != null && dragSourceId.length() != 0) {
            Dropzone dropzone = (Dropzone)component;
            Object acceptedTypes = dropzone.getAcceptedTypes();
            Object dropValue = dropzone.getDropValue();
            DraggableDecoderContextCallback draggableDecoderContextCallback = new DraggableDecoderContextCallback(dropzone, acceptedTypes, dropValue);
            context.getViewRoot().invokeOnComponent(context, dragSourceId, (ContextCallback)new ContextCallbackWrapper((ContextCallback)draggableDecoderContextCallback));
            Draggable draggable = draggableDecoderContextCallback.getDraggable();
            if (draggable != null) {
                if (draggableDecoderContextCallback.isValid()) {
                    DropEvent dropEvent = new DropEvent(component);
                    dropEvent.setDraggableSource(draggable);
                    dropEvent.setDragType(draggableDecoderContextCallback.getDragType());
                    dropEvent.setDragValue(draggableDecoderContextCallback.getDragValue());
                    dropEvent.queue();
                } else {
                    String text = MessageFormat.format(MISTYPED_DND_MESSAGE, MessageUtil.getLabel((FacesContext)context, (UIComponent)component), acceptedTypes, draggableDecoderContextCallback.getDraggableLabel(), draggableDecoderContextCallback.getDragType());
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, text, text);
                    context.addMessage(component.getClientId(context), message);
                    context.renderResponse();
                }
            }
        }
    }

    public String getScriptContribution(FacesContext context, UIComponent component) {
        StringBuffer result = new StringBuffer();
        result.append(".drop = ");
        JSFunctionDefinition definition = new JSFunctionDefinition(new Object[0]);
        definition.addParameter((Object)"event");
        definition.addParameter((Object)"drag");
        Map requestOpts = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)component, (boolean)true);
        definition.addToBody((Object)"var options = ").addToBody((Object)ScriptUtils.toScript((Object)requestOpts)).addToBody((Object)";");
        definition.addToBody((Object)("options.parameters['dropTargetId'] = '" + component.getClientId(context) + "';"));
        definition.addToBody((Object)"Object.extend(options.parameters, drag.getParameters());");
        definition.addToBody((Object)"var dzOptions = this.getDropzoneOptions(); if (dzOptions.ondrop) { if (!dzOptions.ondrop.call(this, event)) return; };");
        JSFunction dropFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)component, (FacesContext)context);
        dropFunction.addParameter((Object)new JSReference("options"));
        definition.addToBody((Object)dropFunction.toScript()).addToBody((Object)";");
        definition.appendScript(result);
        result.append(";");
        return result.toString();
    }

    public String[] getStyleDependencies() {
        return null;
    }

    public String[] getScriptDependencies() {
        return new String[]{PrototypeScript.class.getName(), "/org/richfaces/renderkit/html/scripts/json/json-mini.js", DnDScript.class.getName(), "/org/richfaces/renderkit/html/scripts/utils.js", "/org/richfaces/renderkit/html/scripts/json/json-dom.js", "/org/richfaces/renderkit/html/scripts/dnd/dnd-common.js", "/org/richfaces/renderkit/html/scripts/dnd/dnd-dropzone.js"};
    }

    public Class getAcceptableClass() {
        return Dropzone.class;
    }

    private static final class DraggableDecoderContextCallback
    implements ContextCallback {
        private Dropzone dropzone;
        private Draggable draggable;
        private String dragType;
        private Object dragValue;
        private Object acceptedTypes;
        private Object dropValue;
        private boolean valid = true;
        private Object draggableLabel;

        public DraggableDecoderContextCallback(Dropzone dropzone, Object acceptedTypes, Object dropValue) {
            this.dropzone = dropzone;
            this.acceptedTypes = acceptedTypes;
            this.dropValue = dropValue;
        }

        private boolean validateAcceptTypes(String dragType, Object acceptedTypes) {
            Set set = AjaxRendererUtils.asSet((Object)acceptedTypes);
            return set != null && set.contains(dragType);
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            this.draggable = (Draggable)target;
            this.dragType = this.draggable.getDragType();
            this.dragValue = this.draggable.getDragValue();
            if (this.validateAcceptTypes(this.dragType, this.acceptedTypes)) {
                DragEvent dragEvent = new DragEvent((UIComponent)this.draggable);
                dragEvent.setDropTarget(this.dropzone);
                dragEvent.setAcceptedTypes(this.acceptedTypes);
                dragEvent.setDropValue(this.dropValue);
                dragEvent.queue();
            } else {
                this.valid = false;
                this.draggableLabel = MessageUtil.getLabel((FacesContext)context, (UIComponent)((UIComponent)this.draggable));
            }
        }

        public Draggable getDraggable() {
            return this.draggable;
        }

        public String getDragType() {
            return this.dragType;
        }

        public Object getDragValue() {
            return this.dragValue;
        }

        public boolean isValid() {
            return this.valid;
        }

        public Object getDraggableLabel() {
            return this.draggableLabel;
        }
    }

    public class DropZoneOptions
    extends ScriptOptions {
        public DropZoneOptions(Dropzone zone) {
            String rejectCursors;
            super((UIComponent)zone);
            Object acceptedTypes = zone.getAcceptedTypes();
            if (acceptedTypes instanceof String) {
                try {
                    String typesString = ((String)acceptedTypes).trim();
                    if (!typesString.startsWith("[")) {
                        typesString = "[" + typesString + "]";
                    }
                    acceptedTypes = new JSONCollection(typesString);
                }
                catch (JSONException e) {
                    throw new FacesException((Throwable)e);
                }
            }
            this.addOption("acceptedTypes", acceptedTypes);
            Object typeMapping = zone.getTypeMapping();
            if (typeMapping instanceof String) {
                try {
                    typeMapping = new JSONMap((String)typeMapping);
                }
                catch (JSONException e) {
                    throw new FacesException((Throwable)e);
                }
            }
            this.addOption("typeMapping", typeMapping);
            Object cursorTypeMapping = zone.getCursorTypeMapping();
            if (cursorTypeMapping instanceof String) {
                try {
                    cursorTypeMapping = new JSONMap((String)cursorTypeMapping);
                }
                catch (JSONException e) {
                    throw new FacesException((Throwable)e);
                }
            }
            this.addOption("cursorTypeMapping", cursorTypeMapping);
            String acceptCursors = zone.getAcceptCursors();
            if (!acceptCursors.equals("")) {
                this.addOption("acceptCursor", acceptCursors);
            }
            if (!(rejectCursors = zone.getRejectCursors()).equals("")) {
                this.addOption("rejectCursor", rejectCursors);
            }
            this.addEventHandler("ondragenter", zone.getOndragenter());
            this.addEventHandler("ondragexit", zone.getOndragexit());
            this.addEventHandler("onafterdrag");
            this.addEventHandler("ondrop");
            this.addEventHandler("ondropend");
        }
    }
}

