/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.AjaxScript;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.PrototypeScript;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.resource.InternetResource;
import org.richfaces.component.UIMenuGroup;
import org.richfaces.component.UIMenuItem;
import org.richfaces.component.UIMenuSeparator;
import org.richfaces.component.util.HtmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMenuRenderer
extends HeaderResourcesRendererBase {
    private final InternetResource[] scripts = new InternetResource[]{new PrototypeScript(), new AjaxScript(), this.getResource("scripts/menu.js")};

    protected InternetResource[] getScripts() {
        return this.scripts;
    }

    protected InternetResource[] getStyles() {
        return super.getStyles();
    }

    public void encodeScript(FacesContext context, UIComponent component) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getLayerScript(context, component));
        List children = component.getChildren();
        ArrayList<Object> scriptObjects = new ArrayList<Object>(children.size());
        Iterator it = children.iterator();
        while (it.hasNext()) {
            Object scriptObject = this.getItemScriptObject(context, (UIComponent)it.next());
            if (scriptObject == null) continue;
            scriptObjects.add(scriptObject);
        }
        if (!scriptObjects.isEmpty()) {
            buffer.append(".");
            JSFunction function = new JSFunction("addItems", new Object[0]);
            function.addParameter(scriptObjects);
            function.appendScript(buffer);
        }
        buffer.append(";");
        context.getResponseWriter().write(buffer.toString());
    }

    protected abstract JSFunction getMenuScriptFunction(FacesContext var1, UIComponent var2);

    protected String getLayerScript(FacesContext context, UIComponent component) {
        StringBuffer buffer = new StringBuffer();
        HashMap options = new HashMap();
        RendererUtils utils = this.getUtils();
        JSFunction function = new JSFunction("new RichFaces.Menu.Layer", new Object[0]);
        function.addParameter((Object)(component.getClientId(context) + "_menu"));
        utils.addToScriptHash(options, "delay", component.getAttributes().get("showDelay"), "300");
        utils.addToScriptHash(options, "hideDelay", component.getAttributes().get("hideDelay"), "300");
        utils.addToScriptHash(options, "selectedClass", component.getAttributes().get("selectedLabelClass"));
        if (!options.isEmpty()) {
            function.addParameter(options);
        }
        function.appendScript(buffer);
        if (component instanceof UIMenuGroup) {
            options = new HashMap();
            buffer.append(".");
            JSFunction subMenuFunction = new JSFunction("asSubMenu", new Object[0]);
            subMenuFunction.addParameter((Object)(component.getParent().getClientId(context) + "_menu"));
            subMenuFunction.addParameter((Object)component.getClientId(context));
            utils.addToScriptHash(options, "evtName", component.getAttributes().get("event"), "onmouseover");
            utils.addToScriptHash(options, "direction", component.getAttributes().get("direction"), "auto");
            utils.addToScriptHash(options, "onopen", component.getAttributes().get("onopen"), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
            utils.addToScriptHash(options, "onclose", component.getAttributes().get("onclose"), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
            if (!options.isEmpty()) {
                subMenuFunction.addParameter(options);
            }
            subMenuFunction.appendScript(buffer);
        } else {
            buffer.append(".");
            JSFunction menuFunction = this.getMenuScriptFunction(context, component);
            Map<String, Object> menuOptions = this.getMenuOptions(component);
            if (!menuOptions.isEmpty()) {
                menuFunction.addParameter(menuOptions);
            }
            menuFunction.appendScript(buffer);
        }
        return buffer.toString();
    }

    protected Map<String, Object> getMenuOptions(UIComponent component) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        RendererUtils utils = this.getUtils();
        utils.addToScriptHash(options, "direction", component.getAttributes().get("direction"), "auto");
        utils.addToScriptHash(options, "jointPoint", component.getAttributes().get("jointPoint"), "auto");
        utils.addToScriptHash(options, "verticalOffset", component.getAttributes().get("verticalOffset"), "0");
        utils.addToScriptHash(options, "horizontalOffset", component.getAttributes().get("horizontalOffset"), "0");
        utils.addToScriptHash(options, "oncollapse", component.getAttributes().get("oncollapse"), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
        utils.addToScriptHash(options, "onexpand", component.getAttributes().get("onexpand"), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
        utils.addToScriptHash(options, "onitemselect", component.getAttributes().get("onitemselect"), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
        utils.addToScriptHash(options, "ongroupactivate", component.getAttributes().get("ongroupactivate"), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
        utils.addToScriptHash(options, "selectItemClass", component.getAttributes().get("selectItemClass"));
        utils.addToScriptHash(options, "itemClass", component.getAttributes().get("itemClass"));
        utils.addToScriptHash(options, "selectItemStyle", component.getAttributes().get("selectItemStyle"));
        utils.addToScriptHash(options, "itemStyle", component.getAttributes().get("itemStyle"));
        return options;
    }

    protected Object getItemScriptObject(FacesContext context, UIComponent kid) {
        String itemId = null;
        ArrayList<Object> scriptObject = null;
        boolean closeOnClick = true;
        Integer flagGroup = null;
        boolean disabled = false;
        if (kid instanceof UIMenuItem) {
            UIMenuItem menuItem = (UIMenuItem)kid;
            itemId = kid.getClientId(context);
            disabled = menuItem.isDisabled();
            if (disabled) {
                closeOnClick = false;
            }
        } else if (kid instanceof UIMenuGroup) {
            UIMenuGroup menuGroup = (UIMenuGroup)kid;
            itemId = kid.getClientId(context);
            closeOnClick = false;
            disabled = menuGroup.isDisabled();
            flagGroup = disabled ? Integer.valueOf(2) : Integer.valueOf(1);
        }
        if (itemId != null) {
            scriptObject = new ArrayList<Object>();
            HashMap options = new HashMap(2);
            RendererUtils utils = this.getUtils();
            scriptObject.add(itemId);
            utils.addToScriptHash(options, "onmouseout", kid.getAttributes().get("onmouseout"), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
            utils.addToScriptHash(options, "onmouseover", kid.getAttributes().get("onmouseover"), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
            utils.addToScriptHash(options, "onselect", kid.getAttributes().get("onselect"), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
            utils.addToScriptHash(options, "closeOnClick", (Object)closeOnClick, "true");
            utils.addToScriptHash(options, "flagGroup", (Object)flagGroup);
            utils.addToScriptHash(options, "styleClass", kid.getAttributes().get("styleClass"));
            utils.addToScriptHash(options, "style", kid.getAttributes().get("style"));
            utils.addToScriptHash(options, "disabledItemClass", kid.getAttributes().get("disabledItemClass"));
            utils.addToScriptHash(options, "disabledItemStyle", kid.getAttributes().get("disabledItemStyle"));
            utils.addToScriptHash(options, "labelClass", kid.getAttributes().get("labelClass"));
            utils.addToScriptHash(options, "selectedLabelClass", kid.getAttributes().get("selectedLabelClass"));
            utils.addToScriptHash(options, "disabledLabelClass", kid.getAttributes().get("disabledLabelClass"));
            utils.addToScriptHash(options, "selectClass", kid.getAttributes().get("selectClass"));
            utils.addToScriptHash(options, "selectStyle", kid.getAttributes().get("selectStyle"));
            utils.addToScriptHash(options, "iconClass", kid.getAttributes().get("iconClass"));
            utils.addToScriptHash(options, "disabled", (Object)disabled);
            if (!options.isEmpty()) {
                scriptObject.add(options);
            }
        }
        return scriptObject;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        LinkedList flatListOfNodes = new LinkedList();
        String width = (String)component.getAttributes().get("popupWidth");
        this.flatten(component.getChildren(), flatListOfNodes);
        this.processLayer(context, component, width);
        for (UIMenuGroup node : flatListOfNodes) {
            if (!node.isRendered() || node.isDisabled()) continue;
            this.processLayer(context, (UIComponent)node, width);
        }
    }

    public void processLayer(FacesContext context, UIComponent layer, String width) throws IOException {
        String clientId = layer.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", layer);
        writer.writeAttribute("id", (Object)(clientId + "_menu"), null);
        this.processLayerStyles(context, layer, writer);
        writer.startElement("div", layer);
        writer.writeAttribute("class", (Object)"rich-menu-list-bg", null);
        this.encodeItems(context, layer);
        writer.startElement("div", layer);
        writer.writeAttribute("class", (Object)"rich-menu-list-strut", null);
        writer.startElement("div", layer);
        writer.writeAttribute("class", (Object)"rich-menu-list-strut", null);
        writer.writeAttribute("style", (Object)(width != null && width.length() > 0 ? "width: " + HtmlUtil.qualifySize((String)width) : ""), null);
        writer.write("&#160;");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("script", layer);
        writer.writeAttribute("id", (Object)(clientId + "_menu_script"), null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        this.encodeScript(context, layer);
        writer.endElement("script");
    }

    public void encodeItems(FacesContext context, UIComponent component) throws IOException {
        List kids = component.getChildren();
        for (UIComponent kid : kids) {
            if (!(kid instanceof UIMenuGroup) && !(kid instanceof UIMenuItem) && !(kid instanceof UIMenuSeparator)) continue;
            this.renderChild(context, kid);
        }
    }

    private void flatten(List kids, List flatList) {
        if (kids != null) {
            for (UIComponent kid : kids) {
                if (!(kid instanceof UIMenuGroup)) continue;
                UIMenuGroup node = (UIMenuGroup)kid;
                flatList.add(node);
                this.flatten(node.getChildren(), flatList);
            }
        }
    }

    protected abstract void processLayerStyles(FacesContext var1, UIComponent var2, ResponseWriter var3) throws IOException;
}

