/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.RendererBase;
import org.richfaces.component.LayoutStructure;
import org.richfaces.component.UILayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutRenderer
extends RendererBase {
    public static final String LAYOUT_STRUCTURE_ATTRIBUTE = UILayout.class.getName() + ".structure";
    private static final Object[] LAYOUT_EXCLUSIONS = new Object[]{"id", "style"};

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.startElement("div", component);
        this.getUtils().encodeCustomId(context, component);
        this.getUtils().encodePassThruWithExclusionsArray(context, component, LAYOUT_EXCLUSIONS);
        Object style = component.getAttributes().get("style");
        writer.writeAttribute("style", (Object)(null == style ? "" : style.toString() + ";" + "zoom:1;"), "style");
    }

    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.renderLayout(writer, context, (UILayout)component);
    }

    public void renderLayout(ResponseWriter writer, FacesContext context, UILayout layout) throws IOException {
        LayoutStructure structure = new LayoutStructure(layout);
        structure.calculateWidth();
        Map requestMap = context.getExternalContext().getRequestMap();
        Object oldLayout = requestMap.get(LAYOUT_STRUCTURE_ATTRIBUTE);
        requestMap.put(LAYOUT_STRUCTURE_ATTRIBUTE, structure);
        if (null != structure.getTop()) {
            structure.getTop().encodeAll(context);
        }
        if (structure.getColumns() > 0) {
            if (null != structure.getLeft()) {
                structure.getLeft().encodeAll(context);
            }
            if (null != structure.getCenter()) {
                structure.getCenter().encodeAll(context);
            }
            if (null != structure.getRight()) {
                structure.getRight().encodeAll(context);
            }
        }
        writer.startElement("div", (UIComponent)layout);
        writer.writeAttribute("style", (Object)"display: block; height: 0;lineHeight:0px;fontSize:0px; clear: both; visibility: hidden;", null);
        writer.writeText((Object)".", null);
        writer.endElement("div");
        if (null != structure.getBottom()) {
            this.renderChild(context, (UIComponent)structure.getBottom());
        }
        requestMap.put(LAYOUT_STRUCTURE_ATTRIBUTE, oldLayout);
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.endElement("div");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return UILayout.class;
    }
}

