if (!window.ExtendedDataTable) window.ExtendedDataTable = {};

ExtendedDataTable.DataTable = Class.create({
	initialize : function(id, options) {
		this.id = id;
		$(this.id).component = this; 
		this["rich:destructor"] = "destroy";
		this.groups = [];
		this.ratios = [];
		
		// register event handlers
		this.options = options;
		this.selectionManager = new ExtendedDataTable.SelectionManager(options, this);
		
		if (this.options.sortFunction) {
			this.sortFct = this.options.sortFunction;
		}
		
		if (this.options.groupFunction) {
			this.groupFct = this.options.groupFunction;
		}
		
		this.onGroupToggleFct = this.options.onGroupToggleFunction;
		if (this.options.onColumnResize != null){
			this.onColumnResize = this.options.onColumnResize;
			this.columnWidths = "";
		}
		this.eventContainerResize = this.OnWindowResize.bindAsEventListener(this);
		this.eventGroupRowClicked = this.OnGroupRowMouseClicked.bindAsEventListener(this);
		Event.observe(window, "resize", this.eventContainerResize);
		this.minColumnWidth = this.options.minColumnWidth;
		
		var grid = this;

		this.updateTimerId = Utils.execOnLoad( function(){ grid.update(true); },
			Utils.Condition.ElementPresent(id+':od'), 100);
	},
	
	destroy: function() {
        
        //remove listeners
        this.selectionManager.removeListeners();
        if (this.header) {
            this.header.removeListeners();
        }
        if (this.groupRows) {
	        var l = this.groupRows.length;
	        for(var i = 0; i < l; i++) {        
	            Utils.DOM.Event.removeListeners(this.groupRows[i]);
	        }
        } 
        
        if (this.updateTimerId) {
        	clearInterval(this.updateTimerId)
        }
        
        //null all references to DOM elements
        delete this.selectionManager;
        delete this.header;
        delete this.footer;
        
        $(this.id).component = null;
        this.table = null;
        this.splashScreen = null;
		this.mainDiv = null;
		this.outerDiv = null;
		this.tableB = null;
		this.fakeIeRow = null;
		this.fakeIeBodyRow = null;
		this.cols = null;
		this.scrollingDiv = null;
		this.groupRows = null;
		this.groups = null;
		Event.stopObserving(window, 'resize', this.eventContainerResize);
	},
	
    /**
     * Changes the scroll position of the table to show row of specified index
     */
    showRow: function(rowIndex) {
        var row = $(this.id+":n:"+rowIndex);
        if(!row){
        	row = $(this.id+":n:"+0);
        }
        var offsetTop = this.tableB.offsetTop + row.offsetTop;
        var scrollTop = this.scrollingDiv.getElement().scrollTop;
        
        var dS = offsetTop - scrollTop;
        
        if (dS < 0) {
            this.scrollingDiv.getElement().scrollTop = scrollTop + dS;
        }else{
            var scrollDivHeight = this.scrollingDiv.getHeight();
            var rowHeight = row.getHeight();
            dS = dS + rowHeight - scrollDivHeight;
            if (dS > 0) {
                this.scrollingDiv.getElement().scrollTop = scrollTop + dS;
            }
        }
	},
	
    setColumnWidth: function(columnIndex, newWidth) {
        if (columnIndex >= this.getColumnsNumber) {
            return false;
        }else{
            //TODO IE fails here, need to find a workaround
            this.getColumns()[columnIndex].width = newWidth;
        }
    },
    	
	_findParentElement: function(event, element) {
		var el = null;
		if(ClientUILib.isSafari) {
			var targetCell = event.currentTarget;
			if(targetCell && targetCell.tagName.toLowerCase() == element) {
				el = targetCell;
			} else {
				var e = (event.target || event.srcElement);
				while((e != null) && (e.tagName.toLowerCase() != element) && (e != document)){
					e = e.parentNode;
				}//while
				if ((e) && (e.tagName.toLowerCase() == element)){
					el = e;
				}
			}
		} else {
			el = Event.findElement(event, element);
		}
		return el;
	},
	
	preSendAjaxRequest: function(){
		//remove listeners
		Event.stopObserving(window, 'resize', this.eventContainerResize);
		//show splash screen
		this.showSplashScreen();
	},
		
	showSplashScreen: function(){
        /**
            Opera 95 is not drawing additional
            element, and so I am commenting this out.
        if (ClientUILib.isOpera) {
            this.mainDiv.setStyle({display:'none'});
        }
        */
        //this.table.setStyle({visibility:'hidden'});
        var splshscr = this.splashScreen;
        splshscr.className = 'extdt-ss-vsbl';
	},
	
	hideSplashScreen: function(){
        /**
            Opera 95 is not drawing additional
            element, and so I am commenting this out.
        if (ClientUILib.isOpera) {
            this.mainDiv.setStyle({display:''});
        }
        */
		//this.table.setStyle({visibility:''});
		this.splashScreen.className = 'extdt-ss-hdn';		
	},
	
	sortBy: function(columnId, ascending, event){
		if (this.sortFct){
			this.preSendAjaxRequest();
			if (!columnId){
				columnId = "";
			}
			else{
				//prepend table id if necessary
				if (columnId.indexOf(":") == -1){
					columnId = this.id + ":" + columnId;
				}
			}
			this.sortFct(event, columnId, ascending);
		}
	},
	
	groupBy: function(columnId, event){
		if (this.groupFct){
			this.preSendAjaxRequest();
			if (!columnId){
				columnId = "";
			}
			else{
				//prepend table id if necessary
				if (columnId.indexOf(":") == -1){
					columnId = this.id + ":" + columnId;
				}
			}
			this.groupFct(event, columnId);
		}
	},
	
	OnWindowResize: function(event) {
        if (this.table) {
            this.calculateWidthsFromRatios();
            this.updateLayout();
            //this.correctColumns();
        }
	},
	getColumnsNumber: function() {
		return this.columnsNumber;
	},
	getColWidth: function(columnNumber) {
		
	},
	getColumns: function() {
		return this.cols;
	},
	OnGroupRowMouseClicked: function(event) {
		
		var groupRow = this._findParentElement(event, "tr");
		var bExpanded = !(groupRow.getAttribute('expanded') == 'true');
		var sExpanded = bExpanded ? 'true' : 'false';
		var groupIndex = parseInt(groupRow.getAttribute('groupindex'));
		if (this.onGroupToggleFct){
			this.onGroupToggleFct(event, groupIndex);
		}
		groupRow.setAttribute('expanded', sExpanded);
		var imageDiv = groupRow.firstChild.firstChild.firstChild;
		this.toggleImageSource(imageDiv);
		this.setGroupExpanded(groupIndex, bExpanded);
		Event.stop(event);
	},
	
	toggleImageSource: function(imageDiv) {
		var src = imageDiv.getAttribute('src');
		var alternateSrc = imageDiv.getAttribute('alternatesrc');
		imageDiv.setAttribute('src', alternateSrc);
		imageDiv.setAttribute('alternatesrc', src);		
	},
	
    getColumnWidth: function(columnNumber) {
        if ((columnNumber < this.getColumnsNumber()) && (columnNumber >=0)) {
            var col = this.getColumns()[columnNumber];
            if (col.offsetWidth != null) {
                if (ClientUILib.isOpera) {
                    return parseInt(col.width);
                }else{
                    return col.offsetWidth;
                }
            }else{
                return parseInt(col.width);
            }
        }else{
            return null;
        }
    },
	
	setGroupExpanded: function(iGroupIndex, bValue) {
		var group = this.groups[iGroupIndex];
		
		var sVisibility;
		var sBorder;
		var sEmptyCells;
		
		if (bValue) {
			sVisibility = '';
			sBorderStyle = '';
		}else{
			sVisibility = 'none';
			sBorderStyle = 'none';
		}
		var size = group.size();
		for (var i=0; i<size; i++) {
			group[i].style.display = sVisibility;
			if (ClientUILib.isIE){
				//prevent IE from showing borders of cells
				//which parents have been hidden :|
				var cells = group[i].childNodes;
				var l = cells.length;
				for (var j = 0; j < l; j++) {
					cells[j].style.borderStyle = sBorderStyle;
				}
			}
		}
	},
	
	createControls: function() {
		var id = this.id;
		this.table = new ClientUI.common.box.Box(this.id +":tu",null,true);
		var table = this.table;
		this.splashScreen = $(this.id+":splashscreen");
		this.mainDiv = new ClientUI.common.box.Box(this.id,null,true);
		this.outerDiv = new ClientUI.common.box.Box(this.id +":od",null,true);
		this.tableB = $(this.id +":n");
		this.fakeIeRow = $(this.id +":fakeIeRow");
		this.fakeIeBodyRow = $(this.id +":body:fakeIeRow");
		this.header = new ExtendedDataTable.DataTable.header(this.id +":header",this);
		this.header.minColumnWidth = this.minColumnWidth;
		this.header.addListeners();
		var colgroup = $(this.id +":colgroup:body");
		this.cols = colgroup.getElementsByTagName("col");
		this.columnsNumber = this.cols.length;
		this.scrollingDiv = new ClientUI.common.box.Box(this.id +":sd",null,true);
		this.groupRows = [];
		var tfoot = table.getElement().getElementsByTagName('tfoot');
        this.footer = $(this.id +":footer");
		if (ClientUILib.isOpera) {
			//no overflow-x nor overflow-y in Opera
			this.scrollingDiv.setStyle({width: this.mainDiv.getWidth()});
			this.table.setStyle({width: this.mainDiv.getWidth()});
		};
		
		var i = 0;
		var groupRow = $(id+':group-row:'+i);
		while (groupRow != null) {
			this.groupRows[i] = groupRow;
			Utils.DOM.Event.removeListeners(groupRow);
			Utils.DOM.Event.observe(groupRow,'click',this.eventGroupRowClicked);
			i++;
			groupRow = $(id+':group-row:'+i);
		}
		this.saveRatios();
	},
	
	getScrollbarWidth: function() {
		var sd = this.scrollingDiv.getElement();
		LOG.debug("Scrolling Div offsetWidth: " + sd.offsetWidth);
		LOG.debug("Scrolling Div clientWidth: " + sd.clientWidth);
		return sd.offsetWidth - sd.clientWidth;
	},
	validateColumnsWidth: function(columns,excessWidth) { 
	    LOG.debug('firing validateColumnsWidth');
		var i=0;
		var endIndex = columns.length-1;
		while ((i < endIndex) && (excessWidth > 0)) {
            if (ClientUILib.isIE) {
                var colWidth = parseInt(this.getColumns()[i].width) - 1;
            }else{
                var colWidth = this.header.getColumnWidth(i);
            }
            var spareWidth = colWidth - this.minColumnWidth;
            var dW;
            if (spareWidth >= excessWidth) {
                dW = excessWidth; 
            }else{
                dW = spareWidth;
            }
            this.setColumnWidth(i, colWidth - dW);
            this.header.setColumnWidth(i, colWidth - dW);
            excessWidth -= dW;
            i++;
		/*
			var col = columns[columns.length-i-1];
			var spareWidth = col.offsetWidth - this.minColumnWidth;
			if (spareWidth > excessWidth) {
				col.width = col.offsetWidth - excessWidth;
				columns[endIndex - i].width = col.width;
				excessWidth = 0;
			}else{
				col.width = col.offsetWidth - spareWidth;
				columns[endIndex - i].width = col.width;
				excessWidth -= spareWidth;
			}
		*/
		}
	},
	
	getFooterHeight: function() {
        if (this.footer) {
            return this.footer.getHeight();
        }else{
            return 0;
        }
	},
	
	updateLayout: function() {
	    ClientUILib.log(ClientUILogger.INFO, "updateLayout");
		var table = this.table.getElement();
		var outerDiv = this.outerDiv.getElement();
		var cols = this.getColumns();
		var header = this.header;
		var scrollingDiv = this.scrollingDiv;
		var mainDivHeight = this.mainDiv.getHeight();
		var mainDivWidth = this.mainDiv.getWidth();
		var headerChildren = header.getColumnCells();
		
		var footers = table.getElementsByTagName('tfoot');
		var footerHeight = this.getFooterHeight();

		var columnsNumber = this.getColumnsNumber();		
		var visibleHeaderWidth = this.header.getVisibleWidth();
        //var scrollbarWidth = scrollingDiv.getElement().offsetWidth - scrollingDiv.getElement().clientWidth;
        var scrollbarWidth = this.getScrollbarWidth();
        var maxAllowedWidth = mainDivWidth - scrollbarWidth;
        for (var i=0; i < columnsNumber-1; i++) {
            if (this.header.isColumnWidthPercentage(i)) {
                //change percents into pixels
                var width = this._percentsToPixels(this.header.getColumn(i).width, maxAllowedWidth);
                this.header.setColumnWidth(i, width);
                this.setColumnWidth(i, width);
            }
        }
        //var excessWidth = this.header.getVisibleWidth() - maxAllowedWidth - 1;
		//if (excessWidth > 0) {
		//    this.validateColumnsWidth(cols,excessWidth);
		//};
        cols[columnsNumber-1].width = null;
        cols[cols.length-1].width = null;
		var newHeight = mainDivHeight - header.getHeight() - footerHeight - 2;
		var caption = header.getCaption()
		if (caption && caption.tagName == "caption") {
			newHeight -= this.header.getCaptionHeight();
		}
		scrollingDiv.setStyle('height:'+ newHeight +'px;');
		this._redrawTable(table);
		header.adjustSeparators();
		this._redrawTable(this.tableB);
		this.saveRatios();
		this.hideSplashScreen();
	},
	
	/**
    *  Calculates ratios of column width to total table width. 
    */
    saveRatios: function() {
        LOG.debug('saveRatios');
        var c = this.getColumns(); //table columns
        var scrollbarWidth;
        if(!this._scrollbarWidth) {
            scrollbarWidth = this.getScrollbarWidth(); //width of the scrollbar
            LOG.debug('Scrollbar: ' + scrollbarWidth);
        } else {
            scrollbarWidth = this._scrollbarWidth;
            LOG.debug('Scrollbar (cache): ' + this._scrollbarWidth);
        }
        var mainDivWidth = this.mainDiv.getWidth(); //width of the whole div with table
        LOG.debug('Main DIV: ' + mainDivWidth);
        var maxWidth = mainDivWidth - scrollbarWidth; //max width of the table
        LOG.debug('Width to spread: ' + maxWidth);
        //generate ratio for each column
        for(i = 0;i < c.length - 1;i++) {
            var w = c[i].width;
            if(this.header.isColumnWidthPercentage(i)) {//width in percents
               //convert to pixels
               w = this._percentsToPixels(w, maxWidth);
            }
            this.ratios[i] = w / maxWidth;
            LOG.debug('Column[' + i + '] ratio: ' + this.ratios[i]);
        }
    },
	
	calculateWidthsFromRatios: function() {
	    LOG.debug('firing calculateWidthsFromRatios');
	    var c = this.getColumns(); //table columns
        var scrollbarWidth = this.getScrollbarWidth(); //width of the scrollbar
        this._scrollbarWidth = scrollbarWidth;
        LOG.debug('Scrollbar: ' + scrollbarWidth);
        var mainDivWidth = this.mainDiv.getWidth(); //width of the whole div with table
        LOG.debug('Main DIV: ' + mainDivWidth);
        var maxWidth = mainDivWidth - scrollbarWidth; //max width of the table
        LOG.debug('Width to spread: ' + maxWidth);
        var totalWidth = 0;
        //set widths according to each column's width ratio
	    for(i = 0;i < c.length - 1;i++) {
	        LOG.debug('Column[' + i + '] ratio: ' + this.ratios[i]);
	        var w = Math.round(this.ratios[i] * maxWidth);
	        if(w < parseInt(this.minColumnWidth)) {
	           w = parseInt(this.minColumnWidth);
	        }
	        LOG.debug('setting column ' + i + ' to width: ' + w);
	        this.setColumnWidth(i, w);
            this.header.setColumnWidth(i, w);
            totalWidth += w;
	    }
	    //Compensate for rounding inaccuracy
	    if(totalWidth > maxWidth) {
	        //reduce width of the last column
	        c[c.length - 2].width -= (totalWidth - maxWidth);
	    }
	},
	
    update: function(refreshEvents) {
        this.createControls();
        if ( !ClientUILib.isIE ) {
            if (this.fakeIeRow) {
				this.table.getElement().deleteRow(this.fakeIeRow.rowIndex);	
				this.fakeIeRow = null;
			}
			if (this.fakeIeBodyRow) {
				this.tableB.deleteRow(this.fakeIeBodyRow.rowIndex);
				this.fakeIeBodyRow = null;
			}
		};
		this.selectionManager.refreshEvents();
		this.updateLayout();
		this.selectionManager.restoreState();
	},
	
	_percentsToPixels: function(percents, maxAllowedWidth) {
	   var val = (percents.substr(0, percents.length-1)*1)/100;
       return maxAllowedWidth*val;
	},
	
	_redrawTable: function(table) {
    	table.hide(); //this is for opera < 9.5
    	if (ClientUILib.isSafari){
			var tr = table.insertRow(0);
	        var td = tr.insertCell(0);
	        td.setAttribute("colspan", 5);
	        td.innerHTML = "safari-must-have-something-inserted-to-redraw-table";
	        table.deleteRow(tr.rowIndex);
		}
        table.show(); 
	}

});/** 

*/
ExtendedDataTable.DataTable.header = Class.create(ClientUI.common.box.Box, {
	// constructor
	initialize: function($super, elementId, extDt) {
		this.extDt = extDt;
		this.extDtId = this.extDt.id;
		this.enableContextMenu = this.extDt.options.enableContextMenu;
		$super(elementId,extDt,true);
		
		//register events
		this.eventSepClick = this.OnSepClick.bindAsEventListener(this);
		this.eventSepMouseDown = this.OnSepMouseDown.bindAsEventListener(this);
		this.eventSepMouseMove = this.OnSepMouseMove.bindAsEventListener(this);
		this.eventSepMouseUp = this.OnSepMouseUp.bindAsEventListener(this);
		this.eventHeaderCellMouseOver = this.OnHeaderCellMouseOver.bindAsEventListener(this);
		this.eventHeaderCellMouseOut = this.OnHeaderCellMouseOut.bindAsEventListener(this);
		if (this.enableContextMenu) {
			var showMenuFct = this.extDt.options.showMenuFunction;
			if (showMenuFct) {
				this.showMenuFct = showMenuFct;
				this.menuImageMouseDown = this.OnMenuImageMouseDown.bindAsEventListener(this);
			};
		}
		if (this.extDt.sortFct) {
			this.eventHeaderCellClicked = this.OnHeaderCellMouseClicked.bindAsEventListener(this);
		}
		this.createControl(elementId);
	},
	
	OnHeaderCellMouseOver: function(event) {
		if (this.enableContextMenu) {
			var el = this.extDt._findParentElement(event, "th");
			var menuDiv = $(el.id+"header:menuDiv");
			menuDiv.className = "extdt-menu-div-on";
		}
	},

    OnHeaderCellMouseOut: function(event) {
    	if (this.enableContextMenu) {
			var el = this.extDt._findParentElement(event, "th");
			var menuDiv = $(el.id+"header:menuDiv");
			menuDiv.className = "extdt-menu-div-out";
		}
    },
    
    OnHeaderCellMouseClicked: function(event) {
		//get column id
		var el = this.extDt._findParentElement(event, "th");
		var columnId = (el) ? el.id : null;
			
		if (columnId && (columnId != "")){
			this.extDt.sortBy(columnId, null, event);		
		}
		Event.stop(event);
	},
	
	getCaption: function() {
       return this.caption;
    },
	
	getCaptionHeight: function() {
	   var caption = this.getCaption();
	   if (caption) {
	       return caption.getHeight();
	   }else{
	       return 0;
	   }
	},
	
	addListeners: function(){
		var columnCells = this.getColumnCells();
        var l = columnCells.length;
        for (var i = 0; i< l-1; i++) {
            var headerChild = columnCells[i];
            //remove listeners
            Utils.DOM.Event.removeListeners(headerChild);
            //add listeners
            Utils.DOM.Event.observe(headerChild,'mouseover',this.eventHeaderCellMouseOver);
            Utils.DOM.Event.observe(headerChild,'mouseout',this.eventHeaderCellMouseOut);
            
            var isSortable = headerChild.getAttribute('sortable');
            if ((isSortable) && (isSortable.indexOf('true') == 0)) {
            	var sortDiv = $(headerChild.id + ":sortDiv");
            	if (sortDiv){
                	Utils.DOM.Event.observe(sortDiv, 'click',  this.eventHeaderCellClicked);
                }
            }
            var headerChildChildren = headerChild.childElements();
            if (headerChildChildren == null || headerChildChildren.size() == 0){
				continue;
			}
			if (this.enableContextMenu) {
				var menuImage = headerChildChildren[7];
				Utils.DOM.Event.removeListeners(menuImage);
				Utils.DOM.Event.observe(menuImage,'click',this.menuImageMouseDown);
			};
            var sepSpan = headerChildChildren[2];
			Utils.DOM.Event.removeListeners(sepSpan);			
			Utils.DOM.Event.observe(sepSpan, 'click',  this.eventSepClick);
			Utils.DOM.Event.observe(sepSpan, 'mousedown', this.eventSepMouseDown);
			Utils.DOM.Event.observe(sepSpan, 'mousemove', this.eventSepMouseMove);
			Utils.DOM.Event.observe(sepSpan, 'mouseup', this.eventSepMouseUp);
        }
	},
    
    removeListeners: function() {
        var columnCells = this.getColumnCells();
        var l = columnCells.length;
        for (var i = 0; i< l-1; i++) {
            var headerChild = columnCells[i];
            Utils.DOM.Event.removeListeners(headerChild);
            
            var sortDiv = $(headerChild.id + ":sortDiv");
            if (sortDiv){
               	Utils.DOM.Event.stopObserving(sortDiv, 'click');
            }
            
            var headerChildChildren = headerChild.childElements();
            if (headerChildChildren == null || headerChildChildren.size() == 0){
				continue;
			}
			if (this.enableContextMenu) {
				var menuImage = headerChildChildren[7];
				Utils.DOM.Event.removeListeners(menuImage);
			}
            var sepSpan = headerChildChildren[2];
            Utils.DOM.Event.removeListeners(sepSpan);
        };
    },
	
	getVisibleWidth: function() {
		var sum = 0;
		var l = this.getColumnsNumber();
		for(var i = 0; i < l-1; i++){
			sum += this.getColumnWidth(i);
		}
		return sum;
	},		
	
	createControl: function(elementId) {
		if(!elementId) {
			errMsg = "Invalid id specified for ExtendedDataTableGridHeader.";
			throw(errMsg);
		}

		if(!this.parseTemplate(elementId)) {
			//TODO insert comment about header structure here
			errMsg = "TODO insert commnet about header structure here";
			throw(errMsg);
		}
	},
	
	parseTemplate: function(template) {
		if(!template) {
			return false;
		}
		this.headerRow = new ClientUI.common.box.Box(this.extDtId +":headerRow",this.getElement(),true);
		this.filterRow = new ClientUI.common.box.Box(this.extDtId +":filterRow",this.getElement(),true);
		this.caption = new ClientUI.common.box.Box(this.extDtId +":caption",this.getElement(),true);
		var colgroup = $(this.extDtId +":colgroup:header");
        this.cols = colgroup.getElementsByTagName("col");
        this.columnsNumber = this.cols.length;
		this.columnCells = this.headerRow.getElement().childElements();
		return true;
	},
	getColumns: function() {
		return this.cols;
	},
    getColumn: function(index) {
        if (this.isValidColumnNumber(index)) {
            return this.cols[index];
        }else{
            return null;
        }
    },
	getColumnCells: function() {
		return this.columnCells;
	},
	getColumnsNumber: function() {
		return this.columnsNumber;
	},
	
	setColumnWidth: function(columnIndex, newWidth) {
	   if (columnIndex >= this.getColumnsNumber()) {
	       return false;
	   }else{
	       if (!newWidth) {
	           newWidth = null;
	       }
	       this.getColumns()[columnIndex].width = newWidth;
	   }
	},
	
	isValidColumnNumber: function(columnNumber) {
        return ((columnNumber < this.getColumnsNumber()) && (columnNumber >=0))
	},
	
	getColumnWidth: function(columnNumber) {
		if (this.isValidColumnNumber(columnNumber)) {
			var col = this.getColumnCells()[columnNumber];
            if (col.offsetWidth != null) {
                return col.offsetWidth;
            }else{
                col = this.getColumns()[columnNumber];
                return parseInt(col.width);
            }
		}else{
			return null;
		}
	},
	
	isColumnWidthPercentage: function(columnNumber) {
        if (this.isValidColumnNumber(columnNumber)) {
            var col = this.getColumns()[columnNumber];
            var width = col.width;
            if ((!Object.isNumber(width)) && (width.indexOf('%') != -1)) {
                return true;
            }else{
                return false;
            }
        }else{
            return null;
        }
	}, 
	
	getHeightWithoutFacets: function() {
		return this.headerRow.getHeight() + this.filterRow.getHeight();
	},
	
	getTotalHeight: function() {
        var ret = this.headerRow.getHeight() + this.filterRow.getHeight();
        if (this.caption) {
            ret += this.caption.getHeight();
        }
        return ret;
	},
	
	OnMenuImageMouseDown: function(event) {
		var el = this.extDt._findParentElement(event, "th");
		var columnId = (el) ? el.id : null;
		
		if (columnId && (columnId != "")){
			var menuId = "#" + columnId + "menu";
			menuId = menuId.replace(/:/g,"\\:");
			this.showMenuFct(event, columnId, menuId);
		}
		Event.stop(event);
	},
		
	adjustSeparators: function() {
		var columnCells = this.getColumnCells();
		var l = columnCells.length;
		for (var i=0; i<l-1; i++) {
			var headerChild = columnCells[i];
			var headerNextChild = columnCells[i+1];
			var headerChildChildren = headerChild.childElements();
			if (headerChildChildren == null || headerChildChildren.size() == 0){
				continue;
			}
			var sepSpan = headerChildChildren[2];
			var headerRowHeight = this.headerRow.getHeight();
			var headerRowY = this.headerRow.getY();
			sepSpan.columnIndex = i;
			var sd = sepSpan.getWidth()/2 + 1;
			var dropSpanLeft = headerChildChildren[3];
			var dropSpanRight = headerChildChildren[5];
			var menuImage = headerChildChildren[7];
			var spanLeft = headerNextChild.offsetLeft - sd;
			sepSpan.setStyle({height: headerRowHeight+'px', top: headerRowY+'px', left: spanLeft+'px'});
			menuImage.setStyle({top: headerRowY + 'px', left: (headerNextChild.offsetLeft-menuImage.offsetWidth - 1)+'px'});
			//menuImage.setStyle('left:'+(spanLeft-menuImage.offsetWidth)+'px');
			var w = parseInt(headerChild.getWidth()/2);
			dropSpanLeft.setStyle({top: headerRowY+'px', left: (headerChild.offsetLeft) +'px', height: headerRowHeight+'px', width: w+'px'});
			dropSpanRight.setStyle({top: headerRowY+'px', left: (headerChild.offsetLeft + w) +'px', height: headerRowHeight+'px', width: w+'px'});
		}
		this.lastColWidth = this.extDt.getColumnWidth(this.getColumnsNumber()-1);
		if (ClientUILib.isIE){
			this.lastColWidth -= 15;
		}
	},
	
	OnSepClick: function(event) {
		Event.stop(event);
		this.dragColumnInfo.mouseDown = false;
	},
	
	OnSepMouseDown: function(event) {
		Event.stop(event);
		this.dragColumnInfo = {
			srcElement: Event.element(event),
			dragStarted: false,
			mouseDown: true,
			startX: Event.pointerX(event),
			originalX: 0
		};
		var srcElement = this.dragColumnInfo.srcElement;
		this.maxDelta = this.getColumnWidth(this.getColumnsNumber()-1);
		this.maxDelta -= this.extDt.getScrollbarWidth();
        if (ClientUILib.isOpera) {
            this.maxDelta -= 1;
        };
		this.minDelta = this.minColumnWidth - this.getColumnWidth(srcElement.columnIndex);
		Event.observe(document, 'mousemove', this.eventSepMouseMove, true);
		Event.observe(document, 'mouseup', this.eventSepMouseUp, true);
	},
	
	_showSplitter: function(index) {
		if(!this.columnSplitter) {
			this._createSplitter();
		}

		var pos = this.dragColumnInfo.srcElement.offsetLeft;
		pos += 6; //6 stands for width of the separatorSpan
		this.dragColumnInfo.originalX = pos;
		this.columnSplitter.show();
		this.columnSplitter.setHeight(this.extDt.scrollingDiv.getHeight()+
			this.getHeightWithoutFacets()
		);
		this.columnSplitter.moveTo(pos, this.headerRow.getY());
	},
	_hideSplitter: function() {
		if(this.columnSplitter) {
			this.columnSplitter.hide();
		}
	},
	_createSplitter: function() {
		this.columnSplitter = new ClientUI.common.box.Box(this.extDtId +":cs", this.extDt.grid);
		this.columnSplitter.makeAbsolute();
		this.columnSplitter.setWidth(this.minColumnWidth);
	},	
	
	OnSepMouseUp: function(event) {
		Event.stop(event);
		Event.stopObserving(document, 'mousemove', this.eventSepMouseMove);
		Event.stopObserving(document, 'mouseup', this.eventSepMouseUp);
		if(this.dragColumnInfo && this.dragColumnInfo.dragStarted) {

			this.dragColumnInfo.dragStarted = false;
			this.dragColumnInfo.mouseDown = false;

			var delta = Event.pointerX(event) - 
				this.dragColumnInfo.startX;
			if (delta < this.minDelta) {
				delta = this.minDelta;
			}
			if (delta > this.maxDelta) {
				delta = this.maxDelta;
			}
			var columnIndex = this.dragColumnInfo.srcElement.columnIndex;
			var newWidth = this.getColumnWidth(columnIndex) + delta;
			
			this.extDt.setColumnWidth(columnIndex, newWidth);
			this.setColumnWidth(columnIndex,newWidth);
			this.extDt.updateLayout();
			if (this.extDt.onColumnResize){
				//set properly value to this.columnWidths
				this.extDt.columnWidths = "";
				for (i=0; i<this.columnsNumber; i++){
					this.extDt.columnWidths += "" + this.getColumnWidth(i) + ";";
				}//for
				this.extDt.onColumnResize(event, this.extDt.columnWidths);
			}
		}
		this._hideSplitter();
		
	},
	
	OnSepMouseMove: function(event) {
		if(this.dragColumnInfo && this.dragColumnInfo.mouseDown) {
			if(!this.dragColumnInfo.dragStarted) {
				this.dragColumnInfo.dragStarted = true;
				this._showSplitter(this.dragColumnInfo.srcElement.columnIndex);
			}
			var delta = Event.pointerX(event) - 
				this.dragColumnInfo.startX
			if (delta < this.minDelta) {
				delta = this.minDelta;
			}
			if (delta > this.maxDelta) {
				delta = this.maxDelta;
			}
			var x = this.dragColumnInfo.originalX + delta;
			var finalX = x - this.minColumnWidth - 6 //6 stands for sep span width;
			this.columnSplitter.moveToX(finalX); 				
			Event.stop(event);
		}
	}
			
});/* Class taken from ScrollableDataTable - unmodified */
ExtendedDataTable.Selection = Class.create({
	initialize: function() {
		this.ranges = [];
	},

	addId: function(id) {
		id = parseInt(id);
		if(this.isSelectedId(id))
			return;
		var i = 0;
		while(i < this.ranges.length && id >= this.ranges[i++].indexes[1]);
		i--;
		if(this.ranges[i-1] && id==(this.ranges[i-1].indexes[1]+1) ) {
			if(id==(this.ranges[i].indexes[0]-1)) {
				this.ranges[i-1].indexes[1] = this.ranges[i].indexes[1];
				this.removeRange(i);			
			} else {
				this.ranges[i-1].indexes[1]++;			
			}
		} else {
			if(this.ranges[i]){
				if(this.ranges[i] && id==(this.ranges[i].indexes[0]-1)) {
					this.ranges[i].indexes[0]--;			
				} else {
					if(id==(this.ranges[i].indexes[1]+1)){
						this.ranges[i].indexes[1]++;			
					} else {
						if(id<this.ranges[i].indexes[1]){
							this.addRange(i, new ExtendedDataTable.Range(id, id));					
						} else {
							this.addRange(i + 1, new ExtendedDataTable.Range(id, id));					
						}
					}
				}	
			} else {
				this.addRange(i, new ExtendedDataTable.Range(id, id));					
			}	
		} 			
	},

	addRange: function(index, range) {
		var i = this.ranges.push(range) - 2;
		if(index >= 0) {
			while(i>=index)
				this.ranges[i+1] = this.ranges[i--];
			this.ranges[i+1] = range;
		}
	},

	removeRange: function(index) {
		var i = index + 1;
		while(i!=this.ranges.length)
			this.ranges[i-1] = this.ranges[i++];
		this.ranges.pop();
	},

	isSelectedId: function(id) {
		var i = 0;
		while(i < this.ranges.length && id >= this.ranges[i].indexes[0]) {
			if(id >= this.ranges[i].indexes[0] && id <= this.ranges[i].indexes[1]) {
				return true;
			} else {
				i++;
			}
		}
		return false;
	},

	getSelectedIdsQuantity: function() {
		var number = 0;
		var l = this.ranges.length;
		for (var i = 0; i < l; i++) {
			number+= this.ranges[i].size();
		}
		return number;
	},
	
	size: function () {
		return this.getSelectedIdsQuantity();
	},
	
	removeId: function(id) {
		id = parseInt(id);
		if(!this.isSelectedId(id))
			return;
		var i = 0;
		while(i < this.ranges.length && id > this.ranges[i++].indexes[1]);
		i--;
		if(this.ranges[i]) {
			if(id==(this.ranges[i].indexes[1]) ) {
				if(id==(this.ranges[i].indexes[0])){
					this.removeRange(i);			
				} else {
					this.ranges[i].indexes[1]--;			
				}
			} else {
				if(id==(this.ranges[i].indexes[0])){
					this.ranges[i].indexes[0]++;			
				} else {
				this.addRange(i+1, new ExtendedDataTable.Range(id+1, this.ranges[i].indexes[1]));			
				this.ranges[i].indexes[1] = id-1;
				}
			}
		}		
	},

	getState: function() {
		var s = this.clone();
		return {
			size: function() {
					return s.size();
			},
			
			each: function(iterator) {
				s.each(iterator);
  			},
			
			isSelected: function(id) {
				return s.isSelectedId(id);
  			},
  			
  			equals: function(state) {
  			    var equal = s.size() == state.size();
  			    if(equal) {
  			        s.each(function(id) {
  			            if(equal) {
  			                equal = state.isSelected(id);
  			            }
  			        });
  			    }
  			    return equal;
  			}
		};
	},

	clone: function() {
		var ret =  Object.extend(new Object(),this);
		var l = ret.ranges.length;
		ret.ranges = new Array(l);
		for (var i = 0; i < l; i++) {
			ret.ranges[i] = this.ranges[i].clone();
		}		
 		return ret;
 	},

	each: function(iterator) {
		var l = this.ranges.length;
		for (var i = 0; i < l; i++) {
			this.ranges[i].each(iterator);					
		}
 	},
  	
  	getRanges: function() {
		return this.ranges;
	},

	setRanges: function(ranges) {
		this.ranges = ranges;
	},
	
	initRanges: function(rangeStrRArray) {
		if(rangeStrRArray.length == 0) {
			this.ranges = [];
			return;
		}
		this.ranges = new Array(rangeStrRArray.length);
		var indexStrRArray;
		var l = this.ranges.length;
		for(var i = 0; i < l; i++) {
			indexStrRArray = rangeStrRArray[i].split(",");
			this.ranges[i] = new ExtendedDataTable.Range(parseInt(indexStrRArray[0]), parseInt(indexStrRArray[1]));
		}
		
	}, 

	inspectRanges: function() {
		var ranges = this.getRanges();
		var ret = "";
		ranges.each( function(r) { ret += r.inspect(); } );
		return ret;
	},
	
	/**
	    Compares states and returns true if they are different
	*/
	isChanged: function(state1, state2) {
	    return !state1.equals(state2);
	},
	
	isInRange: function(range, selection) {
	    return selection >= range[0] && selection <= range[1];
	}
});


/* Class taken from ScrollableDataTable - unmodified */
ExtendedDataTable.Range = Class.create({
	initialize: function(startIndex, endIndex) {
		this.indexes = [startIndex, endIndex];
	},

	inspect: function() {
		return this.indexes[0] + "," + this.indexes[1] + ";";
	},
	toString: function() {
		return this.inspect();
	},
	
	size: function() {
		return this.indexes[1] - this.indexes[0] + 1;;
	},
	
	each: function(iterator) {
		var j = this.indexes[0];
		while(j <= this.indexes[1]) {
      		iterator(j++);					
		}
  	},
	
	clone: function() {
		var ret = Object.extend(new Object(),this);
		ret.indexes = this.indexes.clone();
		return ret;
  	}
});

/* Modified class from ScrollableDataTable */
ExtendedDataTable.SelectionManager = Class.create({
	initialize: function(options, owner) {
		this.dataTable = owner;
		this.options = options;
		this.selectionFlag;
		this.firstIndex;
		this.activeRow = -1;
		var element = options.gridId;
		this.gridElement = document.getElementById(element + ":n");
		
		this.prefix = options.gridId;
		this.selection = new ExtendedDataTable.Selection();

		this.inputElement = options.selectionInput;
		this.onselectionchange = options.onselectionchange;
		this.selectedClass = options.selectedClass;
		this.activeClass = options.activeClass;
		

	},
	
	refreshEvents: function() {
		this.setListeners();
		if(this.options.selectionMode != "none") {
			this.eventKeyPress = this.processKeyDown.bindAsEventListener(this);
			Event.observe(document, "keydown", this.eventKeyPress);
		}
		A4J.AJAX.AddListener({
			onafterajax: function(req, event, data) {
				if(!$(this.prefix + ":n")) {
					Event.stopObserving(document, "keydown", this.eventKeyPress);		
				}
			}.bind(this)
		});
		if (document.selection) {
			this.eventResetSelection = this.resetSelection.bindAsEventListener(this);
			Event.observe(this.gridElement, "click", this.eventResetSelection);
		}

		this.eventLostFocus = this.processLostFocus.bindAsEventListener(this);
		Event.observe(document, "click", this.eventLostFocus);

		this.eventPreventLostFocus = this.processPreventLostFocus.bindAsEventListener(this);
		Event.observe(this.gridElement, "click", this.eventPreventLostFocus);
	},

	restoreState: function() {
		this.selectionFlag = null;
		var selStrAr = $(this.inputElement).value.split(";");
		var activeRow = NaN;
		while (selStrAr.length != 0 && selStrAr[selStrAr.length - 1].indexOf(",") == -1 &&
			isNaN(activeRow = Number(selStrAr.pop())));
		if (!isNaN(activeRow)) {
			this.setActiveRow(activeRow);
		}
		this.selection.initRanges(selStrAr);
		var i = 0;
		var j;
		while(i < this.selection.ranges.length) {
			j = this.selection.ranges[i].indexes[0];
			while(j <= this.selection.ranges[i].indexes[1]) {
				var nElement = $(this.prefix + ":n:" + j);
				Element.addClassName(nElement, "extdt-row-selected");
				Element.addClassName(nElement, "rich-sdt-row-selected");
				Element.addClassName(nElement, this.selectedClass);
				j++;
			}
			i++;
		}
		this.oldState = this.selection.getState();
	},
	
	setListeners: function() {
		//May need optimization by attaching listeners to whole rows instead of all cells
		var nrows = $(this.prefix + ":n").rows;
		this.rowCount = nrows.length;
		var rowIndex;
		var groupingExists = $(this.prefix + ":group-row:0") != null;
		if(!groupingExists) { //simple listener binding
			if(this.options.selectionMode != "none") {
				for(var i = 0; i < this.rowCount; i++) {
                    var arr = nrows[i].id.split(":");
                    rowIndex = Number(arr[arr.length-1]);
					this.addListener(nrows[i], rowIndex);
				}
			}
		} else { //extended listener binding with grouping
			var groupRow;
			var lastGroupId = 0;
			var bGroupExpanded = true;
			var bHideFirstRow = false;
			if (ClientUILib.isIE) {
				//hide first fake ie row to ensure proper rendering
				bHideFirstRow = true;
			};
			var groupId;
			var groupItems = [];
			var groupItem = 0;
			var groups = [];
			var groupRows = this.dataTable.groupRows;
			for(var i = 0; i < this.rowCount; i++) {
				tempo = nrows[i].id.split(this.prefix)[1];
				var tempArr = tempo.split(":")
				groupRow = tempArr[1] == "group-row";
				groupId = Number(tempArr[2]);
				if(groupRow) {
					groups[lastGroupId] = groupItems;
					bGroupExpanded = (groupRows[groupId].getAttribute('expanded') == 'true');
					var textSpan = groupRows[lastGroupId].lastChild.lastChild;
					var txtNode = document.createTextNode("(" + groupItems.size() + ")");
					if (textSpan.lastChild) {
						textSpan.replaceChild(txtNode, textSpan.lastChild);
					}else{
						textSpan.appendChild(txtNode);
					}
					groupItem = 0;
					groupItems = [];
					lastGroupId = groupId;
				} else {
					if(this.options.selectionMode != "none") {
                        var arr = nrows[i].id.split(":");
                        rowIndex = Number(arr[arr.length-1]);
                        this.addListener(nrows[i], rowIndex);
					}
					groupItems[groupItem++] = nrows[i];
					if ( (i==0) && (bHideFirstRow) ) {
					   
					}
					if (!bGroupExpanded) {
						nrows[i].style.display = 'none';
						if ((ClientUILib.isIE) && (i!=0)){
							//prevent IE from showing borders of cells
							//which parents have been hidden :|
							var cells = nrows[i].childNodes;
							var l = cells.length;
							for (var j = 0; j < l; j++) {
								cells[j].style.borderStyle = 'none';
							}
						}						
					}
				}
			}
			groups[lastGroupId] = groupItems;
			var textSpan = groupRows[lastGroupId].lastChild.lastChild;
			var txtNode = document.createTextNode("(" + groupItems.size() + ")");
			if (textSpan.lastChild) {
				textSpan.replaceChild(txtNode, textSpan.lastChild);
			}else{
				textSpan.appendChild(txtNode);
			}			
			this.dataTable.groups = groups;
		}
	},
	/*
		Modification: instead of providing listener for each cell,
		one is provided for a whole row
	*/
	addListener: function(tr, rowIndex) {
		if (tr) {
			var listener = this.processClick.bindAsEventListener(this, rowIndex);
			Utils.DOM.Event.removeListeners(tr);
			Utils.DOM.Event.observe(tr, "click", listener);	
		}
	},
	
	removeListeners: function(){
		Event.stopObserving(document, "keydown", this.eventKeyPress);
		if (document.selection) {
			Event.stopObserving(this.gridElement, "click", this.eventResetSelection);
		}
		Event.stopObserving(document, "click", this.eventLostFocus);
		Event.stopObserving(this.gridElement, "click", this.eventPreventLostFocus);
		if(this.options.selectionMode != "none") {
			var nrows = $(this.prefix + ":n").rows;
			var rowCount = nrows.length;
			for(var i = 0; i < this.rowCount; i++) {
				Utils.DOM.Event.removeListeners(nrows[i]);	
			}
		}
	},
	
/*	getGridSelection: function() {
		return this.selection.getRanges();
	},*/

	processPreventLostFocus: function() {
		this.inFocus = true;
		this.preventLostFocus = true;
	},

	processLostFocus: function() {
		if (!this.preventLostFocus) {
			this.lostFocus();
		} else {
			this.preventLostFocus = false;
		}
	},

	lostFocus: function() {
		this.inFocus = false;
	},

	processKeyDown: function(event) {
		if ($(this.prefix + ":n").rows.length > 0) {
			if(!event.shiftKey) {
				this.shiftRow = null;
			}		
			var range, rowIndex;
			var activeRow = this.activeRow;
			var noDefault = false;
			var arr = $(this.prefix + ":n").rows[0].id.split(":");
			this.firstIndex = Number(arr[arr.length-1]);
			switch (event.keyCode || event.charCode) {
				case Event.KEY_UP:
					if (this.inFocus && activeRow != null) {
						if(this.firstIndex != activeRow) {
							rowIndex = (this.rowCount + activeRow - 1) % this.rowCount;		
							if (!event.ctrlKey && !event.shiftKey) {
								this.selectionFlag = "x";
								range = [rowIndex, rowIndex];
								this.setSelection(range);		
							} else if (!event.ctrlKey && event.shiftKey
							             && this.options.selectionMode == "multi") {
								if(!this.shiftRow) {
									this.shiftRow = this.activeRow;
								}
								if(this.shiftRow >= this.activeRow) {
									this.addRowToSelection(rowIndex);						
								} else {
									this.removeRowFromSelection(activeRow);						
								}
							}
							noDefault = true;
							this.setActiveRow(rowIndex);
						} else {
							//this.grid.getBody().showRow("up");					
						}
					}
					break;
				case Event.KEY_DOWN:
					if (this.inFocus && activeRow != null) {
						rowIndex = (activeRow + 1) % this.rowCount;		
						if(this.firstIndex != rowIndex) {
							if (!event.ctrlKey && !event.shiftKey) {
								this.selectionFlag = "x";
								range = [rowIndex, rowIndex];
								this.setSelection(range);		
							} else if (!event.ctrlKey && event.shiftKey
							             && this.options.selectionMode == "multi") {
								if(!this.shiftRow) {
									this.shiftRow = this.activeRow;
								}
								if(this.shiftRow <= this.activeRow) {
									this.addRowToSelection(rowIndex);						
								} else {
									this.removeRowFromSelection(activeRow);						
								}
							}
							noDefault = true;
							this.setActiveRow(rowIndex);
						} else {
							//this.grid.getBody().showRow("down");					
						}
					}
					break;
				case 65: case 97:								// Ctrl-A
					if (this.inFocus && event.ctrlKey && !event.altKey 
							&& this.options.selectionMode == "multi") {
						this.selectionFlag = "a";
						for (var i = 0; i <  this.rowCount; i++) {
							this.addRowToSelection(i);
						}
						noDefault = true;
					}
					break;
				case Event.KEY_TAB:
					this.lostFocus();
			}
			if (noDefault) {
				this.dataTable.showRow(this.activeRow);
				this.selectionChanged(event);			
				if (event.preventBubble) event.preventBubble();
				Event.stop(event);
			}
		}
	},
	
	/*
		Modified method:
		Component supports three selection modes:
		none - no selection allowed
		single - only one row can be selected at a time (no ctrl or shift)
		multi - normal full-featured selection mode
	*/
	processClick: function(event, rowIndex) {
		if (this.options.selectionMode == "none") {
			return;
		}

		var bSingleSelection = this.options.selectionMode == "single";

		if(!event.shiftKey) {
			this.shiftRow = null;
		}		
		var range;	
		
		if ( event.shiftKey && !event.ctrlKey && !bSingleSelection && !event.altKey) {
            var arr = $(this.prefix + ":n").rows[0].id.split(":");
            this.firstIndex = Number(arr[arr.length-1]);
			this.selectionFlag = "x";
			if(!this.shiftRow) {
				this.shiftRow = this.activeRow;
			}
			this.startRow = this.shiftRow;
			if (((this.startRow <= rowIndex) && (this.firstIndex <= this.startRow || rowIndex < this.firstIndex))
				|| (this.startRow > rowIndex && this.firstIndex < this.startRow && rowIndex <= this.firstIndex)) {
				this.endRow = rowIndex;
			} else {
				this.endRow = this.startRow;
				this.startRow = rowIndex;
			}
			if(this.startRow > this.endRow) { //bugfix
				//without this selection of first row with shift was broken
				var t = this.startRow;
				this.startRow = this.endRow;
				this.endRow = t;
			}
			range = [this.startRow, this.endRow];
			this.setSelection(range);		
		} else if (!event.shiftKey &&  event.ctrlKey && !event.altKey) {
			if (this.selection.isSelectedId(rowIndex)) {
				this.removeRowFromSelection(rowIndex);
			} else {
				if (!bSingleSelection || this.selection.size() == 0) {
					this.addRowToSelection(rowIndex);
				}
			}
		} else  if (!event.shiftKey && !event.ctrlKey && !event.altKey) {
			this.selectionFlag = "x";
			range = [rowIndex, rowIndex];
			this.setSelection(range);		
		}
		this.setActiveRow(rowIndex);
		if (event.shiftKey) {
			if (window.getSelection) {
				window.getSelection().removeAllRanges();
			} else if (document.selection) {
				document.selection.empty();
			}
		}
		this.selectionChanged(event);
	},
	
	/**
	   Changes the saved state of the selection and fires
	   the onselectionchange event if selection is changed.
	   The function that is passed as onselectionchange event
	   accepts an event parameter that contains both old and new selections
	*/
	selectionChanged: function(event) {
		$(this.inputElement).value = this.selection.inspectRanges()
		                                 + this.activeRow + ";"
		                                 + (this.selectionFlag ? this.selectionFlag : "");
		var state = this.selection.getState();			
		event.oldSelection = this.oldState;
		event.newSelection = state; //save the new state for processing
		if(this.onselectionchange //event is defined
		        && this.selection.isChanged(this.oldState, state)) { //selection actualy changed
		    this.onselectionchange(event);
		}
		this.oldState = state; //remember current state
	},

	setShiftRow: function(event) {
		if(event.shiftKey) {
			if(!this.shiftRow) {
				this.shiftRow = this.activeRow;
			}
		} else {
			this.shiftRow = null;		
		}	
	},
	
	setSelection: function(range) {
		//TODO test for extreemes - first rows, last rows, all rows
		var l = this.selection.ranges.length;
		for(var i = l - 1;i >= 0; i--) {
			var selection = this.selection.ranges[i].indexes;
			if(selection == range) {
				continue;
			}
			var j = selection[0];
			for(j;j <= selection[1];j++) {
				this.removeRowFromSelection(j);
			}
		}
		if(range[0] == range[1]) {
		  this.addRowToSelection(range[0]);
		  return;
		}
		var i = range[0];
		range[1] = (range[1] + 1) % this.rowCount;
		while (i != range[1]) {
			this.addRowToSelection(i);
			i = (i + 1) % this.rowCount;	
		}
	},
	
	resetSelection: function(e) {
		if(e.shiftKey) {
			document.selection.empty();
		}
	},
	
	addRowToSelection: function(rowIndex) {
		this.selection.addId(rowIndex);
		var nElement = $(this.prefix + ":n:" + rowIndex);
		Element.addClassName(nElement, "extdt-row-selected");
		Element.addClassName(nElement, "rich-sdt-row-selected");
		Element.addClassName(nElement, this.selectedClass);
	},

	removeRowFromSelection: function(rowIndex) {
		this.selection.removeId(rowIndex);
		var nElement = $(this.prefix + ":n:" + rowIndex);
		Element.removeClassName(nElement, "extdt-row-selected");
		Element.removeClassName(nElement, "rich-sdt-row-selected");
		Element.removeClassName(nElement, this.selectedClass);
	},

	setActiveRow: function(rowIndex) {
		var fElement, nElement;
		if(this.activeRow != null) {
			nElement = $(this.prefix + ":n:" + this.activeRow);
			Element.removeClassName(nElement, "extdt-row-active");
			Element.removeClassName(nElement, "rich-sdt-row-active");
			Element.removeClassName(nElement, this.activeClass);
		}
		nElement = $(this.prefix + ":n:" + rowIndex);
		Element.addClassName(nElement, "extdt-row-active");
		Element.addClassName(nElement, "rich-sdt-row-active");
		Element.addClassName(nElement, this.activeClass);
		this.activeRow = rowIndex;
	}
});
