/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
//
//
//


import org.richfaces.renderkit.FileUploadRendererBase;



/**
 * Renderer for component class org.richfaces.renderkit.html.FileUploadRenderer
 */
public class FileUploadRenderer extends FileUploadRendererBase {

	public FileUploadRenderer () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] styles = {
						getResource("/org/richfaces/renderkit/html/css/fileUpload.xcss")
						,
				getResource("/org/richfaces/renderkit/html/css/progressBar.xcss")
	};

private InternetResource[] stylesAll = null;

protected InternetResource[] getStyles() {
	synchronized (this) {
		if (stylesAll == null) {
			InternetResource[] rsrcs = super.getStyles();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = styles == null || styles.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					stylesAll = new InternetResource[0];	
				} else {
					stylesAll = styles;
				}
			} else {
				if (ignoreThis) {
					stylesAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < styles.length; i++ ) {
						rsrcsSet.add(styles[i]);
					}

					stylesAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return stylesAll;
}
	private final InternetResource[] scripts = {
						new org.ajax4jsf.javascript.PrototypeScript()
						,
				new org.ajax4jsf.javascript.AjaxScript()
						,
				getResource("/org/richfaces/renderkit/html/scripts/utils.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/json/json-dom.js")
						,
				getResource("/org/richfaces/renderkit/html/js/FileUpload.js")
						,
				getResource("/org/richfaces/renderkit/html/js/swfobject.js")
						,
				getResource("/org/richfaces/renderkit/html/js/progressBar.js")
						,
				getResource("/org/ajax4jsf/javascript/scripts/form.js")
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	// 
	// 
	//

	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIFileUpload.class;
	}


	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIFileUpload component, ComponentVariables variables) throws IOException {
	  java.lang.String clientId = component.getClientId(context);
variables.setVariable("flashComponent", getResource( "/org/richfaces/renderkit/html/swf/FileUploadComponent.swf" ).getUri(context, component) );


		
 		Integer max = initMaxFilesCount(context, component, clientId);
		variables.setVariable("maxCount", max);

		boolean disabled = (Boolean)component.getAttributes().get("disabled");
		String addButtonClass = (disabled) ? "rich-fileupload-button-dis rich-fileupload-font " + (String)component.getAttributes().get("addButtonClassDisabled") 
									: "rich-fileupload-button rich-fileupload-font " + (String)component.getAttributes().get("addButtonClass");
		String addButtonClassContent = (disabled) ? "rich-fileupload-button-content rich-fileupload-font rich-fileupload-ico rich-fileupload-ico-add-dis " + (String)component.getAttributes().get("addButtonClassDisabled") 
				: "rich-fileupload-button-content rich-fileupload-font rich-fileupload-ico rich-fileupload-ico-add " + (String)component.getAttributes().get("addButtonClass");
		
		String uploadListClass = (disabled) ? (String)component.getAttributes().get("uploadListClassDisabled") : (String)component.getAttributes().get("uploadListClass");
		variables.setVariable("addButtonClass",addButtonClass);
		variables.setVariable("addButtonClassContent",addButtonClassContent);
		variables.setVariable("uploadListClass",uploadListClass);
		
		Map<String, String> labels = getLabels(context, component);
		variables.setVariable("labels",labels);
		variables.setVariable("addLabel",labels.get("add"));
		variables.setVariable("uploadLabel",labels.get("upload"));
		variables.setVariable("clearAllLabel",labels.get("clear_all"));

		org.ajax4jsf.context.AjaxContext ajaxContext = org.ajax4jsf.context.AjaxContext.getCurrentInstance(context);
		String ajaxActionUrl = ajaxContext.getAjaxActionURL(context);
		
		variables.setVariable("actionUrl", ajaxActionUrl);

		variables.setVariable("listWidth", getFileListWidth(component));
		variables.setVariable("listHeight", getFileListHeight(component));
	
		  

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-list-decor " + convertToString(component.getAttributes().get("styleClass")) );
						getUtils().writeAttribute(writer, "id", clientId );
						getUtils().writeAttribute(writer, "onclick", component.getAttributes().get("onclick") );
						getUtils().writeAttribute(writer, "ondblclick", component.getAttributes().get("ondblclick") );
						getUtils().writeAttribute(writer, "onmousedown", component.getAttributes().get("onmousedown") );
						getUtils().writeAttribute(writer, "onmousemove", component.getAttributes().get("onmousemove") );
						getUtils().writeAttribute(writer, "onmouseout", component.getAttributes().get("onmouseout") );
						getUtils().writeAttribute(writer, "onmouseover", component.getAttributes().get("onmouseover") );
						getUtils().writeAttribute(writer, "onmouseup", component.getAttributes().get("onmouseup") );
						getUtils().writeAttribute(writer, "style", "width: " + convertToString(variables.getVariable("listWidth")) );
			
getUtils().encodeBeginFormIfNessesary(context, component);

writer.startElement("span", component);
			getUtils().writeAttribute(writer, "style", "display: none;" );
			

		
	renderProgress(context, component);
		  
	
writer.endElement("span");
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-toolbar-decor" );
			
writer.startElement("tr", component);

writer.startElement("td", component);

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-button-border" );
						getUtils().writeAttribute(writer, "style", " float:left;" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", variables.getVariable("addButtonClass") );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":add1" );
						getUtils().writeAttribute(writer, "onmousedown", "this.className='rich-fileupload-button-press rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "onmouseout", "this.className='rich-fileupload-button rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "onmouseover", "this.className='rich-fileupload-button-light rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "onmouseup", "this.className='rich-fileupload-button rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "style", "position: relative;" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", variables.getVariable("addButtonClassContent") );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":add2" );
						getUtils().writeAttribute(writer, "style", "position: relative;" );
			
writer.writeText(convertToString(variables.getVariable("addLabel")),null);

writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "style", "overflow : hidden; position : absolute; top : 0px; left : 0px; padding: 0px;" );
			
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "autocomplete", "off" );
						getUtils().writeAttribute(writer, "class", "rich-fileupload-hidden" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":file" );
						getUtils().writeAttribute(writer, "name", convertToString(clientId) + ":file" );
						getUtils().writeAttribute(writer, "onchange", "return $('" + convertToString(clientId) + "').component.add(this);" );
						getUtils().writeAttribute(writer, "style", "cursor: pointer; right: 0px; top: 0px; font-size: 10em; position: absolute; padding: 0px" );
						getUtils().writeAttribute(writer, "type", "file" );
			
writer.endElement("input");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":flashContainer" );
						getUtils().writeAttribute(writer, "style", "display:none" );
			
writer.endElement("div");
writer.endElement("div");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-button-border" );
						getUtils().writeAttribute(writer, "style", " float:left; display: none;" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-file-upload-button rich-fileupload-font " + convertToString(component.getAttributes().get("uploadButtonClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":upload1" );
						getUtils().writeAttribute(writer, "onclick", "return $('" + convertToString(clientId) + "').component.upload();" );
						getUtils().writeAttribute(writer, "onmousedown", "this.className='rich-fileupload-button-press rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "onmouseout", "this.className='rich-fileupload-button rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "onmouseover", "this.className='rich-fileupload-button-light rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "onmouseup", "this.className='rich-fileupload-button rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "style", "position: relative;" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-button-content rich-fileupload-font rich-fileupload-ico rich-fileupload-ico-start " + convertToString(component.getAttributes().get("uploadButtonClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":upload2" );
			
writer.writeText(convertToString(variables.getVariable("uploadLabel")),null);

writer.endElement("div");
writer.endElement("div");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-button-border" );
						getUtils().writeAttribute(writer, "style", " float:right; display: none;" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-button rich-fileupload-font " + convertToString(component.getAttributes().get("cleanButtonClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":clean1" );
						getUtils().writeAttribute(writer, "onclick", "return $('" + convertToString(clientId) + "').component.clear();" );
						getUtils().writeAttribute(writer, "onmousedown", "this.className='rich-fileupload-button-press rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "onmouseout", "this.className='rich-fileupload-button rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "onmouseover", "this.className='rich-fileupload-button-light rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "onmouseup", "this.className='rich-fileupload-button rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "style", "position: relative;" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-button-content rich-fileupload-font rich-fileupload-ico rich-fileupload-ico-clear-dis " + convertToString(component.getAttributes().get("cleanButtonClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":clean2" );
			
writer.writeText(convertToString(variables.getVariable("clearAllLabel")),null);

writer.endElement("div");
writer.endElement("div");
writer.endElement("div");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("table");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-list-overflow " + convertToString(variables.getVariable("uploadListClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":fileItems" );
						getUtils().writeAttribute(writer, "style", "width: 100%; height: " + convertToString(variables.getVariable("listHeight")) );
			
writer.endElement("div");

	
		String useFlashComponent = ((String) component.getAttributes().get("allowFlash")).trim().toLowerCase();
		variables.setVariable("allowFlash", useFlashComponent);
	
	
writer.startElement("span", component);

java.util.HashMap ADD = new java.util.HashMap();
	getUtils().addToScriptHash(ADD, "ENABLED", component.getAttributes().get("addButtonClass"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(ADD, "DISABLED", component.getAttributes().get("addButtonClassDisabled"),  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap UPDATE = new java.util.HashMap();
	getUtils().addToScriptHash(UPDATE, "ENABLED", component.getAttributes().get("uploadButtonClass"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(UPDATE, "DISABLED", component.getAttributes().get("uploadButtonClassDisabled"),  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap STOP = new java.util.HashMap();
	getUtils().addToScriptHash(STOP, "ENABLED", component.getAttributes().get("stopButtonClass"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(STOP, "DISABLED", component.getAttributes().get("stopButtonClassDisabled"),  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap CLEAN = new java.util.HashMap();
	getUtils().addToScriptHash(CLEAN, "ENABLED", component.getAttributes().get("cleanButtonClass"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(CLEAN, "DISABLED", component.getAttributes().get("cleanButtonClassDisabled"),  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap FILE_ENTRY = new java.util.HashMap();
	getUtils().addToScriptHash(FILE_ENTRY, "ENABLED", component.getAttributes().get("fileEntryClass"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(FILE_ENTRY, "DISABLED", component.getAttributes().get("fileEntryClassDisabled"),  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap FILE_ENTRY_CONTROL = new java.util.HashMap();
	getUtils().addToScriptHash(FILE_ENTRY_CONTROL, "ENABLED", component.getAttributes().get("fileEntryControlClass"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(FILE_ENTRY_CONTROL, "DISABLED", component.getAttributes().get("fileEntryControlClassDisabled"),  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap UPLOAD_LIST = new java.util.HashMap();
	getUtils().addToScriptHash(UPLOAD_LIST, "ENABLED", component.getAttributes().get("uploadListClass"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(UPLOAD_LIST, "DISABLED", component.getAttributes().get("uploadListClassDisabled"),  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap classes = new java.util.HashMap();
	getUtils().addToScriptHash(classes, "ADD", ADD,  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(classes, "UPDATE", UPDATE,  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(classes, "STOP", STOP,  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(classes, "CLEAN", CLEAN,  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(classes, "FILE_ENTRY", FILE_ENTRY,  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(classes, "FILE_ENTRY_CONTROL", FILE_ENTRY_CONTROL,  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(classes, "UPLOAD_LIST", UPLOAD_LIST,  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap events = new java.util.HashMap();
	getUtils().addToScriptHash(events, "onupload", component.getAttributes().get("onupload"),  null , ScriptHashVariableWrapper.EVENT_HANDLER);
	getUtils().addToScriptHash(events, "onuploadcomplete", component.getAttributes().get("onuploadcomplete"),  null , ScriptHashVariableWrapper.EVENT_HANDLER);
	getUtils().addToScriptHash(events, "onuploadcanceled", component.getAttributes().get("onuploadcanceled"),  null , ScriptHashVariableWrapper.EVENT_HANDLER);
	getUtils().addToScriptHash(events, "onerror", component.getAttributes().get("onerror"),  null , ScriptHashVariableWrapper.EVENT_HANDLER);
	getUtils().addToScriptHash(events, "ontyperejected", component.getAttributes().get("ontyperejected"),  null , ScriptHashVariableWrapper.EVENT_HANDLER);
	getUtils().addToScriptHash(events, "onsizerejected", component.getAttributes().get("onsizerejected"),  null , ScriptHashVariableWrapper.EVENT_HANDLER);
	getUtils().addToScriptHash(events, "onclear", component.getAttributes().get("onclear"),  null , ScriptHashVariableWrapper.EVENT_HANDLER);
	getUtils().addToScriptHash(events, "onadd", component.getAttributes().get("onadd"),  null , ScriptHashVariableWrapper.EVENT_HANDLER);
	getUtils().addToScriptHash(events, "onfileuploadcomplete", component.getAttributes().get("onfileuploadcomplete"),  null , ScriptHashVariableWrapper.EVENT_HANDLER);

java.util.HashMap internalOptions = new java.util.HashMap();
	getUtils().addToScriptHash(internalOptions, "autoclear", component.getAttributes().get("autoclear"),  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(internalOptions, "noDuplicate", component.getAttributes().get("noDuplicate"),  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(internalOptions, "immediateUpload", component.getAttributes().get("immediateUpload"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(internalOptions, "allowFlash", variables.getVariable("allowFlash"),  "false" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(internalOptions, "flashComponentUrl", variables.getVariable("flashComponent"),  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap fields = new java.util.HashMap();
	getUtils().addToScriptHash(fields, "labelMarkup", getLabelMarkup(context,component),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(fields, "maxFileBatchSize", variables.getVariable("maxCount"),  "1" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(fields, "disabled", component.getAttributes().get("disabled"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(fields, "maxFileBatchSize", variables.getVariable("maxCount"),  "1" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(fields, "acceptedTypes", getAcceptedTypes(context,component),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(fields, "events", events,  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(fields, "options", internalOptions,  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(fields, "parameters", getChildrenParams(context,component),  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap options = new java.util.HashMap();
	getUtils().addToScriptHash(options, "classes", classes,  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(options, "fields", fields,  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "labels", variables.getVariable("labels"),  null , ScriptHashVariableWrapper.DEFAULT);

writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString("new FileUpload('" + convertToString(clientId) + "','" + convertToString(variables.getVariable("actionUrl")) + "', " + convertToString(getActionScript(context,component)) + ", '" + convertToString(getProgressBarId(context,component)) + "',\n					'" + convertToString(getSessionId(context,component)) + "'"),null);

if ( Boolean.valueOf( String.valueOf( ( !  getUtils().isEmpty( options )  ) ) ).booleanValue() ) {


writer.writeText(convertToString(","),null);

org.ajax4jsf.javascript.ScriptUtils.writeToStream(writer, options);

}
writer.writeText(convertToString(");"),null);

writer.endElement("script");
writer.endElement("span");
getUtils().encodeEndFormIfNessesary(context, component);

writer.endElement("div");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIFileUpload)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
