/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.resource.InternetResource;
//
//
//


import org.richfaces.renderkit.JQueryRendererBase;



/**
 * Renderer for component class org.richfaces.renderkit.html.JQueryRenderer
 */
public class JQueryRenderer extends JQueryRendererBase {

	public JQueryRenderer () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] scripts = {
						getResource("/org/richfaces/renderkit/html/scripts/jquery/jquery.js")
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	// 
	// 
	//

	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIJQuery.class;
	}


	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIJQuery component, ComponentVariables variables) throws IOException {
	  java.lang.String clientId = component.getClientId(context);
variables.setVariable("selector", component.getAttributes().get("selector") );
variables.setVariable("name", component.getAttributes().get("name") );
variables.setVariable("timing", component.getAttributes().get("timing") );
variables.setVariable("query", component.getAttributes().get("query") );

 
			String name = (String) variables.getVariable("name");
			String timing = (String) variables.getVariable("timing");
			String query = (String) variables.getVariable("query");
			String selector = (String) variables.getVariable("selector");
			         
			checkValidity(clientId, name, timing, query); 
			variables.setVariable("selector", getUtils().escapeJavaScript(
					replaceClientIds(context, component, selector)));


 if (! "".equals(name.trim()) ) { 
writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString("//"),null);

     writer.write("<![CDATA[");
     writer.write(convertToString("\nfunction " + convertToString(variables.getVariable("name")) + "(elm, param) {\n	var selector = \"" + convertToString(variables.getVariable("selector")) + "\";\n	try {\n		selector = eval(\"" + convertToString(variables.getVariable("selector")) + "\");\n	} catch (e) {}\n	\n	jQuery(elm || selector)." + convertToString(variables.getVariable("query")) + ";\n}\n//"));
     writer.write("]]>");

writer.endElement("script");
 } 
 if ( "immediate".equals(timing) ) { 
writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString("//"),null);

     writer.write("<![CDATA[");
     writer.write(convertToString("\n {\n	var selector = \"" + convertToString(variables.getVariable("selector")) + "\";\n	try {\n		selector = eval(\"" + convertToString(variables.getVariable("selector")) + "\");\n	} catch (e) {}\n	jQuery(selector)." + convertToString(variables.getVariable("query")) + ";\n}\n//"));
     writer.write("]]>");

writer.endElement("script");
 } 
 if ( "onload".equals(timing) ) { 
writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString("//"),null);

     writer.write("<![CDATA[");
     writer.write(convertToString("\n  jQuery(document).ready(function() {\n	var selector = \"" + convertToString(variables.getVariable("selector")) + "\";\n	try {\n		selector = eval(\"" + convertToString(variables.getVariable("selector")) + "\");\n	} catch (e) {}\n	jQuery(selector)." + convertToString(variables.getVariable("query")) + ";\n });\n//"));
     writer.write("]]>");

writer.endElement("script");
 } 

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIJQuery)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
