/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.taglib;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.tag.MetaRule;
import com.sun.facelets.tag.MetaRuleset;
import com.sun.facelets.tag.MetaTagHandler;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.MetadataTarget;
import com.sun.facelets.tag.Tag;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributes;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.jsf.ComponentConfig;
import com.sun.facelets.tag.jsf.ComponentHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.el.ELBuilder;
import org.richfaces.iterator.ForEachIterator;
import org.richfaces.iterator.SimpleForEachIterator;
import org.richfaces.taglib.ColumnTagHandler;
import org.richfaces.taglib.ColumnsAttributes;
import org.richfaces.taglib.IndexedValueExpression;
import org.richfaces.taglib.IteratedExpression;
import org.richfaces.taglib.IteratedIndexExpression;
import org.richfaces.taglib.IteratedValueExpression;
import org.richfaces.taglib.RequestUniqueIdGenerator;

public class ColumnsHandler
extends MetaTagHandler {
    private static final Log log = LogFactory.getLog(ColumnsHandler.class);
    ComponentHandler handler;
    private static final String ITERATION_INDEX_VARIABLE = "__richfaces_iteration_index_variable";
    private static final String ITERATION_INDEX_EXPRESSION = "#{__richfaces_iteration_index_variable}";
    private static final String F_GENERATION_SERIES_ATTRIBUTE = "org.richfaces.F_COLUMNS_GENERATION_SERIES";
    private TagAttribute value;
    private TagAttribute columns;
    private TagAttribute begin;
    private TagAttribute var;
    private TagAttribute index;
    private TagAttribute end;
    ThreadLocal<IterationContext> iterationContextLocal = new ThreadLocal();

    public IterationContext getIterationContext() {
        return this.iterationContextLocal.get();
    }

    public ColumnsHandler(final ComponentConfig config) {
        super((TagConfig)config);
        TagAttribute idAttribute = config.getTag().getAttributes().get("id");
        ComponentConfig columnConfig = idAttribute != null && idAttribute.isLiteral() ? new ComponentConfig(){
            private Tag tag;
            {
                Tag initialTag = config.getTag();
                TagAttribute[] allInitialAttributes = initialTag.getAttributes().getAll();
                TagAttribute[] attributes = new TagAttribute[allInitialAttributes.length];
                for (int i = 0; i < allInitialAttributes.length; ++i) {
                    TagAttribute initialAttribute = allInitialAttributes[i];
                    String localName = initialAttribute.getLocalName();
                    String attributeValue = initialAttribute.getValue();
                    if ("id".equals(localName)) {
                        attributeValue = attributeValue + ColumnsHandler.ITERATION_INDEX_EXPRESSION;
                    }
                    attributes[i] = new TagAttribute(initialAttribute.getLocation(), initialAttribute.getNamespace(), localName, initialAttribute.getQName(), attributeValue);
                }
                TagAttributes tagAttributes = new TagAttributes(attributes);
                this.tag = new Tag(initialTag, tagAttributes);
            }

            public String getComponentType() {
                return config.getComponentType();
            }

            public String getRendererType() {
                return config.getRendererType();
            }

            public FaceletHandler getNextHandler() {
                return config.getNextHandler();
            }

            public Tag getTag() {
                return this.tag;
            }

            public String getTagId() {
                return config.getTagId();
            }
        } : config;
        this.handler = new ColumnTagHandler(columnConfig){

            protected MetaRuleset createMetaRuleset(Class type) {
                MetaRuleset ruleset = super.createMetaRuleset(type);
                ruleset.addRule(new MetaRule(){

                    public Metadata applyRule(final String name, final TagAttribute attribute, MetadataTarget meta) {
                        if (ColumnsAttributes.FILTER_ATTRIBUTES.indexOf(name) != -1 || ColumnsAttributes.SORT_ATTRIBUTES.indexOf(name) != -1) {
                            return new Metadata(){

                                public void applyMetadata(FaceletContext ctx, Object instance) {
                                    if (!attribute.isLiteral()) {
                                        String expr = attribute.getValue();
                                        IterationContext itContext = ColumnsHandler.this.iterationContextLocal.get();
                                        ValueExpression ve = ELBuilder.createValueExpression(expr, Object.class, ctx.getExpressionFactory(), (ELContext)ctx, itContext._itemId, itContext._indexId, itContext.getVarReplacement(), itContext.getIndexReplacement());
                                        ((UIComponent)instance).setValueExpression(name, ve);
                                    } else {
                                        ((UIComponent)instance).getAttributes().put(name, attribute.getValue());
                                    }
                                }
                            };
                        }
                        return null;
                    }
                });
                return ruleset;
            }

            protected void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
                c.getAttributes().put(ColumnsHandler.F_GENERATION_SERIES_ATTRIBUTE, RequestUniqueIdGenerator.generateId(ctx.getFacesContext()));
                super.applyNextHandler(ctx, c);
            }
        };
    }

    private void initVariables(FaceletContext ctx) {
        this.initColumnsCount(ctx);
        this.initIndex(ctx);
        this.initVar(ctx);
        this.initBegin(ctx);
        this.initEnd(ctx);
    }

    private void prepare(FaceletContext ctx) {
        this.initVariables(ctx);
        IterationContext itContext = this.getIterationContext();
        try {
            this.value = this.getAttribute("value");
            if (this.value != null) {
                itContext.valueExpr = ELBuilder.getVarReplacement(this.value.getValue());
                itContext.rawItems = this.value.getObject(ctx);
                itContext.items = SimpleForEachIterator.supportedTypeForEachIterator(itContext.rawItems);
            } else {
                itContext.items = SimpleForEachIterator.beginEndForEachIterator(itContext._columns - 1);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        this.correctFirst(ctx);
    }

    private void correctFirst(FaceletContext ctx) {
        IterationContext itContext = this.getIterationContext();
        if (itContext.items != null && itContext._begin > 0 && itContext._index < itContext._begin) {
            while (itContext._index < itContext._begin && this.hasNext()) {
                this.next(ctx);
            }
            if (!this.hasNext()) {
                itContext._index = 0;
            }
        }
    }

    private boolean hasNext() {
        IterationContext itContext = this.getIterationContext();
        try {
            if (itContext._end != 0) {
                return itContext._index < itContext._end ? itContext.items.hasNext() : false;
            }
            return itContext.items.hasNext();
        }
        catch (Exception e) {
            return false;
        }
    }

    private Object next(FaceletContext ctx) {
        IterationContext itContext = this.getIterationContext();
        try {
            Object o = itContext.items.next();
            IterationContext iterationContext = itContext;
            Integer n = iterationContext._index;
            Integer n2 = iterationContext._index = Integer.valueOf(iterationContext._index + 1);
            return o;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void initColumnsCount(FaceletContext ctx) {
        IterationContext itContext = this.getIterationContext();
        this.columns = this.getAttribute("columns");
        if (this.columns != null) {
            try {
                itContext._columns = Integer.parseInt((String)this.columns.getObject(ctx));
                if (itContext._columns < 0) {
                    itContext._columns = 0;
                }
            }
            catch (Exception e) {
                itContext._columns = 0;
            }
        } else {
            itContext._columns = 0;
        }
    }

    private void initBegin(FaceletContext ctx) {
        IterationContext itContext = this.getIterationContext();
        this.begin = this.getAttribute("begin");
        if (this.begin != null) {
            try {
                Object o = this.begin.getObject(ctx);
                if (o instanceof Number) {
                    itContext._begin = ((Number)o).intValue();
                } else if (o instanceof String) {
                    itContext._begin = Integer.parseInt((String)o);
                }
                IterationContext iterationContext = itContext;
                Integer n = iterationContext._begin;
                Integer n2 = iterationContext._begin = Integer.valueOf(iterationContext._begin - 1);
                if (itContext._begin < 0) {
                    itContext._begin = 0;
                }
            }
            catch (Exception e) {
                itContext._begin = 0;
            }
        } else {
            itContext._begin = 0;
        }
    }

    private void initEnd(FaceletContext ctx) {
        IterationContext itContext = this.getIterationContext();
        this.end = this.getAttribute("end");
        if (this.end != null) {
            try {
                Object o = this.end.getObject(ctx);
                if (o instanceof Number) {
                    itContext._end = ((Number)o).intValue();
                } else if (o instanceof String) {
                    itContext._end = Integer.parseInt((String)o);
                }
                if (itContext._end < 0) {
                    itContext._end = 0;
                }
            }
            catch (Exception e) {
                itContext._end = 0;
            }
        } else {
            itContext._end = 0;
        }
    }

    private void initVar(FaceletContext ctx) {
        IterationContext itContext = this.getIterationContext();
        this.var = this.getAttribute("var");
        if (this.var != null) {
            try {
                itContext._itemId = (String)this.var.getObject(ctx);
            }
            catch (ClassCastException e) {
                itContext._itemId = null;
            }
        }
    }

    private void initIndex(FaceletContext ctx) {
        IterationContext itContext = this.getIterationContext();
        this.index = this.getAttribute("index");
        if (this.index != null) {
            try {
                itContext._indexId = (String)this.index.getObject(ctx);
            }
            catch (ClassCastException e) {
                itContext._indexId = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        IterationContext iterationContext = new IterationContext();
        this.iterationContextLocal.set(iterationContext);
        this.clearOldColumns(ctx.getFacesContext(), parent);
        this.prepare(ctx);
        try {
            while (this.hasNext()) {
                this.exposeVariables(ctx);
                this.handler.apply(ctx, parent);
                this.next(ctx);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            this.release();
            this.unExposeVariables(ctx);
        }
    }

    private void clearOldColumns(FacesContext context, UIComponent parent) {
        if (parent.getChildCount() > 0) {
            Integer generatedId = RequestUniqueIdGenerator.generateId(context);
            Iterator childrenIt = parent.getChildren().iterator();
            while (childrenIt.hasNext()) {
                UIComponent c = (UIComponent)childrenIt.next();
                Object generationSeries = c.getAttributes().get(F_GENERATION_SERIES_ATTRIBUTE);
                if (generationSeries == null || generationSeries.equals(generatedId)) continue;
                childrenIt.remove();
            }
        }
    }

    private void exposeVariables(FaceletContext ctx) {
        int componentsCount;
        ValueExpression ve;
        IterationContext itContext = this.getIterationContext();
        VariableMapper vm = ctx.getVariableMapper();
        int k = itContext._index;
        if (itContext._itemId != null && vm != null && this.value != null) {
            ValueExpression srcVE = this.value.getValueExpression(ctx, Object.class);
            ve = this.getVarExpression(ctx, srcVE);
            vm.setVariable(itContext._itemId, ve);
        }
        if (itContext._indexId != null && vm != null) {
            IteratedIndexExpression ve2 = new IteratedIndexExpression(k);
            vm.setVariable(itContext._indexId, (ValueExpression)ve2);
        }
        if ((componentsCount = itContext._index - itContext._begin) != 0) {
            ve = ctx.getExpressionFactory().createValueExpression((Object)("j_id" + componentsCount), String.class);
            vm.setVariable(ITERATION_INDEX_VARIABLE, ve);
        }
    }

    private void unExposeVariables(FaceletContext ctx) {
        IterationContext itContext = this.getIterationContext();
        VariableMapper vm = ctx.getVariableMapper();
        if (itContext._itemId != null && vm != null) {
            vm.setVariable(itContext._itemId, null);
        }
        if (itContext._indexId != null && vm != null) {
            vm.setVariable(itContext._indexId, null);
        }
        vm.setVariable(ITERATION_INDEX_VARIABLE, null);
    }

    private ValueExpression getVarExpression(FaceletContext ctx, ValueExpression expr) {
        IterationContext itContext = this.getIterationContext();
        Object o = expr.getValue(ctx.getFacesContext().getELContext());
        int k = itContext._index;
        if (o.getClass().isArray() || o instanceof List) {
            return new IndexedValueExpression(expr, k);
        }
        if (o instanceof Collection || o instanceof Iterator || o instanceof Enumeration || o instanceof Map || o instanceof String) {
            if (itContext.iteratedExpression == null) {
                itContext.iteratedExpression = new IteratedExpression(expr, ",");
            }
            return new IteratedValueExpression(itContext.iteratedExpression, k);
        }
        throw new ELException("FOREACH_BAD_ITEMS");
    }

    private void release() {
        IterationContext itContext = this.getIterationContext();
        itContext.items = null;
        itContext._index = 0;
    }

    class IterationContext {
        public ForEachIterator items;
        public Object rawItems;
        public String _indexId;
        public Integer _begin;
        public Integer _end;
        public Integer _columns;
        public String _itemId = null;
        public Integer _index = 0;
        public IteratedExpression iteratedExpression;
        public String valueExpr;

        IterationContext() {
        }

        public String getVarReplacement() {
            if (this.valueExpr == null) {
                return String.valueOf(ColumnsHandler.this.index);
            }
            if (this.items.getVarReplacement() != null) {
                return this.items.getVarReplacement();
            }
            return this.valueExpr + "[" + this._index + "]";
        }

        public String getIndexReplacement() {
            return String.valueOf(this._index);
        }
    }
}

