/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.ajax4jsf.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
//
//
//


import org.ajax4jsf.renderkit.AjaxCommandRendererBase;



/**
 * Renderer for component class org.ajax4jsf.renderkit.html.CommandButtonRenderer
 */
public class CommandButtonRenderer extends AjaxCommandRendererBase {

	public CommandButtonRenderer () {
		super();
	}

	// 
	// Declarations
	//
	
    public void encodeTypeAndImage(FacesContext context, UIComponent uiComponent) throws IOException {
    	ResponseWriter writer = context.getResponseWriter();
    	String type = (String)uiComponent.getAttributes().get("type");
		String image =	(String)uiComponent.getAttributes().get("image");
		if(image != null){
			image = context.getApplication().getViewHandler().getResourceURL(context,image);
			image = context.getExternalContext().encodeResourceURL(image);
			writer.writeAttribute("type","image","image");
			writer.writeURIAttribute("src",image,"image");
			Object value;
			if (null == uiComponent.getAttributes().get("alt") &&  null != (value = uiComponent.getAttributes().get("value")) ) {
				writer.writeAttribute("alt",value,"value");
			}
		} else {
			if(null != type ){
			writer.writeAttribute("type",type.toLowerCase(),"type");
			} else {
				writer.writeAttribute("type","button","type");				
			}
		}
    }	
	
	// 
	// 
	//

	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.ajax4jsf.component.UIAjaxCommandButton.class;
	}


	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.ajax4jsf.component.UIAjaxCommandButton component, ComponentVariables variables) throws IOException {
	  java.lang.String clientId = component.getClientId(context);
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "class", component.getAttributes().get("styleClass") );
						getUtils().writeAttribute(writer, "id", clientId );
						getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "onclick", getOnClick(context,component) );
						getUtils().writeAttribute(writer, "value", getValue(component) );
			//
// pass thru attributes
//
getUtils().encodeAttributesFromArray(context,component,new String[] {
    "accept" ,
	    "accesskey" ,
	    "align" ,
	    "alt" ,
	    "checked" ,
	    "dir" ,
	    "disabled" ,
	    "lang" ,
	    "maxlength" ,
	    "onblur" ,
	    "onchange" ,
	    "ondblclick" ,
	    "onfocus" ,
	    "onkeydown" ,
	    "onkeypress" ,
	    "onkeyup" ,
	    "onmousedown" ,
	    "onmousemove" ,
	    "onmouseout" ,
	    "onmouseover" ,
	    "onmouseup" ,
	    "onselect" ,
	    "readonly" ,
	    "size" ,
	    "src" ,
	    "style" ,
	    "tabindex" ,
	    "title" ,
	    "usemap" ,
	    "xml:lang" });
//
//
//

encodeTypeAndImage(context,component);
writer.endElement("input");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.ajax4jsf.component.UIAjaxCommandButton)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
