package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIColumnGroup;
import org.richfaces.model.Ordering;

public class HtmlColumnGroup extends UIColumnGroup{

static final public  String COMPONENT_FAMILY = "org.richfaces.ColumnGroup";

static final public  String COMPONENT_TYPE = "org.richfaces.ColumnGroup";

/*
* Assigns one or more space-separated CSS class names to the columns of the table. If the CSS class names are comma-separated, 
				each class will be assigned to a particular column in the order they follow in the attribute. If you have less class names than columns, 
				the class will be applied to every n-fold column where n is the order in which the class is listed in the attribute. 
				If there are more class names than columns, the overflow ones are ignored.
*/
private  String _columnClasses = null;

/*
* Direction indication for text that does not inherit
			directionality. Valid values are "LTR" (left-to-right)
			and "RTL" (right-to-left)
*/
private  String _dir = null;

/*
* This attribute is defined with method binding. This method accepts on Object parameter and return boolean value
*/
private  MethodExpression _filterMethod = null;

/*
* Defines current filtering value
*/
private  String _filterValue = null;

/*
* Code describing the language used in the generated markup for this component
*/
private  String _lang = null;

/*
* Assigns one or more space-separated CSS class names to the rows of the table. If the CSS class names are comma-separated, 
				each class will be assigned to a particular row in the order they follow in the attribute. If you have less class names than rows, 
				the class will be applied to every n-fold row where n is the order in which the class is listed in the attribute. If there are more class names than rows, 
				the overflow ones are ignored.
*/
private  String _rowClasses = null;

/*
* Manages if the header of the column is clickable, icons rendered and sorting is fired after click on the header. You need to define this attribute inside &amp;lt;rich:dataTable&amp;gt; component.
				Default value is "true"
*/
private  boolean _selfSorted = true;

private  boolean _selfSortedSet = false;

/*
* Attribute defines a bean property which is used for sorting of a column
*/
private  String _sortExpression = null;

/*
* SortOrder is an enumeration of the possible sort orderings. Default value is "UNSORTED"
*/
private  Ordering _sortOrder = null;

/*
* Boolean attribute. If "true" it's possible to sort the column content after click on the header. Default value is "true"
*/
private  boolean _sortable = true;

private  boolean _sortableSet = false;

/*
* CSS style rules to be applied to the component
*/
private  String _style = null;

/*
* Assigns one or more CSS class names to the component. Corresponds to the HTML "class" attribute.
*/
private  String _styleClass = null;

/*
* Advisory title information about markup elements generated for this component
*/
private  String _title = null;


public HtmlColumnGroup(){
setRendererType("org.richfaces.ColumnGroupRenderer");
}

public String getColumnClasses(){
	if (this._columnClasses != null) {
		return this._columnClasses;
	}
	ValueExpression ve = getValueExpression("columnClasses");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setColumnClasses(String _columnClasses){
this._columnClasses = _columnClasses;
}

public String getDir(){
	if (this._dir != null) {
		return this._dir;
	}
	ValueExpression ve = getValueExpression("dir");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDir(String _dir){
this._dir = _dir;
}

public MethodExpression getFilterMethod(){
return _filterMethod;
}

public void setFilterMethod(MethodExpression _filterMethod){
this._filterMethod = _filterMethod;
}

public String getFilterValue(){
	if (this._filterValue != null) {
		return this._filterValue;
	}
	ValueExpression ve = getValueExpression("filterValue");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFilterValue(String _filterValue){
this._filterValue = _filterValue;
}

public String getLang(){
	if (this._lang != null) {
		return this._lang;
	}
	ValueExpression ve = getValueExpression("lang");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLang(String _lang){
this._lang = _lang;
}

public String getRowClasses(){
	if (this._rowClasses != null) {
		return this._rowClasses;
	}
	ValueExpression ve = getValueExpression("rowClasses");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setRowClasses(String _rowClasses){
this._rowClasses = _rowClasses;
}

public boolean isSelfSorted(){
	if (this._selfSortedSet) {
	    return (this._selfSorted);
	}
	ValueExpression ve = getValueExpression("selfSorted");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._selfSorted);
	    }
	    
	    return value;
	} else {
	    return (this._selfSorted);
	}

}

public void setSelfSorted(boolean _selfSorted){
this._selfSorted = _selfSorted;
this._selfSortedSet = true;
}

public String getSortExpression(){
	if (this._sortExpression != null) {
		return this._sortExpression;
	}
	ValueExpression ve = getValueExpression("sortExpression");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSortExpression(String _sortExpression){
this._sortExpression = _sortExpression;
}

public Ordering getSortOrder(){
	if (this._sortOrder != null) {
		return this._sortOrder;
	}
	ValueExpression ve = getValueExpression("sortOrder");
	if (ve != null) {
	    Ordering value = null;
	    
	    try {
			value = (Ordering) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return Ordering.UNSORTED;
	

}

public void setSortOrder(Ordering _sortOrder){
this._sortOrder = _sortOrder;
}

public boolean isSortable(){
	if (this._sortableSet) {
	    return (this._sortable);
	}
	ValueExpression ve = getValueExpression("sortable");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._sortable);
	    }
	    
	    return value;
	} else {
	    return (this._sortable);
	}

}

public void setSortable(boolean _sortable){
this._sortable = _sortable;
this._sortableSet = true;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getTitle(){
	if (this._title != null) {
		return this._title;
	}
	ValueExpression ve = getValueExpression("title");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTitle(String _title){
this._title = _title;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[16];
state[0] = super.saveState(context);
state[1] = _columnClasses;
state[2] = _dir;
state[3] = saveAttachedState(context, _filterMethod);
state[4] = _filterValue;
state[5] = _lang;
state[6] = _rowClasses;
state[7] = Boolean.valueOf(_selfSorted);
state[8] = Boolean.valueOf(_selfSortedSet);
state[9] = _sortExpression;
state[10] = saveAttachedState(context, _sortOrder);
state[11] = Boolean.valueOf(_sortable);
state[12] = Boolean.valueOf(_sortableSet);
state[13] = _style;
state[14] = _styleClass;
state[15] = _title;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_columnClasses = (String)states[1];;
		_dir = (String)states[2];;
		_filterMethod = (MethodExpression)restoreAttachedState(context, states[3]);
		_filterValue = (String)states[4];;
		_lang = (String)states[5];;
		_rowClasses = (String)states[6];;
		_selfSorted = ((Boolean)states[7]).booleanValue();
		_selfSortedSet = ((Boolean)states[8]).booleanValue();
		_sortExpression = (String)states[9];;
		_sortOrder = (Ordering)restoreAttachedState(context, states[10]);
		_sortable = ((Boolean)states[11]).booleanValue();
		_sortableSet = ((Boolean)states[12]).booleanValue();
		_style = (String)states[13];;
		_styleClass = (String)states[14];;
		_title = (String)states[15];;
	
}

}
