/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.Bounds1D;
import com.googlecode.whatswrong.Edge;
import com.googlecode.whatswrong.NLPCanvasRenderer;
import com.googlecode.whatswrong.NLPInstance;
import com.googlecode.whatswrong.Token;
import com.googlecode.whatswrong.TokenLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.Map;

public class AlignmentRenderer
implements NLPCanvasRenderer {
    private TokenLayout tokenLayout1 = new TokenLayout();
    private TokenLayout tokenLayout2 = new TokenLayout();
    private boolean antiAliasing = true;
    private int heightFactor = 100;
    private boolean isCurved = true;

    public AlignmentRenderer() {
        this.tokenLayout1.setToSplitPoint(0);
        this.tokenLayout2.setFromSplitPoint(0);
    }

    public Dimension render(NLPInstance instance, Graphics2D graphics2D) {
        Map<Token, Bounds1D> tokenXBounds1 = this.tokenLayout1.estimateTokenBounds(instance, Collections.<Token, Integer>emptyMap(), graphics2D);
        Map<Token, Bounds1D> tokenXBounds2 = this.tokenLayout2.estimateTokenBounds(instance, Collections.<Token, Integer>emptyMap(), graphics2D);
        if (this.antiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int width = 0;
        int height = 0;
        Dimension dim = this.tokenLayout1.layout(instance, Collections.<Token, Integer>emptyMap(), graphics2D);
        height += dim.height;
        width = dim.width > width ? dim.width : width;
        for (Edge edge : instance.getEdges(Edge.RenderType.dependency)) {
            if ("FP".equals(edge.getTypePostfix())) {
                graphics2D.setColor(Color.RED);
            } else if ("FN".equals(edge.getTypePostfix())) {
                graphics2D.setColor(Color.BLUE);
            } else {
                graphics2D.setColor(Color.BLACK);
            }
            Bounds1D bound1 = tokenXBounds1.get(edge.getFrom());
            Bounds1D bound2 = tokenXBounds2.get(edge.getTo());
            if (this.isCurved) {
                GeneralPath shape = new GeneralPath();
                shape.moveTo(bound1.getMiddle(), height);
                shape.curveTo(bound1.getMiddle(), height + this.heightFactor / 2, bound2.getMiddle(), height + this.heightFactor / 2, bound2.getMiddle(), height + this.heightFactor);
                graphics2D.draw(shape);
                continue;
            }
            graphics2D.drawLine(bound1.getMiddle(), height, bound2.getMiddle(), height + this.heightFactor);
        }
        graphics2D.translate(0, dim.height + this.heightFactor);
        dim = this.tokenLayout2.layout(instance, Collections.<Token, Integer>emptyMap(), graphics2D);
        width = dim.width > width ? dim.width : width;
        return new Dimension(width, (height += dim.height + this.heightFactor) + 1);
    }

    public void setAntiAliasing(boolean antiAliasing) {
        this.antiAliasing = antiAliasing;
    }

    public void setMargin(int margin) {
        this.tokenLayout1.setMargin(margin);
        this.tokenLayout2.setMargin(margin);
    }

    public int getMargin() {
        return this.tokenLayout1.getMargin();
    }

    public Edge getEdgeAt(Point2D p, int radius) {
        return null;
    }

    public void setHeightFactor(int heightFactor) {
        this.heightFactor = heightFactor * 4;
    }

    public int getHeightFactor() {
        return this.heightFactor / 4;
    }

    public void setCurved(boolean isCurved) {
        this.isCurved = isCurved;
    }

    public boolean isCurved() {
        return this.isCurved;
    }

    public void setEdgeTypeColor(String edgeType, Color color) {
    }

    public void setEdgeTypeOrder(String edgeType, int order) {
    }

    public boolean isAntiAliasing() {
        return this.antiAliasing;
    }
}

