/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.NLPInstance;
import com.googlecode.whatswrong.SimpleGridBagConstraints;
import com.googlecode.whatswrong.io.BioNLP2009SharedTaskFormat;
import com.googlecode.whatswrong.io.CorpusFormat;
import com.googlecode.whatswrong.io.GaleAlignmentFormat;
import com.googlecode.whatswrong.io.GizaAlignmentFormat;
import com.googlecode.whatswrong.io.LispSExprFormat;
import com.googlecode.whatswrong.io.TabFormat;
import com.googlecode.whatswrong.io.TheBeastFormat;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.ProgressMonitor;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorpusLoader
extends JPanel {
    private List<NLPInstance> selected;
    private List<List<NLPInstance>> corpora;
    private DefaultListModel fileNames;
    private HashMap<String, CorpusFormat> formats = new HashMap();
    private ArrayList<Listener> changeListeners = new ArrayList();
    private JButton remove;
    private JFileChooser fileChooser;
    private String id;
    private LoadAccessory accessory;

    public void addChangeListener(Listener changeListener) {
        this.changeListeners.add(changeListener);
    }

    private void fireAdded(List<NLPInstance> corpus) {
        for (Listener listener : this.changeListeners) {
            listener.corpusAdded(corpus, this);
        }
    }

    private void fireRemoved(List<NLPInstance> corpus) {
        for (Listener listener : this.changeListeners) {
            listener.corpusRemoved(corpus, this);
        }
    }

    private void fireSelected(List<NLPInstance> corpus) {
        for (Listener listener : this.changeListeners) {
            listener.corpusSelected(corpus, this);
        }
    }

    public List<NLPInstance> getSelected() {
        return this.selected == null ? null : Collections.unmodifiableList(this.selected);
    }

    public void addFormat(CorpusFormat format) {
        this.formats.put(format.getName(), format);
    }

    public void setDirectory(String dir) {
        this.fileChooser.setCurrentDirectory(new File(dir));
    }

    public String getDirectory() {
        return this.fileChooser.getCurrentDirectory().getPath();
    }

    public void loadProperties(Properties properties) {
        this.setDirectory(properties.getProperty(this.property("dir"), ""));
        String formatString = properties.getProperty(this.property("format"), "TAB-separated");
        if (formatString.equals("CoNLL")) {
            formatString = "TAB-separated";
        }
        this.accessory.filetypeComboBox.setSelectedItem(this.formats.get(formatString));
        for (CorpusFormat format : this.formats.values()) {
            format.loadProperties(properties, this.id);
        }
    }

    private String property(String name) {
        return this.id + "." + name;
    }

    public void saveProperties(Properties properties) {
        properties.setProperty(this.property("dir"), this.getDirectory());
        properties.setProperty(this.property("format"), this.accessory.filetypeComboBox.getSelectedItem().toString());
        for (CorpusFormat format : this.formats.values()) {
            format.saveProperties(properties, this.id);
        }
    }

    public CorpusLoader(String title) {
        this.id = title.replaceAll(" ", "_").toLowerCase();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagConstraints c = new GridBagConstraints();
        this.setUpFormats();
        this.corpora = new ArrayList<List<NLPInstance>>();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        this.add((Component)new JLabel(title), c);
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        this.fileNames = new DefaultListModel();
        final JList files = new JList(this.fileNames);
        files.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (files.getSelectedIndex() == -1) {
                    CorpusLoader.this.selected = null;
                    CorpusLoader.this.remove.setEnabled(false);
                    CorpusLoader.this.fireSelected(null);
                } else {
                    CorpusLoader.this.selected = (List)CorpusLoader.this.corpora.get(files.getSelectedIndex());
                    CorpusLoader.this.remove.setEnabled(true);
                    CorpusLoader.this.fireSelected(CorpusLoader.this.selected);
                }
            }
        });
        files.setSelectionMode(0);
        JScrollPane pane = new JScrollPane(files);
        pane.setPreferredSize(new Dimension(150, 100));
        this.add((Component)pane, c);
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileSelectionMode(2);
        this.fileChooser.setDialogTitle("Load Corpus");
        this.accessory = new LoadAccessory();
        this.fileChooser.setAccessory(this.accessory);
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 0;
        c.weighty = 0.0;
        JButton add = new JButton("Add");
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = CorpusLoader.this.fileChooser.showOpenDialog(CorpusLoader.this);
                if (returnVal == 0) {
                    final ProgressMonitor monitor = new ProgressMonitor(CorpusLoader.this, "Loading data", null, 0, CorpusLoader.this.accessory.getEnd() - 1);
                    new Thread(new Runnable(){

                        public void run() {
                            CorpusFormat format = new TheBeastFormat();
                            try {
                                monitor.setProgress(0);
                                CorpusLoader.this.setCursor(Cursor.getPredefinedCursor(3));
                                format = CorpusLoader.this.accessory.getFormat();
                                format.setMonitor(new CorpusFormat.Monitor(){

                                    public void progressed(int index) {
                                        monitor.setProgress(index);
                                    }
                                });
                                List<NLPInstance> corpus = format.load(CorpusLoader.this.fileChooser.getSelectedFile(), CorpusLoader.this.accessory.getStart(), CorpusLoader.this.accessory.getEnd());
                                if (corpus.size() == 0) {
                                    throw new RuntimeException("No instances in corpus.");
                                }
                                monitor.close();
                                CorpusLoader.this.setCursor(Cursor.getPredefinedCursor(0));
                                CorpusLoader.this.corpora.add(corpus);
                                CorpusLoader.this.fileNames.addElement(CorpusLoader.this.fileChooser.getSelectedFile().getName());
                                files.setSelectedIndex(CorpusLoader.this.fileNames.size() - 1);
                                CorpusLoader.this.fireAdded(corpus);
                            }
                            catch (FileNotFoundException e1) {
                                e1.printStackTrace();
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                JOptionPane.showMessageDialog(CorpusLoader.this, "<html>Data could not be loaded with the <br><b>" + format.getLongName() + "</b> format.\nThis means that either you chose the wrong " + "format, \nthe format of file you selected is broken, \nor we " + "made a terrible mistake.", "Corpus format problem", 0);
                            }
                        }
                    }).start();
                }
            }
        });
        this.add((Component)add, c);
        c.gridx = 1;
        this.remove = new JButton("Remove");
        this.remove.setEnabled(false);
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = files.getSelectedIndex();
                if (index != -1) {
                    CorpusLoader.this.fileNames.remove(index);
                    List corpus = (List)CorpusLoader.this.corpora.remove(index);
                    CorpusLoader.this.fireRemoved(corpus);
                }
            }
        });
        this.add((Component)this.remove, c);
    }

    private void setUpFormats() {
        TabFormat tabFormat = new TabFormat();
        TheBeastFormat theBeastFormat = new TheBeastFormat();
        this.addFormat(tabFormat);
        this.addFormat(theBeastFormat);
        this.addFormat(new LispSExprFormat());
        this.addFormat(new GaleAlignmentFormat());
        this.addFormat(new BioNLP2009SharedTaskFormat());
        this.addFormat(new BioNLP2009SharedTaskFormat());
        this.addFormat(new GizaAlignmentFormat());
    }

    private class LoadAccessory
    extends JPanel {
        private JComboBox filetypeComboBox;
        private JSpinner start;
        private JSpinner end;
        private JPanel accessoryCards;

        public LoadAccessory() {
            this.setLayout(new GridBagLayout());
            this.setBorder(new TitledBorder(new EtchedBorder(), "Parameters"));
            int y = 0;
            this.add((Component)new JLabel("Format:"), new SimpleGridBagConstraints(y, true));
            this.filetypeComboBox = new JComboBox(new Vector(CorpusLoader.this.formats.values()));
            this.filetypeComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ((CardLayout)LoadAccessory.this.accessoryCards.getLayout()).show(LoadAccessory.this.accessoryCards, LoadAccessory.this.filetypeComboBox.getSelectedItem().toString());
                }
            });
            this.start = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
            this.start.setPreferredSize(new Dimension(100, (int)this.start.getPreferredSize().getHeight()));
            this.end = new JSpinner(new SpinnerNumberModel(200, 0, Integer.MAX_VALUE, 1));
            this.end.setPreferredSize(new Dimension(100, (int)this.start.getPreferredSize().getHeight()));
            this.accessoryCards = new JPanel(new CardLayout());
            for (CorpusFormat f : CorpusLoader.this.formats.values()) {
                this.accessoryCards.add((Component)f.getAccessory(), f.toString());
            }
            ((CardLayout)this.accessoryCards.getLayout()).show(this.accessoryCards, this.filetypeComboBox.getSelectedItem().toString());
            this.add((Component)this.filetypeComboBox, new SimpleGridBagConstraints(y++, false));
            this.add((Component)new JSeparator(), new SimpleGridBagConstraints(0, y++, 2, 1));
            this.add((Component)this.accessoryCards, new SimpleGridBagConstraints(0, y++, 2, 1));
            this.add((Component)new JSeparator(), new SimpleGridBagConstraints(0, y++, 2, 1));
            this.add((Component)new JLabel("From:"), new SimpleGridBagConstraints(y, true));
            this.add((Component)this.start, new SimpleGridBagConstraints(y++, false));
            this.add((Component)new JLabel("To:"), new SimpleGridBagConstraints(y, true));
            this.add((Component)this.end, new SimpleGridBagConstraints(y, false));
        }

        public CorpusFormat getFormat() {
            return (CorpusFormat)this.filetypeComboBox.getSelectedItem();
        }

        public int getStart() {
            return (Integer)this.start.getModel().getValue();
        }

        public int getEnd() {
            return (Integer)this.end.getModel().getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Listener {
        public void corpusAdded(List<NLPInstance> var1, CorpusLoader var2);

        public void corpusRemoved(List<NLPInstance> var1, CorpusLoader var2);

        public void corpusSelected(List<NLPInstance> var1, CorpusLoader var2);
    }
}

