/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.ControllerPanel;
import com.googlecode.whatswrong.EdgeLabelFilter;
import com.googlecode.whatswrong.EdgeTokenFilter;
import com.googlecode.whatswrong.FilterTextField;
import com.googlecode.whatswrong.NLPCanvas;
import com.googlecode.whatswrong.SimpleGridBagConstraints;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class DependencyFilterPanel
extends ControllerPanel {
    public DependencyFilterPanel(final NLPCanvas nlpCanvas, final EdgeLabelFilter edgeLabelFilter, final EdgeTokenFilter edgeTokenFilter) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.weightx = 0.0;
        c.anchor = 13;
        this.add((Component)new JLabel("Label:"), c);
        final FilterTextField labelField = new FilterTextField("text,text,...");
        labelField.setColumns(10);
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 1;
        this.add((Component)labelField, c);
        labelField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String[] split;
                edgeLabelFilter.clear();
                for (String label : split = labelField.getText().split("[,]")) {
                    edgeLabelFilter.addAllowedLabel(label);
                }
                nlpCanvas.updateNLPGraphics();
            }
        });
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        this.add((Component)new JLabel("Token:"), c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        final FilterTextField tokenTextField = new FilterTextField("text1,2-5,...");
        tokenTextField.setColumns(10);
        this.add((Component)tokenTextField, c);
        tokenTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String[] split;
                edgeTokenFilter.clear();
                for (String property : split = tokenTextField.getText().split("[,]")) {
                    edgeTokenFilter.addAllowedProperty(property);
                }
                nlpCanvas.updateNLPGraphics();
            }
        });
        final JCheckBox usePaths = new JCheckBox("Only Paths", edgeTokenFilter.isUsePaths());
        usePaths.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                edgeTokenFilter.setUsePaths(usePaths.isSelected());
                nlpCanvas.updateNLPGraphics();
            }
        });
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        this.add((Component)new JLabel("Options:"), c);
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 17;
        this.add((Component)usePaths, c);
        final JCheckBox collaps = new JCheckBox("Collaps");
        collaps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                edgeTokenFilter.setCollaps(collaps.isSelected());
                nlpCanvas.updateNLPGraphics();
            }
        });
        this.add((Component)collaps, new SimpleGridBagConstraints(3, false));
        final JCheckBox wholeWords = new JCheckBox("Whole Words");
        wholeWords.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                edgeTokenFilter.setWholeWords(wholeWords.isSelected());
                nlpCanvas.updateNLPGraphics();
            }
        });
        this.add((Component)wholeWords, new SimpleGridBagConstraints(4, false));
    }
}

