/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.AbstractEdgeLayout;
import com.googlecode.whatswrong.Bounds1D;
import com.googlecode.whatswrong.Edge;
import com.googlecode.whatswrong.Token;
import com.googlecode.whatswrong.javautils.Counter;
import com.googlecode.whatswrong.javautils.HashMultiMapLinkedList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyLayout
extends AbstractEdgeLayout {
    private int arrowSize = 2;

    public Dimension layoutEdges(Collection<Edge> edges, Map<Token, Bounds1D> bounds, Graphics2D g2d) {
        if (this.visible.size() > 0) {
            edges = new HashSet<Edge>(edges);
            edges.retainAll(this.visible);
        }
        this.shapes.clear();
        HashMultiMapLinkedList<Token, Edge> loops = new HashMultiMapLinkedList<Token, Edge>();
        HashSet<Edge> allLoops = new HashSet<Edge>();
        HashSet<Token> tokens = new HashSet<Token>();
        for (Edge edge : edges) {
            tokens.add(edge.getFrom());
            tokens.add(edge.getTo());
            if (edge.getFrom() != edge.getTo()) continue;
            loops.add(edge.getFrom(), edge);
            allLoops.add(edge);
        }
        edges.removeAll(allLoops);
        Counter<Edge> depth = new Counter<Edge>();
        Counter<Edge> offset = new Counter<Edge>();
        HashMultiMapLinkedList<Edge, Edge> dominates = new HashMultiMapLinkedList<Edge, Edge>();
        for (Edge over : edges) {
            for (Edge under : edges) {
                if (over == under || !over.covers(under) && !over.coversSemi(under) && (!over.coversExactly(under) || over.lexicographicOrder(under) <= 0)) continue;
                dominates.add(over, under);
            }
        }
        for (Edge edge : edges) {
            this.calculateDepth(dominates, depth, edge);
        }
        for (Edge left : edges) {
            for (Edge right : edges) {
                if (left == right || !left.crosses(right) || !depth.get(left).equals(depth.get(right))) continue;
                if (offset.get(left) == 0 && offset.get(right) == 0) {
                    offset.increment(left, this.heightPerLevel / 2);
                    continue;
                }
                if (!offset.get(left).equals(offset.get(right))) continue;
                offset.put(left, this.heightPerLevel / 3);
                offset.put(right, this.heightPerLevel * 2 / 3);
            }
        }
        int maxHeight = (depth.getMaximum() + 1) * this.heightPerLevel + 3;
        if (depth.getMaximum() == 0 && allLoops.size() > 0) {
            maxHeight += this.heightPerLevel / 2;
        }
        HashMultiMapLinkedList<Token, Edge> vertex2edges = new HashMultiMapLinkedList<Token, Edge>();
        for (Edge edge : edges) {
            vertex2edges.add(edge.getFrom(), edge);
            vertex2edges.add(edge.getTo(), edge);
        }
        this.from = new HashMap();
        this.to = new HashMap();
        for (final Token token : tokens) {
            Point point;
            Edge loop;
            Object connections = vertex2edges.get(token);
            Collections.sort(connections, new Comparator<Edge>(){

                @Override
                public int compare(Edge edge1, Edge edge2) {
                    if (edge1.leftOf(token) && edge2.rightOf(token)) {
                        return -1;
                    }
                    if (edge2.leftOf(token) && edge1.rightOf(token)) {
                        return 1;
                    }
                    int diff = edge2.getLength() - edge1.getLength();
                    if (edge1.leftOf(token) && edge2.leftOf(token)) {
                        return diff != 0 ? -diff : edge1.lexicographicOrder(edge2);
                    }
                    return diff != 0 ? diff : edge2.lexicographicOrder(edge1);
                }
            });
            Object loopsOnVertex = loops.get(token);
            double width = (double)(bounds.get(token).getWidth() + this.vertexExtraSpace) / ((double)connections.size() + 1.0 + (double)(loopsOnVertex.size() * 2));
            double x = (double)bounds.get((Object)token).from - (double)this.vertexExtraSpace / 2.0 + width;
            Iterator i$ = loopsOnVertex.iterator();
            while (i$.hasNext()) {
                loop = (Edge)i$.next();
                point = new Point((int)x, this.baseline + maxHeight);
                this.from.put(loop, point);
                x += width;
            }
            i$ = connections.iterator();
            while (i$.hasNext()) {
                Edge edge = (Edge)i$.next();
                point = new Point((int)x, this.baseline + maxHeight);
                if (edge.getFrom().equals(token)) {
                    this.from.put(edge, point);
                } else {
                    this.to.put(edge, point);
                }
                x += width;
            }
            i$ = loopsOnVertex.iterator();
            while (i$.hasNext()) {
                loop = (Edge)i$.next();
                point = new Point((int)x, this.baseline + maxHeight);
                this.to.put(loop, point);
                x += width;
            }
        }
        edges.addAll(allLoops);
        for (Edge edge : edges) {
            Point p1;
            Color old = g2d.getColor();
            g2d.setColor(this.getColor(edge.getType()));
            int height = this.baseline + maxHeight - (depth.get(edge) + 1) * this.heightPerLevel + offset.get(edge);
            if (edge.getFrom() == edge.getTo()) {
                height -= this.heightPerLevel / 2;
            }
            if ((p1 = (Point)this.from.get(edge)) == null) {
                System.out.println(edge);
            }
            Point p2 = new Point(p1.x, height);
            Point p4 = (Point)this.to.get(edge);
            if (p4 == null) {
                System.out.println(edges);
            }
            Point p3 = new Point(p4.x, height);
            g2d.setStroke(this.getStroke(edge));
            GeneralPath shape = this.curve ? this.createCurveArrow(p1, p2, p3, p4) : this.createRectArrow(p1, p2, p3, p4);
            g2d.draw(shape);
            g2d.drawLine(p4.x - this.arrowSize, p4.y - this.arrowSize, p4.x, p4.y);
            g2d.drawLine(p4.x + this.arrowSize, p4.y - this.arrowSize, p4.x, p4.y);
            Font font = new Font(g2d.getFont().getName(), 0, 8);
            FontRenderContext frc = g2d.getFontRenderContext();
            TextLayout layout = new TextLayout(edge.getLabelWithNote(), font, frc);
            int labelx = (int)((double)(Math.min(p1.x, p3.x) + Math.abs(p1.x - p3.x) / 2) - layout.getBounds().getWidth() / 2.0);
            int labely = (int)((float)height + layout.getAscent()) + 1;
            layout.draw(g2d, labelx, labely);
            g2d.setColor(old);
            this.shapes.put(shape, edge);
        }
        int maxWidth = 0;
        for (Point p : this.from.values()) {
            if (!(p.getX() > (double)maxWidth)) continue;
            maxWidth = (int)p.getX();
        }
        for (Point p : this.to.values()) {
            if (!(p.getX() > (double)maxWidth)) continue;
            maxWidth = (int)p.getX();
        }
        return new Dimension(maxWidth + this.arrowSize + 2, maxHeight);
    }

    private GeneralPath createRectArrow(Point p1, Point p2, Point p3, Point p4) {
        GeneralPath shape = new GeneralPath();
        shape.moveTo(p1.x, p1.y);
        shape.lineTo(p2.x, p2.y);
        shape.lineTo(p3.x, p3.y);
        shape.lineTo(p4.x, p4.y);
        return shape;
    }

    private GeneralPath createCurveArrow(Point p1, Point p2, Point p3, Point p4) {
        GeneralPath shape = new GeneralPath();
        shape.moveTo(p1.x, p1.y);
        shape.curveTo(p2.x, p2.y, p2.x, p2.y, p2.x + (p3.x - p2.x) / 2, p2.y);
        shape.curveTo(p3.x, p3.y, p3.x, p3.y, p4.x, p4.y);
        shape.moveTo(p3.x, p3.y);
        shape.closePath();
        return shape;
    }

    public void setArrowSize(int arrowSize) {
        this.arrowSize = arrowSize;
    }

    public int getArrowSize() {
        return this.arrowSize;
    }
}

