/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.Edge;
import com.googlecode.whatswrong.NLPInstance;
import com.googlecode.whatswrong.NLPInstanceFilter;
import com.googlecode.whatswrong.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeTokenFilter
implements NLPInstanceFilter {
    private HashSet<String> allowedProperties = new HashSet();
    private boolean usePaths = false;
    private boolean collaps = false;
    private boolean wholeWords = false;

    public EdgeTokenFilter(String ... allowedProperties) {
        this.allowedProperties.addAll(Arrays.asList(allowedProperties));
    }

    public EdgeTokenFilter(Set<String> allowedPropertyValues) {
        this.allowedProperties.addAll(allowedPropertyValues);
    }

    public boolean isCollaps() {
        return this.collaps;
    }

    public void setCollaps(boolean collaps) {
        this.collaps = collaps;
    }

    public boolean isUsePaths() {
        return this.usePaths;
    }

    public void setUsePaths(boolean usePaths) {
        this.usePaths = usePaths;
    }

    public void addAllowedProperty(String propertyValue) {
        this.allowedProperties.add(propertyValue);
    }

    public void removeAllowedProperty(String propertyValue) {
        this.allowedProperties.remove(propertyValue);
    }

    public void clear() {
        this.allowedProperties.clear();
    }

    private Paths calculatePaths(Collection<Edge> edges) {
        ArrayList<Paths> pathsPerLength = new ArrayList<Paths>();
        Paths paths = new Paths();
        for (Edge edge : edges) {
            Path path = new Path();
            path.add(edge);
            paths.addPath(edge.getFrom(), edge.getTo(), path);
            paths.addPath(edge.getTo(), edge.getFrom(), path);
        }
        pathsPerLength.add(paths);
        Paths previous = paths;
        Paths first = paths;
        do {
            paths = new Paths();
            for (Token from : previous.keySet()) {
                for (Token over : previous.getTos(from)) {
                    for (Token to : first.getTos(over)) {
                        for (Path path1 : previous.getPaths(from, over)) {
                            for (Path path2 : first.getPaths(over, to)) {
                                if (path1.containsAll(path2) || !((Edge)path1.iterator().next()).getTypePrefix().equals(((Edge)path2.iterator().next()).getTypePrefix())) continue;
                                Path path = new Path();
                                path.addAll(path1);
                                path.addAll(path2);
                                paths.addPath(from, to, path);
                                paths.addPath(to, from, path);
                            }
                        }
                    }
                }
            }
            if (!paths.isEmpty()) {
                pathsPerLength.add(paths);
            }
            previous = paths;
        } while (paths.size() > 0);
        Paths result = new Paths();
        for (Paths p : pathsPerLength) {
            for (Token from : p.keySet()) {
                for (Token to : p.getTos(from)) {
                    for (Path path : p.getPaths(from, to)) {
                        result.addPath(from, to, path);
                    }
                }
            }
        }
        return result;
    }

    public boolean isWholeWords() {
        return this.wholeWords;
    }

    public void setWholeWords(boolean wholeWords) {
        this.wholeWords = wholeWords;
    }

    public Collection<Edge> filterEdges(Collection<Edge> original) {
        if (this.allowedProperties.size() == 0) {
            return original;
        }
        if (this.usePaths) {
            Paths paths = this.calculatePaths(original);
            HashSet<Edge> result = new HashSet<Edge>();
            for (Token from : paths.keySet()) {
                if (!from.propertiesContain(this.allowedProperties, this.wholeWords)) continue;
                for (Token to : paths.getTos(from)) {
                    if (!to.propertiesContain(this.allowedProperties, this.wholeWords)) continue;
                    for (Path path : paths.getPaths(from, to)) {
                        result.addAll(path);
                    }
                }
            }
            return result;
        }
        ArrayList<Edge> result = new ArrayList<Edge>(original.size());
        for (Edge edge : original) {
            if (!edge.getFrom().propertiesContain(this.allowedProperties, this.wholeWords) && !edge.getTo().propertiesContain(this.allowedProperties, this.wholeWords)) continue;
            result.add(edge);
        }
        return result;
    }

    public boolean allows(String propertyValue) {
        return this.allowedProperties.contains(propertyValue);
    }

    @Override
    public NLPInstance filter(NLPInstance original) {
        Collection<Edge> edges = this.filterEdges(original.getEdges());
        if (!this.collaps) {
            return new NLPInstance(original.getTokens(), edges, original.getRenderType(), original.getSplitPoints());
        }
        HashSet<Token> tokens = new HashSet<Token>();
        for (Edge e : edges) {
            if (e.getRenderType() == Edge.RenderType.dependency) {
                tokens.add(e.getFrom());
                tokens.add(e.getTo());
                continue;
            }
            if (e.getRenderType() != Edge.RenderType.span) continue;
            for (int i = e.getFrom().getIndex(); i <= e.getTo().getIndex(); ++i) {
                tokens.add(original.getToken(i));
            }
        }
        ArrayList sorted = new ArrayList(tokens);
        Collections.sort(sorted, new Comparator<Token>(){

            @Override
            public int compare(Token token, Token tokenVertex1) {
                return token.getIndex() - tokenVertex1.getIndex();
            }
        });
        ArrayList<Token> updatedTokens = new ArrayList<Token>();
        HashMap<Token, Token> old2new = new HashMap<Token, Token>();
        HashMap<Token, Token> new2old = new HashMap<Token, Token>();
        for (Token t : sorted) {
            Token newToken = new Token(updatedTokens.size());
            newToken.merge(original.getTokens().get(t.getIndex()));
            old2new.put(t, newToken);
            new2old.put(newToken, t);
            updatedTokens.add(newToken);
        }
        HashSet<Edge> updatedEdges = new HashSet<Edge>();
        for (Edge e : edges) {
            updatedEdges.add(new Edge((Token)old2new.get(e.getFrom()), (Token)old2new.get(e.getTo()), e.getLabel(), e.getNote(), e.getType(), e.getRenderType(), e.getDescription()));
        }
        ArrayList<Integer> splitPoints = new ArrayList<Integer>();
        int newTokenIndex = 0;
        for (Integer oldSplitPoint : original.getSplitPoints()) {
            Token newToken = (Token)updatedTokens.get(newTokenIndex);
            Token oldToken = (Token)new2old.get(newToken);
            while (newTokenIndex + 1 < tokens.size() && oldToken.getIndex() < oldSplitPoint) {
                newToken = updatedTokens.get(++newTokenIndex);
                oldToken = (Token)new2old.get(newToken);
            }
            splitPoints.add(newTokenIndex);
        }
        return new NLPInstance(updatedTokens, updatedEdges, original.getRenderType(), splitPoints);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Paths
    extends HashMap<Token, HashMap<Token, HashSet<Path>>> {
        private Paths() {
        }

        public Set<Path> getPaths(Token from, Token to) {
            HashMap paths = (HashMap)this.get(from);
            return paths == null ? null : (HashSet)paths.get(to);
        }

        public Set<Token> getTos(Token from) {
            HashMap result = (HashMap)this.get(from);
            return result != null ? result.keySet() : new HashSet<Token>();
        }

        public void addPath(Token from, Token to, Path path) {
            HashSet<Path> set;
            HashMap<Token, HashSet<Path>> paths = (HashMap<Token, HashSet<Path>>)this.get(from);
            if (paths == null) {
                paths = new HashMap<Token, HashSet<Path>>();
                this.put(from, paths);
            }
            if ((set = (HashSet<Path>)paths.get(to)) == null) {
                set = new HashSet<Path>();
                paths.put(to, set);
            }
            set.add(path);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Path
    extends HashSet<Edge> {
        private Path() {
        }
    }
}

