/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.AbstractEdgeLayout;
import com.googlecode.whatswrong.Bounds1D;
import com.googlecode.whatswrong.Edge;
import com.googlecode.whatswrong.Token;
import com.googlecode.whatswrong.javautils.Counter;
import com.googlecode.whatswrong.javautils.HashMultiMapLinkedList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpanLayout
extends AbstractEdgeLayout {
    private boolean revert = true;
    private boolean separationLines = true;
    private HashMap<String, Integer> orders = new HashMap();
    private double totalTextMargin = 6.0;

    public SpanLayout() {
        this.baseline = 1;
    }

    public void setTypeOrder(String type, int order) {
        this.orders.put(type, order);
    }

    public int getOrder(String type) {
        Integer order = this.orders.get(type);
        return order == null ? Integer.MIN_VALUE : order;
    }

    public boolean isSeparationLines() {
        return this.separationLines;
    }

    public void setSeparationLines(boolean separationLines) {
        this.separationLines = separationLines;
    }

    public Map<Token, Integer> estimateRequiredTokenWidths(Collection<Edge> edges, Graphics2D g2d) {
        HashMap<Token, Integer> result = new HashMap<Token, Integer>();
        for (Edge edge : edges) {
            if (edge.getFrom() != edge.getTo()) continue;
            Font font = new Font(g2d.getFont().getName(), 0, 8);
            FontRenderContext frc = g2d.getFontRenderContext();
            TextLayout layout = new TextLayout(edge.getLabel(), font, frc);
            Integer oldWidth = result.get(edge.getFrom());
            int width = oldWidth == null ? (int)layout.getBounds().getWidth() : (int)Math.max(layout.getBounds().getWidth(), (double)oldWidth.intValue());
            result.put(edge.getFrom(), (int)((double)width + this.totalTextMargin));
        }
        return result;
    }

    public Dimension layoutEdges(Collection<Edge> edges, Map<Token, Bounds1D> bounds, Graphics2D g2d) {
        if (this.visible.size() > 0) {
            edges = new HashSet<Edge>(edges);
            edges.retainAll(this.visible);
        }
        this.shapes.clear();
        Counter<Edge> depth = new Counter<Edge>();
        Counter offset = new Counter();
        HashMultiMapLinkedList<Edge, Edge> dominates = new HashMultiMapLinkedList<Edge, Edge>();
        for (Edge over : edges) {
            for (Edge under : edges) {
                int orderUnder;
                int orderOver = this.getOrder(over.getTypePrefix());
                if (orderOver <= (orderUnder = this.getOrder(under.getTypePrefix())) && (orderOver != orderUnder || !over.covers(under) && !over.coversSemi(under) && (!over.coversExactly(under) || over.lexicographicOrder(under) <= 0) && (!over.overlaps(under) || over.getMinIndex() >= under.getMinIndex()))) continue;
                dominates.add(over, under);
            }
        }
        for (Edge edge : edges) {
            this.calculateDepth(dominates, depth, edge);
        }
        int maxDepth = depth.getMaximum();
        int maxHeight = edges.size() > 0 ? (maxDepth + 1) * this.heightPerLevel + 3 : 1;
        HashMultiMapLinkedList<Token, Edge> vertex2edges = new HashMultiMapLinkedList<Token, Edge>();
        for (Edge edge : edges) {
            vertex2edges.add(edge.getFrom(), edge);
            vertex2edges.add(edge.getTo(), edge);
        }
        this.from = new HashMap();
        this.to = new HashMap();
        int maxWidth = 0;
        for (Edge edge : edges) {
            Color old = g2d.getColor();
            g2d.setColor(this.getColor(edge.getType()));
            Font font = new Font(g2d.getFont().getName(), 0, 8);
            FontRenderContext frc = g2d.getFontRenderContext();
            TextLayout layout = new TextLayout(edge.getLabel(), font, frc);
            Integer spanLevel = this.revert ? maxDepth - depth.get(edge) : depth.get(edge);
            int height = this.baseline + maxHeight - (spanLevel + 1) * this.heightPerLevel + offset.get(edge);
            g2d.setStroke(this.getStroke(edge));
            int buffer = 2;
            Bounds1D fromBounds = bounds.get(edge.getFrom());
            Bounds1D toBounds = bounds.get(edge.getTo());
            int minX = Math.min(fromBounds.from, toBounds.from);
            int maxX = Math.max(fromBounds.to, toBounds.to);
            if (maxX > maxWidth) {
                maxWidth = maxX + 1;
            }
            if ((double)(maxX - minX) < layout.getBounds().getWidth() + this.totalTextMargin) {
                double middle = (double)minX + (double)(maxX - minX) / 2.0;
                double textWidth = layout.getBounds().getWidth() + this.totalTextMargin;
                minX = (int)(middle - textWidth / 2.0);
                maxX = (int)(middle + textWidth / 2.0);
            }
            RectangularShape shape = this.curve ? new RoundRectangle2D.Double(minX, height - buffer, maxX - minX, this.heightPerLevel - 2 * buffer, 8.0, 8.0) : new Rectangle2D.Double(minX, height - buffer, maxX - minX, this.heightPerLevel - 2 * buffer);
            g2d.draw(shape);
            int labelx = minX + (maxX - minX) / 2 - (int)layout.getBounds().getWidth() / 2;
            int labely = height + this.heightPerLevel / 2;
            layout.draw(g2d, labelx, labely);
            g2d.setColor(old);
            this.shapes.put(shape, edge);
        }
        for (Bounds1D bound1D : bounds.values()) {
            if (bound1D.to <= maxWidth) continue;
            maxWidth = bound1D.to;
        }
        if (this.separationLines) {
            HashMap<String, Integer> minDepths = new HashMap<String, Integer>();
            for (Edge e : edges) {
                int edgeDepth = depth.get(e);
                Integer typeDepth = (Integer)minDepths.get(e.getTypePrefix());
                if (typeDepth != null && typeDepth <= edgeDepth) continue;
                typeDepth = edgeDepth;
                minDepths.put(e.getTypePrefix(), typeDepth);
            }
            for (Integer d : minDepths.values()) {
                double height = this.baseline - 1 + (!this.revert ? maxDepth - d : d) * this.heightPerLevel;
                g2d.setColor(Color.LIGHT_GRAY);
                g2d.drawLine(0, (int)height, maxWidth, (int)height);
            }
        }
        return new Dimension(maxWidth, maxHeight);
    }
}

