/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.Edge;
import com.googlecode.whatswrong.NLPInstance;
import com.googlecode.whatswrong.NLPInstanceFilter;
import com.googlecode.whatswrong.Token;
import com.googlecode.whatswrong.TokenProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenFilter
implements NLPInstanceFilter {
    private HashSet<TokenProperty> forbiddenProperties = new HashSet();
    private HashSet<String> allowedStrings = new HashSet();
    private boolean wholeWord = false;

    public boolean isWholeWord() {
        return this.wholeWord;
    }

    public void setWholeWord(boolean wholeWord) {
        this.wholeWord = wholeWord;
    }

    public void addAllowedString(String string) {
        this.allowedStrings.add(string);
    }

    public void clearAllowedStrings() {
        this.allowedStrings.clear();
    }

    public void addForbiddenProperty(String name) {
        this.forbiddenProperties.add(new TokenProperty(name));
    }

    public void removeForbiddenProperty(String name) {
        this.forbiddenProperties.remove(new TokenProperty(name));
    }

    public Set<TokenProperty> getForbiddenTokenProperties() {
        return Collections.unmodifiableSet(this.forbiddenProperties);
    }

    public List<Token> filterTokens(Collection<Token> original) {
        ArrayList<Token> result = new ArrayList<Token>(original.size());
        for (Token vertex : original) {
            Token copy = new Token(vertex.getIndex());
            for (TokenProperty property : vertex.getPropertyTypes()) {
                if (this.forbiddenProperties.contains(property)) continue;
                copy.addProperty(property, vertex.getProperty(property));
            }
            result.add(copy);
        }
        return result;
    }

    @Override
    public NLPInstance filter(NLPInstance original) {
        if (this.allowedStrings.size() > 0) {
            HashMap<Token, Token> old2new = new HashMap<Token, Token>();
            HashMap<Token, Token> new2old = new HashMap<Token, Token>();
            ArrayList<Token> tokens = new ArrayList<Token>();
            block0: for (Token t : original.getTokens()) {
                for (TokenProperty property : t.getPropertyTypes()) {
                    String prop = t.getProperty(property);
                    for (String allowed : this.allowedStrings) {
                        if (property.getName().equals("Index") && allowed.matches("\\d+-\\d+")) {
                            String[] split = allowed.split("[-]");
                            int from = Integer.parseInt(split[0]);
                            int to = Integer.parseInt(split[1]);
                            for (int i = from; i <= to; ++i) {
                                if (!prop.equals(String.valueOf(i))) continue;
                                Token newVertex = new Token(tokens.size());
                                newVertex.merge(t);
                                tokens.add(newVertex);
                                old2new.put(t, newVertex);
                                new2old.put(newVertex, t);
                                continue block0;
                            }
                            continue;
                        }
                        if (!(this.wholeWord ? prop.equals(allowed) : prop.contains(allowed))) continue;
                        Token newVertex = new Token(tokens.size());
                        newVertex.merge(t);
                        tokens.add(newVertex);
                        old2new.put(t, newVertex);
                        new2old.put(newVertex, t);
                        continue block0;
                    }
                }
            }
            ArrayList<Edge> edges = new ArrayList<Edge>();
            for (Edge e : original.getEdges()) {
                Token newFrom = (Token)old2new.get(e.getFrom());
                Token newTo = (Token)old2new.get(e.getTo());
                if (newFrom == null || newTo == null) continue;
                edges.add(new Edge(newFrom, newTo, e.getLabel(), e.getNote(), e.getType(), e.getRenderType(), e.getDescription()));
            }
            ArrayList<Integer> splitPoints = new ArrayList<Integer>();
            int newTokenIndex = 0;
            for (Integer oldSplitPoint : original.getSplitPoints()) {
                Token newToken = tokens.get(newTokenIndex);
                Token oldToken = (Token)new2old.get(newToken);
                while (newTokenIndex + 1 < tokens.size() && oldToken.getIndex() < oldSplitPoint) {
                    newToken = tokens.get(++newTokenIndex);
                    oldToken = (Token)new2old.get(newToken);
                }
                splitPoints.add(newTokenIndex);
            }
            return new NLPInstance(this.filterTokens(tokens), edges, original.getRenderType(), splitPoints);
        }
        List<Token> filteredTokens = this.filterTokens(original.getTokens());
        return new NLPInstance(filteredTokens, original.getEdges(), original.getRenderType(), original.getSplitPoints());
    }
}

