/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.ControllerPanel;
import com.googlecode.whatswrong.FilterTextField;
import com.googlecode.whatswrong.NLPCanvas;
import com.googlecode.whatswrong.SimpleGridBagConstraints;
import com.googlecode.whatswrong.TokenFilter;
import com.googlecode.whatswrong.TokenProperty;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TokenFilterPanel
extends ControllerPanel
implements ChangeListener {
    private DefaultListModel listModel;
    private final JList list;
    private NLPCanvas canvas;
    private TokenFilter tokenFilter;

    public TokenFilterPanel(final NLPCanvas canvas, final TokenFilter tokenFilter) {
        this.tokenFilter = tokenFilter;
        this.canvas = canvas;
        canvas.addChangeListenger(this);
        this.setLayout(new BoxLayout(this, 1));
        JLabel label = new JLabel("Show Properties");
        label.setAlignmentX(0.5f);
        this.add(label);
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(2);
        this.updateProperties();
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getFirstIndex() == -1 || TokenFilterPanel.this.list.getModel().getSize() == 0) {
                    return;
                }
                for (int index = e.getFirstIndex(); index < e.getLastIndex() + 1; ++index) {
                    if (TokenFilterPanel.this.list.isSelectedIndex(index)) {
                        tokenFilter.removeForbiddenProperty(TokenFilterPanel.this.listModel.get(index).toString());
                        continue;
                    }
                    tokenFilter.addForbiddenProperty(TokenFilterPanel.this.listModel.get(index).toString());
                }
                canvas.updateNLPGraphics();
            }
        });
        JScrollPane pane = new JScrollPane(this.list);
        this.add(pane);
        this.add(new JSeparator());
        JPanel allowedTokens = new JPanel(new GridBagLayout());
        allowedTokens.add((Component)new JLabel("Token:"), new SimpleGridBagConstraints(0, true));
        final FilterTextField allowed = new FilterTextField("text,2-5,...");
        allowed.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                String[] split;
                tokenFilter.clearAllowedStrings();
                for (String property : split = allowed.getText().trim().split("[,]")) {
                    tokenFilter.addAllowedString(property);
                }
                canvas.updateNLPGraphics();
            }
        });
        allowedTokens.add((Component)allowed, new SimpleGridBagConstraints(0, false));
        allowedTokens.add((Component)new JLabel("Options:"), new SimpleGridBagConstraints(1, true));
        final JCheckBox wholeWords = new JCheckBox("Whole Words");
        wholeWords.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                tokenFilter.setWholeWord(wholeWords.isSelected());
                canvas.updateNLPGraphics();
            }
        });
        allowedTokens.add((Component)wholeWords, new SimpleGridBagConstraints(1, false));
        this.add(allowedTokens);
        pane.setPreferredSize(new Dimension(150, 100));
        pane.setMinimumSize(new Dimension(150, 100));
    }

    private void updateProperties() {
        ArrayList<TokenProperty> sorted = new ArrayList<TokenProperty>(this.canvas.getUsedProperties());
        Collections.sort(sorted);
        int index = 0;
        this.listModel.clear();
        this.listModel = new DefaultListModel();
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        for (TokenProperty p : sorted) {
            this.listModel.addElement(p);
            if (!this.tokenFilter.getForbiddenTokenProperties().contains(p) && !this.list.isSelectedIndex(index)) {
                selectionModel.addSelectionInterval(index, index);
            }
            ++index;
        }
        this.list.setModel(this.listModel);
        this.list.setSelectionModel(selectionModel);
    }

    public void stateChanged(ChangeEvent e) {
        this.updateProperties();
        this.repaint();
    }
}

