/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong.io;

import com.googlecode.whatswrong.NLPInstance;
import com.googlecode.whatswrong.TokenProperty;
import com.googlecode.whatswrong.io.TabProcessor;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoNLL2008
implements TabProcessor {
    public static final String name = "CoNLL 2008";
    private TokenProperty ne = new TokenProperty("Named Entity", 10);
    private TokenProperty bbn = new TokenProperty("Named Entity BBN", 11);
    private TokenProperty wn = new TokenProperty("WordNet", 12);

    public String toString() {
        return name;
    }

    @Override
    public NLPInstance create(List<? extends List<String>> rows) {
        NLPInstance instance = new NLPInstance();
        instance.addToken().addProperty("Word", "-Root-");
        ArrayList<Integer> predicates = new ArrayList<Integer>();
        for (List<String> list : rows) {
            instance.addToken().addProperty("Word", list.get(1)).addProperty("Index", list.get(0)).addProperty("Lemma", list.get(2)).addProperty("PoS", list.get(3)).addProperty("Split Form", list.get(5)).addProperty("Split Lemma", list.get(6)).addProperty("Split PoS", list.get(7));
            if (list.get(10).equals("_")) continue;
            int index = Integer.parseInt(list.get(0));
            predicates.add(index);
            instance.addSpan(index, index, list.get(10), "sense");
        }
        for (List<String> list : rows) {
            if (!list.get(8).equals("_")) {
                instance.addEdge(Integer.parseInt(list.get(8)), Integer.parseInt(list.get(0)), list.get(9), "dep");
            }
            for (int col = 11; col < list.size(); ++col) {
                String label = list.get(col);
                if (label.equals("_")) continue;
                Integer pred = (Integer)predicates.get(col - 11);
                int arg = Integer.parseInt(list.get(0));
                instance.addEdge(pred, arg, label, "role");
            }
        }
        return instance;
    }

    @Override
    public NLPInstance createOpen(List<? extends List<String>> rows) {
        NLPInstance instance = new NLPInstance();
        instance.addToken();
        for (List<String> list : rows) {
            instance.addToken().addProperty(this.ne, list.get(0)).addProperty(this.bbn, list.get(1)).addProperty(this.wn, list.get(2));
        }
        int index = 1;
        for (List<String> list : rows) {
            instance.addEdge(Integer.parseInt(list.get(3)), index++, list.get(4), "malt");
        }
        return instance;
    }

    @Override
    public boolean supportsOpen() {
        return true;
    }
}

