/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong.io;

import com.googlecode.whatswrong.NLPInstance;
import com.googlecode.whatswrong.io.CorpusFormat;
import com.googlecode.whatswrong.javautils.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GizaAlignmentFormat
implements CorpusFormat {
    private static final String PROPERTYSUFFIX_REVERSE = ".giza.reverse";
    private final JCheckBox reverseCheckBox = new JCheckBox("reverse?"){
        {
            this.setToolTipText(GizaAlignmentFormat.htmlLines(new String[]{"If selected, the source segments are treated as the target segments and vice versa.", "To compare a src-to-tgt alignment to a tgt-to-src alignment of the same corpus, one", "or the other (but not both) should be read in in reverse."}));
        }
    };
    private final JPanel accessory = new JPanel(){
        {
            this.add(GizaAlignmentFormat.this.reverseCheckBox);
        }
    };

    @Override
    public JComponent getAccessory() {
        return this.accessory;
    }

    @Override
    public String getLongName() {
        String result = this.getName();
        if (this.reverseCheckBox.isSelected()) {
            result = result + " (reverse)";
        }
        return result;
    }

    @Override
    public String getName() {
        return "Giza Alignment";
    }

    @Override
    public List<NLPInstance> load(File file, int from, int to) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        for (int i = 0; i < from; ++i) {
            try {
                GizaAlignmentFormat.skipAlignedSegmentPair(reader);
                continue;
            }
            catch (EndOfInputException e) {
                break;
            }
        }
        ArrayList<NLPInstance> result = new ArrayList<NLPInstance>();
        for (int i = from; i <= to; ++i) {
            NLPInstance instance;
            try {
                instance = this.loadAlignedSegmentPair(reader);
            }
            catch (EndOfInputException e) {
                break;
            }
            result.add(instance);
        }
        reader.close();
        return result;
    }

    private static void skipAlignedSegmentPair(BufferedReader reader) throws EndOfInputException, IOException {
        for (int i = 0; i < 3; ++i) {
            if (reader.readLine() != null) continue;
            throw new EndOfInputException();
        }
    }

    private NLPInstance loadAlignedSegmentPair(BufferedReader reader) throws IOException, EndOfInputException {
        if (reader.readLine() == null) {
            throw new EndOfInputException();
        }
        String[][] tokens = new String[2][];
        ArrayList<Pair<Integer, Integer>> alignmentEdges = new ArrayList<Pair<Integer, Integer>>();
        String line = reader.readLine();
        if (line == null) {
            throw new EndOfInputException();
        }
        tokens[0] = line.split(" ");
        line = reader.readLine();
        if (line == null) {
            throw new EndOfInputException();
        }
        String[] tokensWithAlignmentIndices = line.split(Pattern.quote(" }) "));
        tokens[1] = new String[tokensWithAlignmentIndices.length - 1];
        for (int i = 1; i < tokensWithAlignmentIndices.length; ++i) {
            String string = tokensWithAlignmentIndices[i];
            String[] split = string.split(Pattern.quote(" ({"), -1);
            tokens[1][i - 1] = split[0];
            String alignedIndexListAsString = split[1].trim();
            String[] alignedIndicesAsStrings = new String[]{};
            if (!alignedIndexListAsString.isEmpty()) {
                alignedIndicesAsStrings = alignedIndexListAsString.split(" ");
            }
            for (String alignedIndexAsString : alignedIndicesAsStrings) {
                int alignedIndex = Integer.parseInt(alignedIndexAsString);
                alignmentEdges.add(new Pair<Integer, Integer>(alignedIndex, i));
            }
        }
        NLPInstance instance = new NLPInstance();
        instance.setRenderType(NLPInstance.RenderType.alignment);
        if (this.reverseCheckBox.isSelected()) {
            GizaAlignmentFormat.addTokens(instance, tokens[1]);
            instance.addSplitPoint(instance.getTokens().size());
            GizaAlignmentFormat.addTokens(instance, tokens[0]);
            for (Pair pair : alignmentEdges) {
                int from = (Integer)pair.arg2 - 1;
                int to = tokens[1].length + (Integer)pair.arg1 - 1;
                GizaAlignmentFormat.addEdge(instance, from, to);
            }
        } else {
            GizaAlignmentFormat.addTokens(instance, tokens[0]);
            instance.addSplitPoint(instance.getTokens().size());
            GizaAlignmentFormat.addTokens(instance, tokens[1]);
            for (Pair pair : alignmentEdges) {
                int from = (Integer)pair.arg1 - 1;
                int to = tokens[0].length + (Integer)pair.arg2 - 1;
                GizaAlignmentFormat.addEdge(instance, from, to);
            }
        }
        return instance;
    }

    private static void addTokens(NLPInstance instance, String[] tokens) {
        for (String token : tokens) {
            instance.addToken().addProperty("word", token);
        }
    }

    private static void addEdge(NLPInstance instance, int from, int to) {
        instance.addEdge(from, to, "align", "align");
    }

    @Override
    public void loadProperties(Properties properties, String prefix) {
        String reverseString = properties.getProperty(prefix + PROPERTYSUFFIX_REVERSE);
        if (reverseString != null) {
            boolean reverse = Boolean.parseBoolean(reverseString);
            this.reverseCheckBox.setSelected(reverse);
        }
    }

    @Override
    public void saveProperties(Properties properties, String prefix) {
        properties.setProperty(prefix + PROPERTYSUFFIX_REVERSE, "" + this.reverseCheckBox.isSelected());
    }

    @Override
    public void setMonitor(CorpusFormat.Monitor monitor) {
    }

    public String toString() {
        return this.getName();
    }

    private static String htmlLines(String ... lines) {
        StringBuffer buffer = new StringBuffer("<html>");
        boolean firstLine = true;
        for (String line : lines) {
            if (!firstLine) {
                buffer.append("<br>");
            }
            buffer.append(line);
            firstLine = false;
        }
        buffer.append("</html>");
        return buffer.toString();
    }

    private static class EndOfInputException
    extends Exception {
        private EndOfInputException() {
        }
    }
}

