/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.console.bpaf;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.evt.ActivityExecEndEvent;
import org.apache.ode.bpel.evt.ActivityExecStartEvent;
import org.apache.ode.bpel.evt.ActivityFailureEvent;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.CorrelationSetWriteEvent;
import org.apache.ode.bpel.evt.ExpressionEvaluationFailedEvent;
import org.apache.ode.bpel.evt.ExpressionEvaluationSuccessEvent;
import org.apache.ode.bpel.evt.PartnerLinkModificationEvent;
import org.apache.ode.bpel.evt.ProcessCompletionEvent;
import org.apache.ode.bpel.evt.ProcessEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.evt.ProcessInstanceStartedEvent;
import org.apache.ode.bpel.evt.ProcessInstanceStateChangeEvent;
import org.apache.ode.bpel.evt.ProcessMessageExchangeEvent;
import org.apache.ode.bpel.evt.ProcessTerminationEvent;
import org.apache.ode.bpel.evt.ScopeCompletionEvent;
import org.apache.ode.bpel.evt.ScopeFaultEvent;
import org.apache.ode.bpel.evt.ScopeStartEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.utils.CollectionUtils;
import org.jboss.bpm.monitor.model.bpaf.Event;
import org.jboss.bpm.monitor.model.bpaf.Tuple;
import org.jboss.soa.bpel.console.bpaf.ActivityEndAdapter;
import org.jboss.soa.bpel.console.bpaf.ActivityFailedAdapter;
import org.jboss.soa.bpel.console.bpaf.ActivityStartAdapter;
import org.jboss.soa.bpel.console.bpaf.CorrelationSetWriteAdapter;
import org.jboss.soa.bpel.console.bpaf.ExpressionEvaluationFailedAdapter;
import org.jboss.soa.bpel.console.bpaf.ExpressionEvaluationSuccessAdapter;
import org.jboss.soa.bpel.console.bpaf.InstanceEndAdapter;
import org.jboss.soa.bpel.console.bpaf.InstanceStartAdapter;
import org.jboss.soa.bpel.console.bpaf.InstanceTerminationAdapter;
import org.jboss.soa.bpel.console.bpaf.LineNumber;
import org.jboss.soa.bpel.console.bpaf.PartnerLinkModificationAdapter;
import org.jboss.soa.bpel.console.bpaf.ProcessMessageExchangeAdapter;
import org.jboss.soa.bpel.console.bpaf.ScopeCompletionAdapter;
import org.jboss.soa.bpel.console.bpaf.ScopeFaultAdapter;
import org.jboss.soa.bpel.console.bpaf.ScopeStartAdapter;
import org.jboss.soa.bpel.console.bpaf.StateChangeAdapter;
import org.jboss.soa.bpel.console.bpaf.VariableModificationAdapter;

public class EventAdapter {
    protected static final Log log = LogFactory.getLog(EventAdapter.class);
    static Map<Class<?>, EventDetailMapping> detailMapping = new HashMap();
    private static Set<String> excludedMethods = new HashSet<String>();

    public static Event createBPAFModel(BpelEvent bpelEvent) {
        Event target = null;
        EventDetailMapping mapping = detailMapping.get(bpelEvent.getClass());
        if (mapping != null) {
            ProcessEvent source = (ProcessEvent)bpelEvent;
            target = new Event(false);
            target.setTimestamp(bpelEvent.getTimestamp().getTime());
            target.setProcessDefinitionID(source.getProcessId().toString());
            target.setProcessName(source.getProcessName().toString());
            target.setActivityName("n/a");
            target.addData((Tuple)new LineNumber(bpelEvent.getLineNo()));
            if (source instanceof ProcessInstanceEvent) {
                ProcessInstanceEvent instanceEvent = (ProcessInstanceEvent)source;
                target.setProcessInstanceID(instanceEvent.getProcessInstanceId().toString());
            }
            Tuple data = new Tuple();
            data.setName("data");
            data.setValue(EventAdapter.getProcessEventAsString(source));
            target.addData(data);
            target = mapping.adoptDetails(target, source);
        }
        return target;
    }

    private static String getProcessEventAsString(ProcessEvent event) {
        Method[] methods;
        StringBuilder sb = new StringBuilder(EventAdapter.getEventName(event));
        for (Method method : methods = event.getClass().getMethods()) {
            if (!method.getName().startsWith("get") || method.getParameterTypes().length != 0 || excludedMethods.contains(method.getName())) continue;
            try {
                String field = method.getName().substring(3);
                Object value = method.invoke((Object)event, CollectionUtils.EMPTY_OBJECT_ARRAY);
                if (value == null) continue;
                sb.append("~").append(field).append(" = ").append(value == null ? "null" : value.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    private static String getEventName(ProcessEvent event) {
        String name = event.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    static {
        detailMapping.put(ProcessInstanceStartedEvent.class, new InstanceStartAdapter());
        detailMapping.put(ProcessCompletionEvent.class, new InstanceEndAdapter());
        detailMapping.put(ProcessTerminationEvent.class, new InstanceTerminationAdapter());
        detailMapping.put(ActivityExecStartEvent.class, new ActivityStartAdapter());
        detailMapping.put(ActivityExecEndEvent.class, new ActivityEndAdapter());
        detailMapping.put(ActivityFailureEvent.class, new ActivityFailedAdapter());
        detailMapping.put(ProcessInstanceStateChangeEvent.class, new StateChangeAdapter());
        detailMapping.put(CorrelationSetWriteEvent.class, new CorrelationSetWriteAdapter());
        detailMapping.put(PartnerLinkModificationEvent.class, new PartnerLinkModificationAdapter());
        detailMapping.put(VariableModificationEvent.class, new VariableModificationAdapter());
        detailMapping.put(ProcessMessageExchangeEvent.class, new ProcessMessageExchangeAdapter());
        detailMapping.put(ExpressionEvaluationSuccessEvent.class, new ExpressionEvaluationSuccessAdapter());
        detailMapping.put(ExpressionEvaluationFailedEvent.class, new ExpressionEvaluationFailedAdapter());
        detailMapping.put(ScopeStartEvent.class, new ScopeStartAdapter());
        detailMapping.put(ScopeCompletionEvent.class, new ScopeCompletionAdapter());
        detailMapping.put(ScopeFaultEvent.class, new ScopeFaultAdapter());
        excludedMethods.add("getProcessInstanceId");
        excludedMethods.add("getScopeId");
        excludedMethods.add("getScopeDeclarationId");
        excludedMethods.add("getClass");
        excludedMethods.add("getActivityId");
        excludedMethods.add("getProcessId");
        excludedMethods.add("getProcessName");
        excludedMethods.add("getActivityDeclarationId");
        excludedMethods.add("getLineNo");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EventDetailMapping<T extends ProcessEvent> {
        public Event adoptDetails(Event var1, T var2);
    }
}

