/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.console;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.pmapi.BpelManagementFacade;
import org.apache.ode.bpel.pmapi.InstanceInfoListDocument;
import org.apache.ode.bpel.pmapi.ProcessNotFoundException;
import org.apache.ode.bpel.pmapi.TInstanceInfo;
import org.apache.ode.bpel.pmapi.TScopeInfo;
import org.apache.ode.bpel.pmapi.TVariableInfo;
import org.apache.ode.bpel.pmapi.TVariableRef;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.server.integration.ProcessManagement;
import org.jboss.soa.bpel.console.ModelAdaptor;
import org.jboss.soa.bpel.console.json.XmlToJson;
import org.riftsaw.engine.BPELEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessMgmtImpl
implements ProcessManagement {
    private BPELEngine engine;

    public ProcessMgmtImpl() {
        try {
            InitialContext ctx = new InitialContext();
            this.engine = (BPELEngine)ctx.lookup("java:jboss/BPELEngine");
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to initialize BPEL engine");
        }
    }

    private BpelManagementFacade getMgmtFacade() {
        return (BpelManagementFacade)this.engine.getManagementInterface();
    }

    public List<ProcessDefinitionRef> getProcessDefinitions() {
        return ModelAdaptor.adoptDefinitions(this.getMgmtFacade().listAllProcesses());
    }

    public ProcessDefinitionRef getProcessDefinition(String definitionId) {
        throw new RuntimeException("Not implemented");
    }

    public List<ProcessDefinitionRef> removeProcessDefinition(String definitionId) {
        throw new RuntimeException("Not implemented");
    }

    public List<ProcessInstanceRef> getProcessInstances(String definitionId) {
        String actualId = ModelAdaptor.decodeId(definitionId);
        QName processQName = QName.valueOf(actualId);
        String instanceName = processQName.getLocalPart().substring(0, processQName.getLocalPart().indexOf("-"));
        InstanceInfoListDocument result = this.getMgmtFacade().listInstances("name=" + instanceName + " namespace=" + processQName.getNamespaceURI() + " status=active", "name", 1000);
        return ModelAdaptor.adoptInstances(processQName, result);
    }

    public ProcessInstanceRef getProcessInstance(String instanceId) {
        throw new RuntimeException("Not implemented");
    }

    public ProcessInstanceRef newInstance(String defintionId) {
        throw new RuntimeException("Not implemented");
    }

    public ProcessInstanceRef newInstance(String definitionId, Map<String, Object> processVars) {
        throw new RuntimeException("Not implemented");
    }

    public Map<String, Object> getInstanceData(String instanceId) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        String iid = instanceId;
        BpelManagementFacade mgmtFacade = this.getMgmtFacade();
        TInstanceInfo instanceInfo = mgmtFacade.getInstanceInfo(Long.valueOf(iid)).getInstanceInfo();
        String scopeId = instanceInfo.getRootScope().getSiid();
        TScopeInfo scopeInfo = mgmtFacade.getScopeInfo(scopeId).getScopeInfo();
        List varRefs = scopeInfo.getVariables().getVariableRefList();
        for (TVariableRef varRef : varRefs) {
            String varName = varRef.getName();
            TVariableInfo varInfo = mgmtFacade.getVariableInfo(scopeId, varName).getVariableInfo();
            TVariableInfo.Value obj = varInfo.getValue();
            variables.put(varName, XmlToJson.parse(new ByteArrayInputStream(obj.toString().getBytes())));
        }
        return variables;
    }

    public void setInstanceData(String instanceId, Map<String, Object> data) {
        throw new RuntimeException("Not implemented");
    }

    public void endInstance(String instanceId, ProcessInstanceRef.RESULT result) {
        try {
            String iid = instanceId;
            this.getMgmtFacade().terminate(Long.valueOf(iid));
        }
        catch (ProcessNotFoundException processNotFoundException) {
            // empty catch block
        }
    }

    public void deleteInstance(String instanceId) {
        throw new RuntimeException("Not implemented");
    }

    public void setProcessState(String instanceId, ProcessInstanceRef.STATE nextState) {
        throw new RuntimeException("Not implemented");
    }

    public void signalExecution(String executionId, String signal) {
        throw new RuntimeException("Not implemented");
    }
}

