/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.console.json;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.jboss.soa.bpel.console.json.ResultAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlToJson {
    public static String parse(InputStream in) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(in);
            Element root = doc.getDocumentElement();
            XmlToJson.normalize(root);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(bout);
            MappedNamespaceConvention con = new MappedNamespaceConvention();
            ResultAdapter streamWriter = new ResultAdapter(con, writer);
            DOMSource source = new DOMSource(root);
            SAXResult output = new SAXResult(streamWriter);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(source, output);
            streamWriter.flush();
            ((Writer)writer).flush();
            return new String(bout.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException("XMLToJson failed", e);
        }
    }

    private static void normalize(Node root) {
        NodeList childNodes = root.getChildNodes();
        ArrayList<Node> tobeRemoved = new ArrayList<Node>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            short type = node.getNodeType();
            if (1 == type) {
                XmlToJson.normalize(node);
                continue;
            }
            if (3 != type || childNodes.getLength() <= 1) continue;
            tobeRemoved.add(node);
        }
        for (Node n : tobeRemoved) {
            root.removeChild(n);
        }
    }

    public static void main(String[] args) {
        String xml = "<message>\n  <ID>\n    <id>1</id>\n  </ID>\n  <Message>Hello World</Message>\n</message>";
        System.out.println(XmlToJson.parse(new ByteArrayInputStream(xml.getBytes())));
    }
}

