/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store;

import java.util.ArrayList;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.iapi.CacheProvider;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.bpel.iapi.ProcessStoreEvent;
import org.apache.ode.dao.store.ConfStoreDAOConnection;
import org.apache.ode.dao.store.ConfStoreDAOConnectionFactory;
import org.apache.ode.dao.store.DeploymentUnitDAO;
import org.apache.ode.store.DeploymentUnitDir;
import org.apache.ode.store.ProcessConfImpl;
import org.apache.ode.store.ProcessStoreImpl;
import org.riftsaw.engine.DeploymentUnit;

public class RiftSawProcessStore
extends ProcessStoreImpl {
    private static final Log LOG = LogFactory.getLog(RiftSawProcessStore.class);

    public RiftSawProcessStore(EndpointReferenceContext eprContext, TransactionManager txm, ConfStoreDAOConnectionFactory cf, CacheProvider cacheProvider) {
        super(eprContext, txm, cf, cacheProvider);
    }

    public void loadAll() {
    }

    public void deploy(DeploymentUnit bdu) {
        LOG.debug((Object)("Deploy " + bdu));
        this.doDeploy(bdu);
    }

    public void undeploy(DeploymentUnit bdu) {
        LOG.debug((Object)("Undeploy " + bdu));
        this.undeploy(bdu.getVersionedName());
    }

    protected void doDeploy(final DeploymentUnit bdu) {
        LOG.debug((Object)("Deploy scheduled: " + bdu.getDeploymentDescriptor().getParentFile()));
        final ArrayList loaded = new ArrayList();
        boolean deploy = (Boolean)this.exec((ProcessStoreImpl.Callable)new ProcessStoreImpl.Callable<Boolean>(){

            public Boolean call(ConfStoreDAOConnection conn) {
                boolean ret;
                block7: {
                    ret = false;
                    DeploymentUnitDAO dudao = conn.getDeploymentUnit(bdu.getVersionedName());
                    if (dudao == null) {
                        return true;
                    }
                    try {
                        String dir = bdu.getDeploymentDescriptor().getParentFile().getCanonicalPath();
                        if (dudao.getDeploymentUnitDir() != null && !dudao.getDeploymentUnitDir().equals(dir)) {
                            LOG.debug((Object)("Updating deployunit directory from: " + dudao.getDeploymentUnitDir() + " to: " + dir));
                            dudao.setDeploymentUnitDir(dir);
                        }
                        if (bdu.getLastModified() > dudao.getDeployDate().getTime()) {
                            ret = true;
                            break block7;
                        }
                        LOG.debug((Object)("Re-compiling: " + bdu.getDeploymentDescriptor().getParentFile()));
                        DeploymentUnitDir du = new DeploymentUnitDir(bdu.getDeploymentDescriptor().getParentFile());
                        du.setName(bdu.getVersionedName());
                        try {
                            du.compile();
                        }
                        catch (CompilationException ce) {
                            String errmsg = "Failed to compile deployment unit '" + bdu.getDeploymentDescriptor().getParentFile() + "'";
                            LOG.error((Object)errmsg, (Throwable)ce);
                            throw new ContextException(errmsg, (Throwable)ce);
                        }
                        loaded.addAll(RiftSawProcessStore.this.load(dudao));
                    }
                    catch (Throwable e) {
                        LOG.error((Object)"Failed to update deployment unit dir", e);
                    }
                }
                return ret;
            }
        });
        if (deploy) {
            LOG.debug((Object)("Deploy new version: " + bdu.getDeploymentDescriptor().getParentFile()));
            this.deploy(bdu.getDeploymentDescriptor().getParentFile(), true, bdu.getVersionedName(), false);
        } else {
            LOG.debug((Object)("Trigger Integration Layer to use existing version: " + bdu.getDeploymentDescriptor().getParentFile()));
            for (ProcessConfImpl p : loaded) {
                try {
                    this.fireStateChange(p.getProcessId(), p.getState(), p.getDeploymentUnit().getName());
                }
                catch (Exception except) {
                    LOG.error((Object)("Error while activating process: pid=" + p.getProcessId() + " package=" + p.getDeploymentUnit().getName()), (Throwable)except);
                }
            }
        }
    }

    private void fireStateChange(QName processId, ProcessState state, String duname) {
        switch (state) {
            case ACTIVE: {
                this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.ACTVIATED, processId, duname));
                break;
            }
            case DISABLED: {
                this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.DISABLED, processId, duname));
                break;
            }
            case RETIRED: {
                this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.RETIRED, processId, duname));
            }
        }
    }
}

