/*
 * Decompiled with CFR 0.152.
 */
package org.riftsaw.engine.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.DOMUtils;
import org.riftsaw.engine.DeploymentUnit;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentManager {
    private static final Log LOG = LogFactory.getLog(DeploymentManager.class);
    private String _tmpFolder = System.getProperty("java.io.tmpdir");

    public void setTemporaryFolder(String tmp) {
        this._tmpFolder = tmp == null ? System.getProperty("java.io.tmpdir") : tmp;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Set temporary folder to: " + this._tmpFolder));
        }
    }

    public String getTemporaryFolder() {
        return this._tmpFolder;
    }

    public List<DeploymentUnit> getDeploymentUnits(String deploymentName, File deploymentRoot) throws Exception {
        List<File> processes;
        Vector<DeploymentUnit> ret = new Vector<DeploymentUnit>();
        if (deploymentRoot == null || !deploymentRoot.exists()) {
            throw new IllegalArgumentException("Deployment root was not supplied, or does not exist");
        }
        boolean exploded = false;
        if (deploymentRoot.isFile()) {
            deploymentRoot = this.explodeJar(deploymentName, deploymentRoot);
            exploded = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deploy is exploded? " + exploded));
        }
        if ((processes = this.getBPELProcesses(deploymentRoot)).size() == 1 && exploded) {
            File newDir = new File(deploymentRoot.getParentFile(), this.getDeploymentUnitName(deploymentName, processes.get(0)));
            if (newDir.exists()) {
                this.delete(newDir);
            }
            if (deploymentRoot.renameTo(newDir)) {
                ret.add(this.createDeploymentUnit(newDir));
            } else {
                LOG.error((Object)("Unable to rename deployment at '" + deploymentRoot + "' to '" + newDir + "'"));
                this.copy(deploymentRoot, newDir, processes.get(0).getName(), this.getProcessLocalName(processes.get(0)));
                ret.add(this.createDeploymentUnit(newDir));
            }
        } else if (processes.size() > 0) {
            for (File bpel : processes) {
                File newDir = this.getTemporaryFolder(this.getDeploymentUnitName(deploymentName, bpel));
                if (newDir.exists()) {
                    this.delete(newDir);
                }
                this.copy(deploymentRoot, newDir, bpel.getName(), this.getProcessLocalName(bpel));
                ret.add(this.createDeploymentUnit(newDir));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Get deployment units for name '" + deploymentName + "' and root '" + deploymentRoot + " = " + ret));
        }
        return ret;
    }

    protected String getProcessLocalName(File bpel) throws Exception {
        String ret = null;
        FileInputStream is = new FileInputStream(bpel);
        byte[] b = new byte[((InputStream)is).available()];
        ((InputStream)is).read(b);
        ((InputStream)is).close();
        Element proc = DOMUtils.stringToDOM((byte[])b);
        ret = proc.getAttribute("name");
        return ret;
    }

    protected void copy(File fromDir, File toDir, String bpelFileName, String processName) throws Exception {
        if (!toDir.exists()) {
            toDir.mkdirs();
        }
        for (File f : fromDir.listFiles()) {
            if (f.isFile()) {
                if (f.getName().endsWith(".bpel") && !f.getName().equals(bpelFileName)) continue;
                FileInputStream is = new FileInputStream(f);
                FileOutputStream fos = new FileOutputStream(new File(toDir, f.getName()));
                byte[] b = new byte[((InputStream)is).available()];
                ((InputStream)is).read(b);
                if (f.getName().equals("deploy.xml")) {
                    b = this.filterDeploymentDescriptor(b, processName);
                }
                fos.write(b);
                fos.flush();
                fos.close();
                ((InputStream)is).close();
                continue;
            }
            if (!f.isDirectory()) continue;
            this.copy(f, new File(toDir, f.getName()), bpelFileName, processName);
        }
    }

    protected byte[] filterDeploymentDescriptor(byte[] b, String processName) throws Exception {
        byte[] ret = b;
        Element deploy = DOMUtils.stringToDOM((byte[])b);
        boolean changed = false;
        NodeList nl = deploy.getElementsByTagName("process");
        for (int i = nl.getLength() - 1; i >= 0; --i) {
            if (!(nl.item(i) instanceof Element)) continue;
            Element proc = (Element)nl.item(i);
            String name = proc.getAttribute("name");
            int index = name.indexOf(58);
            if (index != -1) {
                name = name.substring(index + 1);
            }
            if (name.equals(processName)) continue;
            proc.getParentNode().removeChild(proc);
            changed = true;
        }
        if (changed) {
            ret = DOMUtils.domToBytes((Element)deploy);
        }
        return ret;
    }

    protected DeploymentUnit createDeploymentUnit(File deploymentRoot) {
        DeploymentUnit ret = null;
        File deployFile = new File(deploymentRoot, "deploy.xml");
        if (!deployFile.exists()) {
            throw new IllegalArgumentException("Supplied deployment root does not contain a deploy.xml file");
        }
        String version = "1";
        String name = deploymentRoot.getName();
        int index = name.lastIndexOf(45);
        if (index != -1) {
            version = name.substring(index + 1);
            name = name.substring(0, index);
        }
        ret = new DeploymentUnit(name, version, deployFile.lastModified(), deployFile);
        return ret;
    }

    protected String getDeploymentUnitName(String deploymentName, File process) {
        String processName = process.getName().substring(0, process.getName().length() - 5);
        return deploymentName + "_" + processName;
    }

    protected File getTemporaryFolder(String deploymentName) {
        String destPath = this._tmpFolder + File.separatorChar + "riftsaw" + File.separatorChar + deploymentName;
        return new File(destPath);
    }

    private File explodeJar(String deploymentName, File deploymentRoot) throws IOException {
        File ret = this.getTemporaryFolder(deploymentName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exploring deployment name '" + deploymentName + "' at '" + deploymentRoot + "' to: " + ret));
        }
        this.delete(ret);
        ret.mkdirs();
        JarFile jarFile = new JarFile(deploymentRoot);
        Enumeration<JarEntry> iter = jarFile.entries();
        while (iter.hasMoreElements()) {
            JarEntry entry = iter.nextElement();
            String entryPath = ret.getAbsolutePath() + File.separatorChar;
            entryPath = entryPath + entry.getName();
            File entryFile = new File(entryPath);
            if (entry.isDirectory()) {
                entryFile.mkdirs();
                continue;
            }
            InputStream is = jarFile.getInputStream(entry);
            FileOutputStream fos = new FileOutputStream(entryFile);
            byte[] b = new byte[is.available()];
            is.read(b);
            fos.write(b);
            fos.flush();
            fos.close();
            is.close();
        }
        jarFile.close();
        return ret;
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.delete(f);
            }
        }
        file.delete();
    }

    protected List<File> getBPELProcesses(File deploymentRoot) {
        Vector<File> ret = new Vector<File>();
        if (!deploymentRoot.isDirectory()) {
            throw new IllegalArgumentException("Deployment root must be a directory");
        }
        this.findBPELProcesses(deploymentRoot, ret);
        Collections.sort(ret, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found BPEL processes under '" + deploymentRoot + "' are: " + ret));
        }
        return ret;
    }

    protected void findBPELProcesses(File file, List<File> processes) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.findBPELProcesses(f, processes);
            }
        } else if (file.getName().endsWith(".bpel")) {
            processes.add(file);
        }
    }
}

